/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.Objects;
import mods.railcraft.api.signal.BlockSignalEntity;
import mods.railcraft.api.signal.TokenSignalEntity;
import mods.railcraft.api.signal.entity.SignalControllerEntity;
import mods.railcraft.client.util.LineRenderer;
import mods.railcraft.world.item.GogglesItem;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SignalAuraRenderUtil {
    public static void tryRenderSignalAura(BlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource) {
        LineRenderer lineRenderer = LineRenderer.simple(bufferSource);
        if (blockEntity instanceof SignalControllerEntity) {
            SignalControllerEntity provider = (SignalControllerEntity)blockEntity;
            SignalAuraRenderUtil.renderControllerAura(blockEntity.getBlockPos(), poseStack, lineRenderer, provider);
        }
        if (blockEntity instanceof BlockSignalEntity) {
            BlockSignalEntity blockSignal = (BlockSignalEntity)blockEntity;
            SignalAuraRenderUtil.renderBlockSignalAura(blockEntity.getBlockPos(), poseStack, lineRenderer, blockSignal);
        } else if (blockEntity instanceof TokenSignalEntity) {
            TokenSignalEntity tokenSignal = (TokenSignalEntity)blockEntity;
            SignalAuraRenderUtil.renderTokenSignalAura(blockEntity.getBlockPos(), poseStack, lineRenderer, tokenSignal);
        }
    }

    private static void renderControllerAura(BlockPos blockPos, PoseStack poseStack, LineRenderer lineRenderer, SignalControllerEntity provider) {
        Collection<BlockPos> peers = provider.getSignalController().peers();
        if (GogglesItem.isGoggleAuraActive(GogglesItem.Aura.TUNING)) {
            SignalAuraRenderUtil.renderSignalAura(blockPos, poseStack, lineRenderer, peers, SignalAuraRenderUtil::rainbow);
        } else if (GogglesItem.isGoggleAuraActive(GogglesItem.Aura.SIGNALLING)) {
            SignalAuraRenderUtil.renderSignalAura(blockPos, poseStack, lineRenderer, peers, ColorSupplier.of(provider.getSignalController().aspect().color()));
        }
    }

    private static void renderBlockSignalAura(BlockPos blockPos, PoseStack poseStack, LineRenderer lineRenderer, BlockSignalEntity blockSignal) {
        Collection<BlockPos> peers = blockSignal.signalNetwork().peers();
        if (GogglesItem.isGoggleAuraActive(GogglesItem.Aura.SURVEYING)) {
            SignalAuraRenderUtil.renderSignalAura(blockPos, poseStack, lineRenderer, peers, SignalAuraRenderUtil::rainbow);
        } else if (GogglesItem.isGoggleAuraActive(GogglesItem.Aura.SIGNALLING)) {
            SignalAuraRenderUtil.renderSignalAura(blockPos, poseStack, lineRenderer, peers, ColorSupplier.CONSTANT_BLUE);
        }
    }

    private static void renderTokenSignalAura(BlockPos blockPos, PoseStack poseStack, LineRenderer lineRenderer, TokenSignalEntity tokenSignal) {
        if (GogglesItem.isGoggleAuraActive(GogglesItem.Aura.SURVEYING)) {
            SignalAuraRenderUtil.renderAuraLine(lineRenderer, poseStack, tokenSignal.ringId().hashCode(), blockPos, (Position)tokenSignal.ringCentroidPos());
        } else if (GogglesItem.isGoggleAuraActive(GogglesItem.Aura.SIGNALLING)) {
            SignalAuraRenderUtil.renderAuraLine(lineRenderer, poseStack, DyeColor.BLUE.getFireworkColor(), blockPos, (Position)tokenSignal.ringCentroidPos());
        }
    }

    private static void renderAuraLine(LineRenderer renderer, PoseStack poseStack, int color, BlockPos source, Position target) {
        int red = FastColor.ARGB32.red((int)color);
        int green = FastColor.ARGB32.green((int)color);
        int blue = FastColor.ARGB32.blue((int)color);
        float endX = (float)(target.x() - (double)source.getX());
        float endY = (float)(target.y() - (double)source.getY());
        float endZ = (float)(target.z() - (double)source.getZ());
        renderer.renderLine(poseStack, red, green, blue, 255, 0.5f, 0.5f, 0.5f, endX, endY, endZ);
    }

    private static void renderSignalAura(BlockPos source, PoseStack poseStack, LineRenderer lineRenderer, Collection<BlockPos> endPoints, ColorSupplier colorProfile) {
        for (BlockPos target : endPoints) {
            int color = colorProfile.getColor(source, target);
            SignalAuraRenderUtil.renderAuraLine(lineRenderer, poseStack, color, source, (Position)target.getCenter());
        }
    }

    public static int rainbow(BlockPos source, BlockPos target) {
        int comparison = source.compareTo((Vec3i)target);
        return comparison < 0 ? Objects.hash(source, target) : Objects.hash(target, source);
    }

    @FunctionalInterface
    public static interface ColorSupplier {
        public static final ColorSupplier CONSTANT_BLUE = ColorSupplier.of(DyeColor.BLUE);

        public int getColor(BlockPos var1, BlockPos var2);

        public static ColorSupplier of(DyeColor color) {
            return ColorSupplier.of(color.getFireworkColor());
        }

        public static ColorSupplier of(int color) {
            return (source, target) -> color;
        }
    }
}

