/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.client.gui.screen.inventory.WidgetRenderer;
import mods.railcraft.gui.widget.Widget;
import mods.railcraft.world.inventory.RailcraftMenu;
import mods.railcraft.world.inventory.slot.RailcraftSlot;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;

public abstract class RailcraftMenuScreen<T extends RailcraftMenu>
extends AbstractContainerScreen<T> {
    private final List<WidgetRenderer<?>> widgetRenderers = new ArrayList();
    protected final Inventory inventory;

    protected void registerWidgetRenderer(WidgetRenderer<?> renderer) {
        this.widgetRenderers.add(renderer);
    }

    protected RailcraftMenuScreen(T menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.inventory = inventory;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        int left = this.leftPos;
        int top = this.topPos;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (((RailcraftMenu)this.menu).getCarried().isEmpty()) {
            for (WidgetRenderer<?> renderer : this.widgetRenderers) {
                List<Component> tooltip;
                if (((Widget)renderer.widget).hidden || (tooltip = renderer.getTooltip()) == null || !renderer.isMouseOver(mouseX - left, mouseY - top)) continue;
                guiGraphics.renderComponentTooltip(this.font, tooltip, mouseX, mouseY);
            }
            for (Slot slot : ((RailcraftMenu)this.menu).slots) {
                List<Component> tooltip;
                if (!(slot instanceof RailcraftSlot)) continue;
                RailcraftSlot railcraftSlot = (RailcraftSlot)slot;
                if (!slot.getItem().isEmpty() || (tooltip = railcraftSlot.getTooltip()) == null || !this.isMouseOverSlot(slot, mouseX, mouseY)) continue;
                guiGraphics.renderComponentTooltip(this.font, tooltip, mouseX, mouseY);
            }
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    public abstract ResourceLocation getWidgetsTexture();

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int x = (this.width - this.getXSize()) / 2;
        int y = (this.height - this.getYSize()) / 2;
        guiGraphics.blit(this.getWidgetsTexture(), x, y, 0, 0, this.getXSize(), this.getYSize());
        int relativeMouseX = mouseX - this.leftPos;
        int relativeMouseY = mouseY - this.topPos;
        for (WidgetRenderer<?> renderer : this.widgetRenderers) {
            if (((Widget)renderer.widget).hidden) continue;
            renderer.render(this.getWidgetsTexture(), guiGraphics, x, y, relativeMouseX, relativeMouseY);
        }
    }

    private boolean isMouseOverSlot(Slot slot, int mouseX, int mouseY) {
        return (mouseX -= this.leftPos) >= slot.x - 1 && mouseX < slot.x + 16 + 1 && (mouseY -= this.topPos) >= slot.y - 1 && mouseY < slot.y + 16 + 1;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        double relativeMouseX = mouseX - (double)this.leftPos;
        double relativeMouseY = mouseY - (double)this.topPos;
        if (this.widgetRenderers.stream().filter(element -> !((Widget)element.widget).hidden).filter(element -> element.isMouseOver(relativeMouseX, relativeMouseY)).anyMatch(element -> element.mouseClicked(relativeMouseX, relativeMouseY, button))) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        RailcraftSlot railcraftSlot;
        Slot slot = this.getSlotUnderMouse();
        if (button == 0 && slot instanceof RailcraftSlot && (railcraftSlot = (RailcraftSlot)slot).isPhantom()) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }
}

