/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen.inventory;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.RailcraftButton;
import mods.railcraft.client.gui.widget.button.RailcraftPageButton;
import mods.railcraft.client.gui.widget.button.TexturePosition;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class LogBookScreen
extends Screen {
    private static final int TEXT_WIDTH = 220;
    private static final ResourceLocation BOOK_LOCATION = RailcraftConstants.rl("textures/gui/block/logbook.png");
    private static final int IMAGE_WIDTH = 256;
    private static final int IMAGE_HEIGHT = 181;
    private final List<String> pages = Lists.newArrayList();
    private int currentPage;
    private PageButton forwardButton;
    private PageButton backButton;
    @Nullable
    private DisplayCache displayCache = DisplayCache.EMPTY;
    private Component pageMsg = CommonComponents.EMPTY;

    public LogBookScreen(List<List<String>> pages) {
        super(GameNarrator.NO_TITLE);
        if (pages.isEmpty()) {
            this.pages.add("");
        } else {
            for (List<String> page : pages) {
                this.pages.add(String.join((CharSequence)"\n", page));
            }
        }
    }

    private int getNumPages() {
        return this.pages.size();
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        super.init();
        this.clearDisplayCache();
        int buttonWidth = 65;
        this.addRenderableWidget((GuiEventListener)((RailcraftButton.Builder)((RailcraftButton.Builder)RailcraftButton.builder(CommonComponents.GUI_DONE, button -> this.minecraft.setScreen(null), (TexturePosition)ButtonTexture.LARGE_BUTTON).pos(this.width / 2 - buttonWidth / 2, this.height / 2 + 90)).size(buttonWidth, 20)).build());
        int xOffset = (this.width - 256) / 2;
        int yOffset = (this.height - 181) / 2;
        this.forwardButton = (PageButton)this.addRenderableWidget((GuiEventListener)new RailcraftPageButton(xOffset + 200, yOffset + 150, true, BOOK_LOCATION, button -> this.pageForward()));
        this.backButton = (PageButton)this.addRenderableWidget((GuiEventListener)new RailcraftPageButton(xOffset + 30, yOffset + 150, false, BOOK_LOCATION, button -> this.pageBack()));
    }

    private void pageForward() {
        if (this.currentPage < this.getNumPages() - 1) {
            ++this.currentPage;
        }
        this.updateButtonVisibility();
        this.clearDisplayCache();
    }

    private void pageBack() {
        if (this.currentPage > 0) {
            --this.currentPage;
        }
        this.updateButtonVisibility();
        this.clearDisplayCache();
    }

    private void updateButtonVisibility() {
        this.forwardButton.visible = this.currentPage < this.getNumPages() - 1;
        this.backButton.visible = this.currentPage > 0;
    }

    private String getCurrentPageText() {
        return this.currentPage >= 0 && this.currentPage < this.pages.size() ? this.pages.get(this.currentPage) : "";
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.setFocused(null);
        int xOffset = (this.width - 256) / 2;
        int yOffset = (this.height - 181) / 2;
        int l = this.font.width((FormattedText)this.pageMsg);
        guiGraphics.drawString(this.font, this.pageMsg, xOffset - l + 225, yOffset + 15, 0, false);
        DisplayCache displayCache = this.getDisplayCache();
        for (LineInfo lineinfo : displayCache.lines) {
            guiGraphics.drawString(this.font, lineinfo.asComponent, lineinfo.x, lineinfo.y, -16777216, false);
        }
        this.updateButtonVisibility();
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        int xOffset = (this.width - 256) / 2;
        int yOffset = (this.height - 181) / 2;
        guiGraphics.blit(BOOK_LOCATION, xOffset, yOffset, 0, 0, 256, 181);
    }

    private DisplayCache getDisplayCache() {
        if (this.displayCache == null) {
            this.displayCache = this.rebuildDisplayCache();
            this.pageMsg = Component.translatable((String)"book.pageIndicator", (Object[])new Object[]{this.currentPage + 1, this.getNumPages()});
        }
        return this.displayCache;
    }

    private DisplayCache rebuildDisplayCache() {
        String s = this.getCurrentPageText();
        if (s.isEmpty()) {
            return DisplayCache.EMPTY;
        }
        ArrayList list = Lists.newArrayList();
        MutableInt mutableint = new MutableInt();
        MutableBoolean mutableboolean = new MutableBoolean();
        StringSplitter stringsplitter = this.font.getSplitter();
        stringsplitter.splitLines(s, 220, Style.EMPTY, true, (style, beginIndex, endIndex) -> {
            int k3 = mutableint.getAndIncrement();
            String s2 = s.substring(beginIndex, endIndex);
            mutableboolean.setValue(s2.endsWith("\n"));
            String s3 = StringUtils.stripEnd((String)s2, (String)" \n");
            int l3 = k3 * 9;
            Pos2i pos = this.convertLocalToScreen(new Pos2i(0, l3));
            list.add(new LineInfo(style, s3, pos.x, pos.y));
        });
        return new DisplayCache(list.toArray(new LineInfo[0]));
    }

    private Pos2i convertLocalToScreen(Pos2i localScreenPos) {
        int xOffset = (this.width - 256) / 2;
        int yOffset = (this.height - 181) / 2;
        int x = localScreenPos.x + xOffset + 20;
        int y = localScreenPos.y + yOffset + 27;
        return new Pos2i(x, y);
    }

    private void clearDisplayCache() {
        this.displayCache = null;
    }

    record DisplayCache(LineInfo[] lines) {
        static final DisplayCache EMPTY = new DisplayCache(new LineInfo[]{new LineInfo(Style.EMPTY, "", 0, 0)});
    }

    static class LineInfo {
        final Style style;
        final String contents;
        final Component asComponent;
        final int x;
        final int y;

        public LineInfo(Style style, String contents, int x, int y) {
            this.style = style;
            this.contents = contents;
            this.x = x;
            this.y = y;
            this.asComponent = Component.literal((String)contents).setStyle(style);
        }
    }

    record Pos2i(int x, int y) {
    }
}

