/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.carts;

import com.mojang.authlib.GameProfile;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import mods.railcraft.api.carts.FluidTransferHandler;
import mods.railcraft.api.carts.ItemTransferHandler;
import mods.railcraft.api.carts.Linkable;
import mods.railcraft.api.carts.Side;
import mods.railcraft.api.carts.Train;
import mods.railcraft.api.container.manipulator.ContainerManipulator;
import mods.railcraft.api.container.manipulator.SlotAccessor;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.api.track.TrackUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RollingStock {
    public static final float MAX_LINK_DISTANCE = 1.25f;
    public static final float OPTIMAL_LINK_DISTANCE = 0.78f;
    public static final float HIGH_SPEED_THRESHOLD = 0.499f;
    public static final float EXPLOSION_SPEED_THRESHOLD = 0.5f;
    public static final int MAX_BLOCKING_ITEM_SLOTS = 8;
    public static final int MAX_BLOCKING_TANK_CAPACITY = 8000;
    public static final EntityCapability<RollingStock, Void> CAPABILITY = EntityCapability.createVoid((ResourceLocation)RailcraftConstants.rl("rolling_stock"), RollingStock.class);

    public static RollingStock getOrThrow(AbstractMinecart minecart) {
        return Optional.ofNullable((RollingStock)minecart.getCapability(CAPABILITY)).orElseThrow(() -> new IllegalStateException("RollingStock missing on " + String.valueOf(minecart)));
    }

    @ApiStatus.Internal
    public void tick();

    @ApiStatus.Internal
    public void removed(Entity.RemovalReason var1);

    public boolean hasLink(Side var1);

    default public boolean isLinked() {
        return this.hasLink(Side.FRONT) || this.hasLink(Side.BACK);
    }

    default public boolean isFront() {
        return !this.hasLink(Side.FRONT);
    }

    default public boolean isBack() {
        return !this.hasLink(Side.BACK);
    }

    default public boolean isEnd() {
        return this.isFront() || this.isBack();
    }

    public Optional<RollingStock> linkAt(Side var1);

    default public Optional<RollingStock> frontLink() {
        return this.linkAt(Side.FRONT);
    }

    default public Optional<RollingStock> backLink() {
        return this.linkAt(Side.BACK);
    }

    public Optional<Side> sideOf(RollingStock var1);

    default public boolean isLinkedWith(RollingStock minecart) {
        return this.sideOf(minecart).isPresent();
    }

    default public Optional<Side> disabledSide() {
        Optional<Side> optional;
        AbstractMinecart abstractMinecart = this.entity();
        if (abstractMinecart instanceof Linkable) {
            Linkable handler = (Linkable)abstractMinecart;
            optional = handler.disabledSide();
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public boolean link(RollingStock var1);

    @ApiStatus.Internal
    public void completeLink(RollingStock var1, Side var2);

    @ApiStatus.Internal
    default public boolean isLinkableWith(RollingStock rollingStock) {
        Linkable handler;
        if (this.disabledSide().map(Side::opposite).map(this::hasLink).orElse(false).booleanValue()) {
            return false;
        }
        AbstractMinecart abstractMinecart = this.entity();
        return !(abstractMinecart instanceof Linkable) || (handler = (Linkable)abstractMinecart).isLinkableWith(rollingStock);
    }

    @ApiStatus.Internal
    public void removeLink(Side var1);

    default public void unlinkAll() {
        Stream.of(Side.values()).forEach(this::unlink);
    }

    default public boolean unlink(RollingStock minecart) {
        return this.sideOf(minecart).map(this::unlink).orElse(false);
    }

    public boolean unlink(Side var1);

    @ApiStatus.Internal
    public boolean swapLinks(Side var1);

    default public Stream<RollingStock> traverseTrain(final Side side) {
        Spliterators.AbstractSpliterator<RollingStock> spliterator = new Spliterators.AbstractSpliterator<RollingStock>(Long.MAX_VALUE, 1040){
            private RollingStock current;
            {
                super(arg0, arg1);
                this.current = RollingStock.this;
            }

            @Override
            public boolean tryAdvance(Consumer<? super RollingStock> action) {
                Objects.requireNonNull(action);
                if (this.current == null) {
                    return false;
                }
                this.current = this.current.linkAt(side).orElse(null);
                if (this.current == null) {
                    return false;
                }
                action.accept(this.current);
                return true;
            }
        };
        return StreamSupport.stream(spliterator, false);
    }

    default public Stream<RollingStock> traverseTrainWithSelf(Side side) {
        return Stream.concat(Stream.of(this), this.traverseTrain(side));
    }

    @Nullable
    public Train train();

    default public boolean isSameTrainAs(@NotNull RollingStock rollingStock) {
        Objects.requireNonNull(rollingStock, "rollingStock cannot be null.");
        return this.train() == rollingStock.train();
    }

    default public ItemStack pushItem(ItemStack itemStack) {
        for (Side side : Side.values()) {
            Iterable targets = () -> this.traverseTrain(side).iterator();
            for (RollingStock target : targets) {
                AbstractMinecart cart = target.entity();
                ContainerManipulator adaptor = Optional.ofNullable((IItemHandler)cart.getCapability(Capabilities.ItemHandler.ENTITY, null)).map(ContainerManipulator::of).orElse(null);
                if (adaptor != null && this.canAcceptPushedItem(cart, itemStack)) {
                    itemStack = adaptor.insert(itemStack);
                }
                if (!itemStack.isEmpty() && !RollingStock.blocksItemRequests(cart, itemStack)) continue;
                break;
            }
            if (!itemStack.isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return itemStack;
    }

    private boolean canAcceptPushedItem(AbstractMinecart cart, ItemStack stack) {
        ItemTransferHandler handler;
        return !(cart instanceof ItemTransferHandler) || (handler = (ItemTransferHandler)cart).canAcceptPushedItem(this, stack);
    }

    default public ItemStack pullItem(Predicate<ItemStack> filter) {
        for (Side side : Side.values()) {
            RollingStock target2;
            Iterable targets = () -> this.traverseTrain(side).iterator();
            RollingStock resultProvider = null;
            SlotAccessor result = null;
            for (RollingStock target2 : targets) {
                AbstractMinecart cart = target2.entity();
                SlotAccessor slot = Optional.ofNullable((IItemHandler)cart.getCapability(Capabilities.ItemHandler.ENTITY)).map(ContainerManipulator::of).flatMap(manipulator -> manipulator.findFirstExtractable(filter.and(stack -> this.canProvidePulledItem(cart, (ItemStack)stack)))).orElse(null);
                if (slot == null) continue;
                resultProvider = target2;
                result = slot;
            }
            if (result == null) continue;
            Iterator iterator = targets.iterator();
            while (iterator.hasNext() && (target2 = (RollingStock)iterator.next()) != resultProvider) {
                if (!RollingStock.blocksItemRequests(target2.entity(), result.item())) continue;
                result = null;
                break;
            }
            if (result == null) continue;
            return result.extract();
        }
        return ItemStack.EMPTY;
    }

    private boolean canProvidePulledItem(AbstractMinecart cart, ItemStack stack) {
        ItemTransferHandler handler;
        return !(cart instanceof ItemTransferHandler) || (handler = (ItemTransferHandler)cart).canProvidePulledItem(this, stack);
    }

    default public void offerOrDropItem(ItemStack itemStack) {
        ItemStack remainder = this.pushItem(itemStack);
        if (!remainder.isEmpty()) {
            Containers.dropItemStack((Level)this.level(), (double)this.entity().getX(), (double)this.entity().getY(), (double)this.entity().getZ(), (ItemStack)remainder);
        }
    }

    default public FluidStack pushFluid(FluidStack fluidStack) {
        FluidStack remainder = fluidStack.copy();
        for (Side side : Side.values()) {
            Iterable targets = () -> this.traverseTrain(side).iterator();
            for (RollingStock target : targets) {
                IFluidHandler fluidHandler;
                AbstractMinecart cart = target.entity();
                if (this.canAcceptPushedFluid(cart, remainder) && (fluidHandler = (IFluidHandler)cart.getCapability(Capabilities.FluidHandler.ENTITY, null)) != null) {
                    int filled = fluidHandler.fill(remainder, IFluidHandler.FluidAction.EXECUTE);
                    remainder.setAmount(remainder.getAmount() - filled);
                }
                if (!remainder.isEmpty() && !RollingStock.blocksFluidRequests(cart, remainder)) continue;
                break;
            }
            if (!remainder.isEmpty()) continue;
            return FluidStack.EMPTY;
        }
        return remainder;
    }

    private boolean canAcceptPushedFluid(AbstractMinecart cart, FluidStack fluid) {
        FluidTransferHandler handler;
        return !(cart instanceof FluidTransferHandler) || (handler = (FluidTransferHandler)cart).canAcceptPushedFluid(this, fluid);
    }

    default public FluidStack pullFluid(FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        block0: for (Side side : Side.values()) {
            Iterable targets = () -> this.traverseTrain(side).iterator();
            for (RollingStock target : targets) {
                FluidStack drained;
                IFluidHandler fluidHandler;
                AbstractMinecart cart = target.entity();
                if (this.canProvidePulledFluid(cart, fluidStack) && (fluidHandler = (IFluidHandler)cart.getCapability(Capabilities.FluidHandler.ENTITY, null)) != null && !(drained = fluidHandler.drain(fluidStack, IFluidHandler.FluidAction.EXECUTE)).isEmpty()) {
                    return drained;
                }
                if (!RollingStock.blocksFluidRequests(cart, fluidStack)) continue;
                continue block0;
            }
        }
        return FluidStack.EMPTY;
    }

    private boolean canProvidePulledFluid(AbstractMinecart cart, FluidStack fluid) {
        FluidTransferHandler handler;
        return !(cart instanceof FluidTransferHandler) || (handler = (FluidTransferHandler)cart).canProvidePulledFluid(this, fluid);
    }

    default public boolean isAutoLinkEnabled() {
        return Stream.of(Side.values()).anyMatch(this::isAutoLinkEnabled);
    }

    public boolean isAutoLinkEnabled(Side var1);

    public boolean setAutoLinkEnabled(Side var1, boolean var2);

    default public boolean setAutoLinkEnabled(boolean enabled) {
        boolean result = false;
        for (Side link : Side.values()) {
            result |= this.setAutoLinkEnabled(link, enabled);
        }
        return result;
    }

    default public boolean tryAutoLink(RollingStock cart2) {
        return (this.isAutoLinkEnabled() || cart2.isAutoLinkEnabled()) && this.link(cart2);
    }

    default public boolean canCartBeAdjustedBy(RollingStock cart2) {
        Linkable handler;
        if (this == cart2) {
            return false;
        }
        AbstractMinecart abstractMinecart = this.entity();
        if (abstractMinecart instanceof Linkable && !(handler = (Linkable)abstractMinecart).canBeAdjusted(cart2)) {
            return false;
        }
        return !TrackUtil.isCartLocked(this.entity());
    }

    public boolean isLaunched();

    public void launch();

    public int getElevatorRemainingTicks();

    default public boolean isOnElevator() {
        return this.getElevatorRemainingTicks() > 0;
    }

    public void setElevatorRemainingTicks(int var1);

    public boolean isMountable();

    public void setPreventMountRemainingTicks(int var1);

    public boolean isDerailed();

    public void setDerailedRemainingTicks(int var1);

    public void primeExplosion();

    public boolean isHighSpeed();

    public void checkHighSpeed(BlockPos var1);

    public Optional<GameProfile> owner();

    public AbstractMinecart entity();

    default public Level level() {
        return this.entity().level();
    }

    private static boolean blocksItemRequests(AbstractMinecart cart, ItemStack stack) {
        ItemTransferHandler handler;
        return cart instanceof ItemTransferHandler ? !(handler = (ItemTransferHandler)cart).canPassItemRequests(stack) : Optional.ofNullable((IItemHandler)cart.getCapability(Capabilities.ItemHandler.ENTITY)).map(IItemHandler::getSlots).orElse(0) < 8;
    }

    private static boolean blocksFluidRequests(AbstractMinecart cart, FluidStack fluid) {
        FluidTransferHandler fluidMinecart;
        return cart instanceof FluidTransferHandler ? !(fluidMinecart = (FluidTransferHandler)cart).canPassFluidRequests(fluid) : Optional.ofNullable((IFluidHandler)cart.getCapability(Capabilities.FluidHandler.ENTITY, null)).map(fluidHandler -> !RollingStock.hasMatchingTank(fluidHandler, fluid)).orElse(true);
    }

    private static boolean hasMatchingTank(IFluidHandler handler, FluidStack fluid) {
        for (int i = 0; i < handler.getTanks(); ++i) {
            FluidStack tankFluid;
            if (handler.getTankCapacity(i) < 8000 || !(tankFluid = handler.getFluidInTank(i)).isEmpty() && !FluidStack.isSameFluidSameComponents((FluidStack)tankFluid, (FluidStack)fluid)) continue;
            return true;
        }
        return false;
    }
}

