/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.logging;

import ca.teamdman.sfm.common.logging.TranslatableAppender;
import ca.teamdman.sfm.common.logging.TranslatableLogEvent;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.time.Instant;

public class TranslatableLogger {
    private static final LoggerContext CONTEXT = new LoggerContext("sfm");
    private final Logger logger;
    private Level logLevel = Level.OFF;

    public TranslatableLogger(String name) {
        this.logger = CONTEXT.getLogger(name);
        Configuration configuration = CONTEXT.getConfiguration();
        configuration.removeLogger(name);
        LoggerConfig config = new LoggerConfig(name, this.logLevel, false);
        configuration.addLogger(name, config);
        TranslatableAppender appender = TranslatableAppender.createAppender(name);
        config.removeAppender(name);
        config.addAppender((Appender)appender, Level.TRACE, null);
        appender.start();
    }

    public Level getLogLevel() {
        return CONTEXT.getConfiguration().getLoggerConfig(this.logger.getName()).getLevel();
    }

    public void setLogLevel(Level level) {
        LoggerConfig found = CONTEXT.getConfiguration().getLoggerConfig(this.logger.getName());
        found.setLevel(level);
        this.logLevel = level;
        CONTEXT.updateLoggers();
    }

    public void info(TranslatableContents contents) {
        if (this.logLevel.isLessSpecificThan(Level.INFO)) {
            this.logger.info(contents.getKey(), contents.getArgs());
        }
    }

    public void info(Consumer<Consumer<TranslatableContents>> logger) {
        if (this.logLevel.isLessSpecificThan(Level.INFO)) {
            logger.accept(this::info);
        }
    }

    public void warn(TranslatableContents contents) {
        if (this.logLevel.isLessSpecificThan(Level.WARN)) {
            this.logger.warn(contents.getKey(), contents.getArgs());
        }
    }

    public void warn(Consumer<Consumer<TranslatableContents>> logger) {
        if (this.logLevel.isLessSpecificThan(Level.WARN)) {
            logger.accept(this::warn);
        }
    }

    public void error(TranslatableContents contents) {
        if (this.logLevel.isLessSpecificThan(Level.ERROR)) {
            this.logger.error(contents.getKey(), contents.getArgs());
        }
    }

    public void error(Consumer<Consumer<TranslatableContents>> logger) {
        if (this.logLevel.isLessSpecificThan(Level.ERROR)) {
            logger.accept(this::error);
        }
    }

    public void debug(TranslatableContents contents) {
        if (this.logLevel.isLessSpecificThan(Level.DEBUG)) {
            this.logger.debug(contents.getKey(), contents.getArgs());
        }
    }

    public void debug(Consumer<Consumer<TranslatableContents>> logger) {
        if (this.logLevel.isLessSpecificThan(Level.DEBUG)) {
            logger.accept(this::debug);
        }
    }

    public void trace(TranslatableContents contents) {
        if (this.logLevel.isLessSpecificThan(Level.TRACE)) {
            this.logger.trace(contents.getKey(), contents.getArgs());
        }
    }

    public void trace(Consumer<Consumer<TranslatableContents>> logger) {
        if (this.logLevel.isLessSpecificThan(Level.TRACE)) {
            logger.accept(this::trace);
        }
    }

    public ArrayDeque<TranslatableLogEvent> getLogs() {
        return new ArrayDeque<TranslatableLogEvent>(this.getContents());
    }

    public void clear() {
        this.getContents().clear();
    }

    public static boolean comesAfter(Instant a, Instant b) {
        return a.getEpochSecond() > b.getEpochSecond() || a.getEpochSecond() == b.getEpochSecond() && a.getNanoOfSecond() > b.getNanoOfSecond();
    }

    public static ArrayDeque<TranslatableLogEvent> decode(FriendlyByteBuf buf) {
        int size = buf.readVarInt();
        ArrayDeque<TranslatableLogEvent> contents = new ArrayDeque<TranslatableLogEvent>(size);
        for (int i = 0; i < size; ++i) {
            contents.add(TranslatableLogEvent.decode(buf));
        }
        return contents;
    }

    public static void encodeAndDrain(Collection<TranslatableLogEvent> logs, FriendlyByteBuf buf) {
        int maxReadableBytes = 32600;
        FriendlyByteBuf chunk = new FriendlyByteBuf(Unpooled.buffer());
        int count = 0;
        Iterator<TranslatableLogEvent> iterator = logs.iterator();
        while (iterator.hasNext()) {
            TranslatableLogEvent entry = iterator.next();
            FriendlyByteBuf check = new FriendlyByteBuf(Unpooled.buffer());
            entry.encode(check);
            if (check.readableBytes() + chunk.readableBytes() + buf.readableBytes() >= maxReadableBytes) break;
            chunk.writeBytes((ByteBuf)check);
            iterator.remove();
            ++count;
        }
        buf.writeVarInt(count);
        buf.writeBytes((ByteBuf)chunk);
    }

    public ArrayDeque<TranslatableLogEvent> getLogsAfter(Instant instant) {
        TranslatableLogEvent entry;
        LinkedList<TranslatableLogEvent> contents = this.getContents();
        ArrayDeque<TranslatableLogEvent> toSend = new ArrayDeque<TranslatableLogEvent>();
        ListIterator iter = contents.listIterator(contents.size());
        while (iter.hasPrevious() && TranslatableLogger.comesAfter((entry = (TranslatableLogEvent)iter.previous()).instant(), instant)) {
            toSend.addFirst(entry);
        }
        return toSend;
    }

    public void pruneSoWeDontEatAllTheRam() {
        LinkedList<TranslatableLogEvent> contents = this.getContents();
        if (contents.size() > 10000) {
            int overage = contents.size() - 10000;
            int to_prune = overage + 500;
            contents.subList(0, to_prune).clear();
        }
    }

    private LinkedList<TranslatableLogEvent> getContents() {
        Appender appender;
        Map appenders = CONTEXT.getConfiguration().getLoggerConfig(this.logger.getName()).getAppenders();
        if (appenders.containsKey(this.logger.getName()) && (appender = (Appender)appenders.get(this.logger.getName())) instanceof TranslatableAppender) {
            TranslatableAppender ta = (TranslatableAppender)appender;
            return ta.contents;
        }
        return new LinkedList<TranslatableLogEvent>();
    }
}

