/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.config;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.config.SFMConfig;
import ca.teamdman.sfm.common.config.SFMConfigTracker;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.Function;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public class SFMConfigReadWriter {
    public static ConfigSyncResult updateAndSyncServerConfig(String newConfigToml) {
        try {
            SFM.LOGGER.debug("Received server config for update and sync:\n{}", (Object)newConfigToml);
            CommentedConfig config = SFMConfigReadWriter.parseConfigToml(newConfigToml, SFMConfig.SERVER_CONFIG_SPEC);
            if (config == null) {
                SFM.LOGGER.error("Received invalid server config from player");
                return ConfigSyncResult.INVALID_CONFIG;
            }
            if (!SFMConfigReadWriter.writeServerConfig(config)) {
                SFM.LOGGER.error("Failed to write server config");
                return ConfigSyncResult.INTERNAL_FAILURE;
            }
            return ConfigSyncResult.SUCCESS;
        }
        catch (Throwable t) {
            SFM.LOGGER.error("Failed to update and sync server config", t);
            return ConfigSyncResult.INTERNAL_FAILURE;
        }
    }

    public static ConfigSyncResult updateClientConfig(String newConfigToml) {
        try {
            SFM.LOGGER.debug("Received client config for update and sync:\n{}", (Object)newConfigToml);
            CommentedConfig config = SFMConfigReadWriter.parseConfigToml(newConfigToml, SFMConfig.CLIENT_CONFIG_SPEC);
            if (config == null) {
                SFM.LOGGER.error("Received invalid config");
                return ConfigSyncResult.INVALID_CONFIG;
            }
            if (!SFMConfigReadWriter.writeClientConfig(config)) {
                SFM.LOGGER.error("Failed to write client config");
                return ConfigSyncResult.INTERNAL_FAILURE;
            }
            return ConfigSyncResult.SUCCESS;
        }
        catch (Throwable t) {
            SFM.LOGGER.error("Failed to update and sync client config", t);
            return ConfigSyncResult.INTERNAL_FAILURE;
        }
    }

    @Nullable
    public static Path getConfigBasePath() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return null;
        }
        try {
            Method getServerConfigPath = ServerLifecycleHooks.class.getDeclaredMethod("getServerConfigPath", MinecraftServer.class);
            getServerConfigPath.setAccessible(true);
            return (Path)getServerConfigPath.invoke(null, server);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    @MCVersionDependentBehaviour
    public static boolean updateActiveConfigAndFireReloadedEvent(ModConfig modConfig, Path configBasePath, Path configPath, CommentedConfig newConfig) {
        IConfigSpec.ILoadedConfig loadedConfig;
        Class<?> loadedConfigClass;
        SFM.LOGGER.info("Updating active client config and firing reloaded event");
        try {
            loadedConfigClass = Class.forName("net.neoforged.fml.config.LoadedConfig");
        }
        catch (ClassNotFoundException e) {
            SFM.LOGGER.error("Failed to get LoadedConfig class", (Throwable)e);
            return false;
        }
        try {
            Constructor<?> declaredConstructor = loadedConfigClass.getDeclaredConstructor(CommentedConfig.class, Path.class, ModConfig.class);
            declaredConstructor.setAccessible(true);
            loadedConfig = (IConfigSpec.ILoadedConfig)declaredConstructor.newInstance(newConfig, configPath, modConfig);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            SFM.LOGGER.error("Failed to create LoadedConfig instance", (Throwable)e);
            return false;
        }
        try {
            Method setConfig = ModConfig.class.getDeclaredMethod("setConfig", loadedConfigClass, Function.class);
            setConfig.setAccessible(true);
            setConfig.invoke((Object)modConfig, loadedConfig, ModConfigEvent.Reloading::new);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            SFM.LOGGER.error("Failed to set new config data", (Throwable)e);
            return false;
        }
        return true;
    }

    @Nullable
    public static CommentedConfig parseConfigToml(String configToml, ModConfigSpec configSpec) {
        CommentedConfig config = (CommentedConfig)TomlFormat.instance().createParser().parse(configToml);
        if (!configSpec.isCorrect((UnmodifiableCommentedConfig)config)) {
            return null;
        }
        return config;
    }

    @Nullable
    public static String getConfigToml(ModConfigSpec configSpec) {
        Path configPath = SFMConfigTracker.getPathForConfig((IConfigSpec)configSpec);
        if (configPath == null) {
            SFM.LOGGER.error("Failed to get config path when trying to get config TOML contents");
            return null;
        }
        try {
            return Files.readString(configPath, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            SFM.LOGGER.error("Failed reading config contents", (Throwable)e);
            return null;
        }
    }

    private static boolean writeServerConfig(CommentedConfig config) {
        Path configBasePath = SFMConfigReadWriter.getConfigBasePath();
        if (configBasePath == null) {
            SFM.LOGGER.warn("Failed to get server config base path");
            return false;
        }
        Path configPath = SFMConfigTracker.getPathForConfig((IConfigSpec)SFMConfig.SERVER_CONFIG_SPEC);
        if (configPath == null) {
            SFM.LOGGER.warn("Failed to get server config path");
            return false;
        }
        ModConfig modConfig = SFMConfigTracker.getServerModConfig();
        if (modConfig == null) {
            SFM.LOGGER.warn("Failed to get server mod config");
            return false;
        }
        TomlFormat.instance().createWriter().write((UnmodifiableConfig)config, configPath, WritingMode.REPLACE);
        return SFMConfigReadWriter.updateActiveConfigAndFireReloadedEvent(modConfig, configBasePath, configPath, config);
    }

    private static boolean writeClientConfig(CommentedConfig config) {
        Path configBasePath = SFMConfigReadWriter.getConfigBasePath();
        if (configBasePath == null) {
            SFM.LOGGER.warn("Failed to get client config base path");
            return false;
        }
        Path configPath = SFMConfigTracker.getPathForConfig((IConfigSpec)SFMConfig.CLIENT_CONFIG_SPEC);
        if (configPath == null) {
            SFM.LOGGER.warn("Failed to get client config path");
            return false;
        }
        ModConfig modConfig = SFMConfigTracker.getClientModConfig();
        if (modConfig == null) {
            SFM.LOGGER.warn("Failed to get client mod config");
            return false;
        }
        TomlFormat.instance().createWriter().write((UnmodifiableConfig)config, configPath, WritingMode.REPLACE);
        return SFMConfigReadWriter.updateActiveConfigAndFireReloadedEvent(modConfig, configBasePath, configPath, config);
    }

    private static boolean setConfigData(ModConfig modConfig, CommentedConfig configData) {
        try {
            Method setConfigData = ModConfig.class.getDeclaredMethod("setConfigData", CommentedConfig.class);
            setConfigData.setAccessible(true);
            setConfigData.invoke((Object)modConfig, configData);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            SFM.LOGGER.warn("Failed to set new config data", (Throwable)e);
            return false;
        }
        return true;
    }

    public static enum ConfigSyncResult {
        SUCCESS,
        INVALID_CONFIG,
        FAILED_TO_FIND,
        INTERNAL_FAILURE;


        public MutableComponent component() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> LocalizationKeys.CONFIG_UPDATE_AND_SYNC_RESULT_SUCCESS.getComponent();
                case 1 -> LocalizationKeys.CONFIG_UPDATE_AND_SYNC_RESULT_INVALID_CONFIG.getComponent();
                case 2 -> LocalizationKeys.CONFIG_UPDATE_AND_SYNC_RESULT_FAILED_TO_FIND.getComponent();
                case 3 -> LocalizationKeys.CONFIG_UPDATE_AND_SYNC_RESULT_INTERNAL_FAILURE.getComponent();
            };
        }
    }
}

