/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.capability;

import ca.teamdman.sfm.common.capability.SFMBlockCapabilityKind;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityProvider;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityResult;
import ca.teamdman.sfm.common.registry.SFMBlockCapabilityProviders;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SFMBlockCapabilityProviderCache {
    private static final Object2ObjectOpenHashMap<SFMBlockCapabilityKind<?>, ArrayList<SFMBlockCapabilityProvider<?>>> BLOCK_CAPABILITY_PROVIDERS_BY_KIND = new Object2ObjectOpenHashMap();

    @MCVersionDependentBehaviour
    public static <CAP> SFMBlockCapabilityResult<CAP> getCapabilityFromLevel(SFMBlockCapabilityKind<CAP> capKind, Level level, BlockPos pos, BlockState blockState, BlockEntity blockEntity, @Nullable Direction direction) {
        for (SFMBlockCapabilityProvider<CAP> capabilityProviderMapper : SFMBlockCapabilityProviderCache.getCapabilityProvidersForKindFast(capKind)) {
            SFMBlockCapabilityResult<CAP> capability = capabilityProviderMapper.getCapability(capKind, level, pos, blockState, blockEntity, direction);
            if (!capability.isPresent()) continue;
            return capability;
        }
        return SFMBlockCapabilityResult.of(level.getCapability(capKind.capabilityKind(), pos, (Object)direction));
    }

    public static <CAP> ArrayList<SFMBlockCapabilityProvider<CAP>> getCapabilityProvidersForKindFast(SFMBlockCapabilityKind<CAP> capabilityKind) {
        return (ArrayList)BLOCK_CAPABILITY_PROVIDERS_BY_KIND.computeIfAbsent(capabilityKind, __ -> SFMBlockCapabilityProviderCache.getCapabilityProvidersForKind(capabilityKind));
    }

    private static <CAP> ArrayList<SFMBlockCapabilityProvider<?>> getCapabilityProvidersForKind(SFMBlockCapabilityKind<CAP> capabilityKind) {
        ArrayList rtn = new ArrayList();
        for (SFMBlockCapabilityProvider<CAP> sFMBlockCapabilityProvider : SFMBlockCapabilityProviders.getAllProviders()) {
            if (!sFMBlockCapabilityProvider.matchesCapabilityKind(capabilityKind)) continue;
            SFMBlockCapabilityProvider<CAP> typedMapper = sFMBlockCapabilityProvider;
            rtn.add(typedMapper);
        }
        return rtn;
    }
}

