/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.cablenetwork;

import ca.teamdman.sfm.common.capability.SFMBlockCapabilityKind;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityResult;
import ca.teamdman.sfm.common.util.NotStored;
import ca.teamdman.sfm.common.util.SFMDirections;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import org.jetbrains.annotations.Nullable;

public class SFMBlockCapabilityCacheForLevel {
    private final Long2ObjectMap<Object2ObjectOpenHashMap<SFMBlockCapabilityKind<?>, SFMDirections.NullableDirectionEnumMap<SFMBlockCapabilityResult<?>>>> CACHE = new Long2ObjectOpenHashMap();
    private final Long2ObjectMap<LongArraySet> CHUNK_TO_BLOCK_POSITIONS = new Long2ObjectOpenHashMap();

    public void clear() {
        this.CACHE.clear();
        this.CHUNK_TO_BLOCK_POSITIONS.clear();
    }

    public int size() {
        return this.CACHE.values().stream().flatMap(x -> x.values().stream()).mapToInt(SFMDirections.NullableDirectionEnumMap::size).sum();
    }

    public void overwriteFromOther(@NotStored BlockPos pos, SFMBlockCapabilityCacheForLevel other) {
        Object2ObjectOpenHashMap found = (Object2ObjectOpenHashMap)other.CACHE.get(pos.asLong());
        if (found != null) {
            this.CACHE.put(pos.asLong(), (Object)new Object2ObjectOpenHashMap((Object2ObjectMap)found));
        }
        this.addToChunkMap(pos);
    }

    @Nullable
    public <CAP> SFMBlockCapabilityResult<CAP> getCapability(@NotStored BlockPos pos, SFMBlockCapabilityKind<CAP> capKind, @Nullable Direction direction) {
        SFMDirections.NullableDirectionEnumMap dirMap;
        Object2ObjectOpenHashMap capMap = (Object2ObjectOpenHashMap)this.CACHE.get(pos.asLong());
        if (capMap != null && (dirMap = (SFMDirections.NullableDirectionEnumMap)capMap.get(capKind)) != null) {
            SFMBlockCapabilityResult found = (SFMBlockCapabilityResult)dirMap.get(direction);
            if (found == null) {
                return null;
            }
            return found;
        }
        return null;
    }

    public void putAll(SFMBlockCapabilityCacheForLevel other) {
        for (Long2ObjectMap.Entry entry : other.CACHE.long2ObjectEntrySet()) {
            long pos = entry.getLongKey();
            Object2ObjectOpenHashMap capMap = (Object2ObjectOpenHashMap)entry.getValue();
            for (Map.Entry e : capMap.entrySet()) {
                SFMBlockCapabilityKind capKind = (SFMBlockCapabilityKind)e.getKey();
                SFMDirections.NullableDirectionEnumMap dirMap = (SFMDirections.NullableDirectionEnumMap)e.getValue();
                for (Direction direction : SFMDirections.DIRECTIONS_WITHOUT_NULL) {
                    SFMBlockCapabilityResult cap = (SFMBlockCapabilityResult)dirMap.get(direction);
                    if (cap == null) continue;
                    this.putCapability(BlockPos.of((long)pos), capKind, direction, cap);
                }
            }
        }
    }

    public Stream<BlockPos> getPositions() {
        return this.CACHE.keySet().longStream().mapToObj(BlockPos::of);
    }

    public void remove(@NotStored BlockPos pos, SFMBlockCapabilityKind<?> capKind, @Nullable Direction direction) {
        SFMDirections.NullableDirectionEnumMap dirMap;
        Object2ObjectOpenHashMap capMap = (Object2ObjectOpenHashMap)this.CACHE.get(pos.asLong());
        if (capMap != null && (dirMap = (SFMDirections.NullableDirectionEnumMap)capMap.get(capKind)) != null) {
            dirMap.remove(direction);
            if (dirMap.isEmpty()) {
                capMap.remove(capKind);
                if (capMap.isEmpty()) {
                    this.CACHE.remove(pos.asLong());
                }
            }
            this.removeFromChunkMap(pos);
        }
    }

    public <CAP> void putCapability(@NotStored BlockPos pos, SFMBlockCapabilityKind<CAP> capKind, @Nullable Direction direction, SFMBlockCapabilityResult<CAP> cap) {
        Object2ObjectOpenHashMap capMap = (Object2ObjectOpenHashMap)this.CACHE.computeIfAbsent(pos.asLong(), k -> new Object2ObjectOpenHashMap());
        SFMDirections.NullableDirectionEnumMap dirMap = (SFMDirections.NullableDirectionEnumMap)capMap.computeIfAbsent(capKind, k -> new SFMDirections.NullableDirectionEnumMap());
        dirMap.put(direction, cap);
        this.addToChunkMap(pos);
    }

    public void bustCacheForChunk(ChunkAccess chunkAccess) {
        long chunkKey = chunkAccess.getPos().toLong();
        LongArraySet blockPositions = (LongArraySet)this.CHUNK_TO_BLOCK_POSITIONS.get(chunkKey);
        if (blockPositions != null) {
            for (Long blockPos : blockPositions) {
                this.CACHE.remove(blockPos.longValue());
            }
            this.CHUNK_TO_BLOCK_POSITIONS.remove(chunkKey);
        }
    }

    private void addToChunkMap(@NotStored BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        long chunkKey = chunkPos.toLong();
        long blockPos = pos.asLong();
        ((LongArraySet)this.CHUNK_TO_BLOCK_POSITIONS.computeIfAbsent(chunkKey, k -> new LongArraySet())).add(blockPos);
    }

    private void removeFromChunkMap(@NotStored BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        long chunkKey = chunkPos.toLong();
        long blockPos = pos.asLong();
        LongArraySet blockPosSet = (LongArraySet)this.CHUNK_TO_BLOCK_POSITIONS.get(chunkKey);
        if (blockPosSet != null) {
            blockPosSet.remove(blockPos);
            if (blockPosSet.isEmpty()) {
                this.CHUNK_TO_BLOCK_POSITIONS.remove(chunkKey);
            }
        }
    }
}

