/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.block;

import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.registry.SFMBlockEntities;
import ca.teamdman.sfm.common.util.NotStored;
import ca.teamdman.sfm.common.util.SFMDirections;
import ca.teamdman.sfm.common.util.Stored;
import ca.teamdman.sfm.common.watertanknetwork.WaterNetworkManager;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.Nullable;

public class WaterTankBlock
extends BaseEntityBlock
implements EntityBlock,
BucketPickup,
LiquidBlockContainer {
    public static final BooleanProperty IN_WATER = BooleanProperty.create((String)"in_water");

    public WaterTankBlock() {
        super(BlockBehaviour.Properties.of().destroyTime(2.0f).sound(SoundType.WOOD));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)IN_WATER, (Comparable)Boolean.valueOf(false)));
    }

    public void onPlace(BlockState pState, Level pLevel, @NotStored BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        WaterNetworkManager.onActiveStateChanged(pLevel, pPos, pState);
    }

    public void onRemove(BlockState pState, Level pLevel, @NotStored BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
        WaterNetworkManager.onActiveStateChanged(pLevel, pPos, pNewState);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTootipComponents, TooltipFlag pTooltipFlag) {
        pTootipComponents.add((Component)LocalizationKeys.WATER_TANK_ITEM_TOOLTIP_1.getComponent().withStyle(ChatFormatting.GRAY));
        pTootipComponents.add((Component)LocalizationKeys.WATER_TANK_ITEM_TOOLTIP_2.getComponent().withStyle(ChatFormatting.GRAY));
    }

    protected MapCodec<WaterTankBlock> codec() {
        throw new NotImplementedException("This isn't used until 1.20.5 apparently");
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(@Stored BlockPos pos, BlockState state) {
        return SFMBlockEntities.WATER_TANK_BLOCK_ENTITY.get().create(pos, state);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)IN_WATER, (Comparable)Boolean.valueOf(this.hasWaterNeighbours((LevelAccessor)context.getLevel(), context.getClickedPos())));
    }

    public boolean hasWaterNeighbours(LevelAccessor level, @NotStored BlockPos pos) {
        int neighbourWaterCount = 0;
        BlockPos.MutableBlockPos target = new BlockPos.MutableBlockPos();
        for (Direction direction : SFMDirections.DIRECTIONS_WITHOUT_NULL) {
            target.set((Vec3i)pos).move(direction);
            FluidState state = level.getFluidState((BlockPos)target);
            if (!state.isSource() || !state.is(FluidTags.WATER) || ++neighbourWaterCount != 2) continue;
            return true;
        }
        return false;
    }

    public void neighborChanged(BlockState state, Level level, @Stored BlockPos pos, Block blockIn, @Stored BlockPos fromPos, boolean isMoving) {
        if (level.isClientSide) {
            return;
        }
        boolean isActive = this.hasWaterNeighbours((LevelAccessor)level, pos);
        if ((Boolean)state.getValue((Property)IN_WATER) != isActive) {
            BlockState newState = (BlockState)this.defaultBlockState().setValue((Property)IN_WATER, (Comparable)Boolean.valueOf(isActive));
            level.setBlock(pos, newState, 3);
        }
    }

    public ItemStack pickupBlock(@Nullable Player player, LevelAccessor levelAccessor, @NotStored BlockPos blockPos, BlockState blockState) {
        return (Boolean)blockState.getValue((Property)IN_WATER) != false ? new ItemStack((ItemLike)Fluids.WATER.getBucket()) : ItemStack.EMPTY;
    }

    public Optional<SoundEvent> getPickupSound() {
        return Fluids.WATER.getPickupSound();
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter blockGetter, @NotStored BlockPos blockPos, BlockState blockState, Fluid fluid) {
        return fluid.isSame((Fluid)Fluids.WATER);
    }

    public boolean placeLiquid(LevelAccessor level, @NotStored BlockPos pos, BlockState state, FluidState fluid) {
        return fluid.getType().isSame((Fluid)Fluids.WATER);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{IN_WATER});
    }
}

