/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.device;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.FluxDataComponents;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.client.ClientCache;
import sonar.fluxnetworks.common.connection.FluxMenu;
import sonar.fluxnetworks.common.connection.FluxNetwork;
import sonar.fluxnetworks.common.connection.FluxNetworkData;
import sonar.fluxnetworks.common.connection.ServerFluxNetwork;
import sonar.fluxnetworks.common.connection.TransferHandler;
import sonar.fluxnetworks.common.data.FluxDeviceConfigComponent;
import sonar.fluxnetworks.common.level.FluxChunkLoading;
import sonar.fluxnetworks.common.util.FluxUtils;
import sonar.fluxnetworks.register.Channel;
import sonar.fluxnetworks.register.Messages;

@ParametersAreNonnullByDefault
public abstract class TileFluxDevice
extends BlockEntity
implements IFluxDevice {
    private static final BlockEntityTicker<? extends TileFluxDevice> sTickerServer = (level, pos, state, tile) -> tile.onServerTick();
    public static final int INVALID_CLIENT_COLOR = FluxUtils.getModifiedColor(0xB2B2B2, 1.1f);
    public static final int MAX_CUSTOM_NAME_LENGTH = 24;
    @Nullable
    private Player mPlayerUsing;
    @Nonnull
    private String mCustomName = "";
    @Nonnull
    private UUID mOwnerUUID = Util.NIL_UUID;
    private int mNetworkID = -1;
    public int mClientColor = INVALID_CLIENT_COLOR;
    protected static final int SIDES_CONNECTED_MASK = 63;
    protected static final int FLAG_FORCED_LOADING = 64;
    protected static final int FLAG_FIRST_TICKED = 128;
    protected static final int FLAG_SETTING_CHANGED = 256;
    protected static final int FLAG_ENERGY_CHANGED = 512;
    protected int mFlags;
    @Nullable
    private GlobalPos mGlobalPos;
    @Nonnull
    private FluxNetwork mNetwork = FluxNetwork.INVALID;

    protected TileFluxDevice(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Nullable
    public static <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level) {
        return level.isClientSide ? null : sTickerServer;
    }

    public void setRemoved() {
        super.setRemoved();
        if (!this.level.isClientSide && (this.mFlags & 0x80) != 0) {
            this.mNetwork.enqueueConnectionRemoval(this, false);
            if (this.isForcedLoading()) {
                long chunkPos = ChunkPos.asLong((BlockPos)this.worldPosition);
                FluxChunkLoading.CONTROLLER.forceChunk((ServerLevel)this.level, this.worldPosition, ChunkPos.getX((long)chunkPos), ChunkPos.getZ((long)chunkPos), false, true);
            }
            this.getTransferHandler().onNetworkChanged();
            this.mFlags &= 0xFFFFFF7F;
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (!this.level.isClientSide && (this.mFlags & 0x80) != 0) {
            this.mNetwork.enqueueConnectionRemoval(this, true);
            this.getTransferHandler().onNetworkChanged();
            this.mFlags &= 0xFFFFFF7F;
        }
    }

    protected void onServerTick() {
        if ((this.mFlags & 0x80) == 0) {
            this.onFirstTick();
            this.mFlags |= 0x80;
        }
        if ((this.mFlags & 0x100) != 0) {
            this.sendBlockUpdate();
            this.mFlags &= 0xFFFFFEFF;
        } else if (this.mPlayerUsing != null) {
            Channel.get().sendToPlayer(Messages.makeDeviceBuffer(this, (byte)-1), this.mPlayerUsing);
        }
    }

    protected void onFirstTick() {
        this.connect(FluxNetworkData.getNetwork(this.mNetworkID));
    }

    public void onPlayerInteract(Player player) {
        assert (!this.level.isClientSide);
        if (this.mPlayerUsing != null) {
            player.displayClientMessage(FluxTranslate.ACCESS_OCCUPY, true);
        } else if (this.canPlayerAccess(player)) {
            Consumer<RegistryFriendlyByteBuf> writer = buf -> {
                buf.writeBoolean(true);
                buf.writeBlockPos(this.worldPosition);
                CompoundTag tag = new CompoundTag();
                this.writeCustomTag(tag, (byte)11);
                buf.writeNbt((Tag)tag);
            };
            player.openMenu((MenuProvider)this, writer);
        } else {
            player.displayClientMessage(FluxTranslate.ACCESS_DENIED, true);
        }
    }

    @Nonnull
    public final FluxMenu createMenu(int containerId, Inventory inventory, Player player) {
        return new FluxMenu(containerId, inventory, this);
    }

    public boolean connect(FluxNetwork network) {
        assert (!this.level.isClientSide);
        if (this.mNetwork == network) {
            return true;
        }
        if (network.enqueueConnectionAddition(this)) {
            this.mNetwork.enqueueConnectionRemoval(this, false);
            this.mNetwork = network;
            this.mNetworkID = this.mNetwork.getNetworkID();
            this.getTransferHandler().onNetworkChanged();
            this.mFlags |= 0x100;
            this.markChunkUnsaved();
            return true;
        }
        return false;
    }

    public final void disconnect() {
        this.connect(FluxNetwork.INVALID);
    }

    @Override
    public final int getNetworkID() {
        return this.mNetworkID;
    }

    @Nonnull
    public final FluxNetwork getNetwork() {
        return this.mNetwork;
    }

    @Nonnull
    public abstract TransferHandler getTransferHandler();

    @Nonnull
    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public final void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider registries) {
        this.readCustomTag(packet.getTag(), (byte)11);
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 11);
    }

    @Nonnull
    public final CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.writeCustomTag(tag, (byte)11);
        return tag;
    }

    public final void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.readCustomTag(tag, (byte)11);
    }

    protected final void saveAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.writeCustomTag(tag, (byte)1);
    }

    public final void loadAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.readCustomTag(tag, (byte)1);
    }

    public void setLevel(@Nonnull Level level) {
        super.setLevel(level);
        this.mGlobalPos = GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)this.worldPosition);
    }

    @Override
    public void writeCustomTag(@Nonnull CompoundTag tag, byte type) {
        tag.putInt("network_id", this.mNetworkID);
        tag.putString("custom_name", this.mCustomName);
        this.getTransferHandler().writeCustomTag(tag, type);
        switch (type) {
            case 1: {
                tag.putUUID("player_uuid", this.mOwnerUUID);
                break;
            }
            case 11: {
                tag.putUUID("player_uuid", this.mOwnerUUID);
                if ((this.mFlags & 0x80) != 0) {
                    tag.putInt("client_color", this.mNetwork.getNetworkColor());
                }
                tag.putInt("flags", this.mFlags);
                break;
            }
            case 20: {
                FluxUtils.writeGlobalPos(tag, this.getGlobalPos());
                tag.putByte("device_type", this.getDeviceType().getId());
                tag.putUUID("player_uuid", this.mOwnerUUID);
                tag.putBoolean("forced_loading", this.isForcedLoading());
                tag.putBoolean("chunk_loaded", this.isChunkLoaded());
                tag.putString("device_item", this.getDisplayStack().getItemHolder().getRegisteredName());
            }
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        FluxDeviceConfigComponent configuration = (FluxDeviceConfigComponent)componentInput.get(FluxDataComponents.FLUX_CONFIG);
        if (configuration == null) {
            return;
        }
        Long energy = (Long)componentInput.get(FluxDataComponents.STORED_ENERGY);
        this.mNetworkID = configuration.networkId();
        if (configuration.customName().isPresent()) {
            this.mCustomName = configuration.customName().get();
        }
        this.getTransferHandler().applyConfiguration(configuration, energy != null ? energy.longValue() : this.getTransferBuffer());
        if (this.level.isClientSide) {
            this.mClientColor = FluxUtils.getModifiedColor(ClientCache.getNetwork(this.mNetworkID).getNetworkColor(), 1.1f);
        }
        super.applyImplicitComponents(componentInput);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        FluxDeviceConfigComponent configuration = new FluxDeviceConfigComponent(this.mNetworkID, Optional.of(this.mCustomName), Optional.of(this.getRawPriority()), Optional.of(this.getSurgeMode()), Optional.of(this.getRawLimit()), Optional.of(this.getDisableLimit()));
        components.set(FluxDataComponents.FLUX_CONFIG, (Object)configuration);
        components.set(FluxDataComponents.STORED_ENERGY, (Object)this.getTransferBuffer());
        super.collectImplicitComponents(components);
    }

    @Override
    public void readCustomTag(@Nonnull CompoundTag tag, byte type) {
        if (type == 19) {
            boolean sort;
            String name;
            assert (!this.level.isClientSide);
            if (tag.isEmpty()) {
                return;
            }
            if (tag.contains("custom_name") && (name = tag.getString("custom_name")).length() <= 24) {
                this.mCustomName = name;
            }
            if ((sort = this.getTransferHandler().changeSettings(tag)) && this.mNetwork.isValid()) {
                ((ServerFluxNetwork)this.mNetwork).markSortConnections();
            }
            if (tag.contains("forced_loading")) {
                boolean load = tag.getBoolean("forced_loading") && FluxConfig.enableChunkLoading && !this.getDeviceType().isStorage();
                long chunkPos = ChunkPos.asLong((BlockPos)this.worldPosition);
                FluxChunkLoading.CONTROLLER.forceChunk((ServerLevel)this.level, this.worldPosition, ChunkPos.getX((long)chunkPos), ChunkPos.getZ((long)chunkPos), load, true);
                this.setForcedLoading(load);
            }
            this.mFlags |= 0x100;
            this.markChunkUnsaved();
            return;
        }
        this.mNetworkID = tag.getInt("network_id");
        this.mCustomName = tag.getString("custom_name");
        this.getTransferHandler().readCustomTag(tag, type);
        switch (type) {
            case 1: {
                this.mOwnerUUID = tag.getUUID("player_uuid");
                break;
            }
            case 11: {
                this.mOwnerUUID = tag.getUUID("player_uuid");
                if (tag.contains("client_color")) {
                    this.mClientColor = FluxUtils.getModifiedColor(tag.getInt("client_color"), 1.1f);
                }
                this.mFlags = tag.getInt("flags");
                break;
            }
            case 15: {
                if (!this.level.isClientSide) break;
                this.mClientColor = FluxUtils.getModifiedColor(ClientCache.getNetwork(this.mNetworkID).getNetworkColor(), 1.1f);
            }
        }
    }

    public boolean canPlayerAccess(@Nonnull Player player) {
        assert (this.level != null && !this.level.isClientSide);
        if (this.mNetwork.isValid()) {
            if (player.getUUID().equals(this.mOwnerUUID)) {
                return true;
            }
            return this.mNetwork.canPlayerAccess(player);
        }
        return true;
    }

    public void sendBlockUpdate() {
        assert (this.level != null && !this.level.isClientSide);
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 11);
    }

    public void writePacketBuffer(FriendlyByteBuf buf, byte type) {
        this.getTransferHandler().writePacketBuffer(buf, type);
    }

    public void readPacketBuffer(FriendlyByteBuf buf, byte type) {
        this.getTransferHandler().readPacketBuffer(buf, type);
    }

    public void markChunkUnsaved() {
        assert (this.level != null);
        this.level.getChunkAt(this.worldPosition).setUnsaved(true);
    }

    public void markEnergyChanged() {
        this.mFlags |= 0x200;
        this.markChunkUnsaved();
    }

    @Override
    @Nonnull
    public final UUID getOwnerUUID() {
        return this.mOwnerUUID;
    }

    public final void setOwnerUUID(@Nonnull UUID uuid) {
        if (!this.mOwnerUUID.equals(uuid)) {
            this.mOwnerUUID = uuid;
            this.mFlags |= 0x100;
            this.markChunkUnsaved();
        }
    }

    @Override
    public void onPlayerOpened(Player player) {
        assert (this.mPlayerUsing == null);
        this.mPlayerUsing = player;
    }

    @Override
    public void onPlayerClosed(Player player) {
        assert (this.level.isClientSide || this.mPlayerUsing == player);
        this.mPlayerUsing = null;
    }

    @Override
    @Nonnull
    public final String getCustomName() {
        return this.mCustomName;
    }

    @Override
    public boolean isChunkLoaded() {
        return !this.isRemoved();
    }

    @Override
    public boolean isForcedLoading() {
        return (this.mFlags & 0x40) != 0;
    }

    public void setForcedLoading(boolean forcedLoading) {
        this.mFlags = forcedLoading ? (this.mFlags |= 0x40) : (this.mFlags &= 0xFFFFFFBF);
    }

    @Override
    public final int getRawPriority() {
        return this.getTransferHandler().getRawPriority();
    }

    @Override
    public final long getRawLimit() {
        return this.getTransferHandler().getRawLimit();
    }

    @Override
    public long getMaxTransferLimit() {
        return Long.MAX_VALUE;
    }

    @Override
    public final long getTransferBuffer() {
        return this.getTransferHandler().getBuffer();
    }

    @Override
    public final long getTransferChange() {
        return this.getTransferHandler().getChange();
    }

    @Override
    @Nonnull
    public final GlobalPos getGlobalPos() {
        if (this.mGlobalPos == null) {
            this.mGlobalPos = GlobalPos.of((ResourceKey)this.level.dimension(), (BlockPos)this.worldPosition);
        }
        return this.mGlobalPos;
    }

    @Override
    public final boolean getDisableLimit() {
        return this.getTransferHandler().getDisableLimit();
    }

    @Override
    public final boolean getSurgeMode() {
        return this.getTransferHandler().getSurgeMode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{mNetworkID=" + this.mNetworkID + ", mGlobalPos=" + String.valueOf(this.mGlobalPos) + "}";
    }
}

