/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.crafting;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import sonar.fluxnetworks.api.FluxDataComponents;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FluxStorageRecipe
extends ShapedRecipe {
    public FluxStorageRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result, boolean flag) {
        super(group, category, pattern, result, flag);
    }

    public FluxStorageRecipe(ShapedRecipe recipe) {
        super(recipe.getGroup(), recipe.category(), recipe.pattern, recipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY));
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack result = super.assemble(input, registries);
        List<ItemStack> storageItems = input.items().stream().filter(stack -> !stack.isEmpty() && stack.get(FluxDataComponents.STORED_ENERGY) != null).toList();
        if (storageItems.isEmpty()) {
            return result;
        }
        long totalEnergy = storageItems.stream().map(stack -> (Long)stack.get(FluxDataComponents.STORED_ENERGY)).reduce(0L, Long::sum);
        result.set(FluxDataComponents.STORED_ENERGY, (Object)totalEnergy);
        result.copyFrom((DataComponentHolder)storageItems.getFirst(), new DataComponentType[]{FluxDataComponents.FLUX_CONFIG});
        return result;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<FluxStorageRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final MapCodec<FluxStorageRecipe> CODEC = RecipeSerializer.SHAPED_RECIPE.codec().xmap(FluxStorageRecipe::new, Function.identity());
        public static final StreamCodec<RegistryFriendlyByteBuf, FluxStorageRecipe> STREAM_CODEC = RecipeSerializer.SHAPED_RECIPE.streamCodec().map(FluxStorageRecipe::new, Function.identity());

        public MapCodec<FluxStorageRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FluxStorageRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private Serializer() {
        }
    }
}

