/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.button;

import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.network.WirelessType;
import sonar.fluxnetworks.client.gui.basic.GuiButtonCore;
import sonar.fluxnetworks.client.gui.tab.GuiTabWireless;
import sonar.fluxnetworks.common.util.FluxUtils;

public class InventoryButton
extends GuiButtonCore {
    public static final ResourceLocation INVENTORY = FluxNetworks.location("textures/gui/inventory_configuration.png");
    public WirelessType mType;
    private final int mU0;
    private final int mV0;
    public GuiTabWireless mHost;
    private final String mText;

    public InventoryButton(GuiTabWireless screen, int x, int y, int width, int height, @Nonnull WirelessType type, int u0, int v0) {
        super(screen, x, y, width, height);
        this.mHost = screen;
        this.mType = type;
        this.mText = type.getTranslatedName();
        this.mU0 = u0;
        this.mV0 = v0;
    }

    @Override
    protected void drawButton(GuiGraphics gr, int mouseX, int mouseY, float deltaTicks) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int color = this.mHost.getNetwork().getNetworkColor();
        RenderSystem.setShaderColor((float)FluxUtils.getRed(color), (float)FluxUtils.getGreen(color), (float)FluxUtils.getBlue(color), (float)1.0f);
        boolean hovered = this.isMouseHovered(mouseX, mouseY);
        gr.blit(INVENTORY, this.x, this.y, this.mU0, this.mV0 + this.height * (this.mType.isActivated(this.mHost.mWirelessMode) ? 1 : 0), this.width, this.height);
        if (hovered) {
            Font font = this.screen.getMinecraft().font;
            gr.drawString(font, this.mText, this.x + (this.width - font.width(this.mText)) / 2 + 1, this.y - 9, 0xFFFFFF);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

