/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.ftbquestslangsplitter.mixin;

import com.mojang.datafixers.util.Either;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.translation.TranslationManager;
import dev.ftb.mods.ftbquests.quest.translation.TranslationTable;
import dev.uncandango.ftbquestslangsplitter.FTBQuestsLangSplitter;
import dev.uncandango.ftbquestslangsplitter.mixin.accessor.TranslationTableAccessor;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={TranslationManager.class})
public abstract class TranslationManagerMixin {
    @Shadow
    @Final
    private Map<String, TranslationTable> map;

    @Shadow
    public abstract void saveToNBT(Path var1, boolean var2);

    @Overwrite
    public void loadFromNBT(BaseQuestFile file, Path langFolder) {
        this.map.clear();
        if (!TranslationManagerMixin.langsplitter$createFolder(langFolder)) {
            return;
        }
        long timeNow = Instant.now().getEpochSecond();
        try (Stream<Path> s = Files.list(langFolder);){
            s.sorted(Comparator.comparingInt(path -> Files.isDirectory(path, new LinkOption[0]) ? 1 : 0)).forEach(path -> {
                if (Files.isDirectory(path, new LinkOption[0]) && !path.getFileName().toString().equals("recovery")) {
                    String locale = path.getFileName().toString().toLowerCase(Locale.ROOT);
                    CompoundTag recovery = new CompoundTag();
                    try (Stream<Path> lang = Files.list(path).sorted(Comparator.comparingInt(path2 -> Files.isDirectory(path2, new LinkOption[0]) ? 1 : 0));){
                        lang.forEach(insideLang -> {
                            if (Files.isDirectory(insideLang, new LinkOption[0]) && insideLang.getFileName().toString().equals("chapters")) {
                                try (Stream<Path> chapter = Files.list(insideLang);){
                                    chapter.forEach(chapterPath -> {
                                        if (!Files.isDirectory(chapterPath, new LinkOption[0])) {
                                            TranslationManagerMixin.langsplitter$writeToOriginalLangFile(path, chapterPath, this.map, locale, recovery);
                                        }
                                    });
                                }
                                catch (IOException e) {
                                    FTBQuestsLangSplitter.LOGGER.error("can't scan lang folder {}: {}", path, (Object)e.getMessage());
                                }
                            } else {
                                TranslationManagerMixin.langsplitter$writeToOriginalLangFile(path, insideLang, this.map, locale, recovery);
                            }
                        });
                    }
                    catch (IOException e) {
                        FTBQuestsLangSplitter.LOGGER.error("can't scan lang folder {}: {}", path, (Object)e.getMessage());
                    }
                    if (!recovery.isEmpty()) {
                        Path recoveryFolder = langFolder.resolve("recovery");
                        TranslationManagerMixin.langsplitter$createFolder(recoveryFolder);
                        Path recoveredFile = recoveryFolder.resolve(locale + "_" + timeNow + ".snbt");
                        if (!SNBT.write((Path)recoveredFile, (CompoundTag)recovery)) {
                            FTBQuestsLangSplitter.LOGGER.error("Error while writing recovery file for lang {} at {}", (Object)locale, (Object)recoveredFile);
                        }
                    }
                } else if (TranslationManagerMixin.langsplitter$isValidLangFile(path)) {
                    SNBTCompoundTag langNBT = SNBT.read((Path)path);
                    if (langNBT != null) {
                        String locale = path.getFileName().toString().split("\\.", 2)[0].toLowerCase(Locale.ROOT);
                        this.map.put(locale, TranslationTable.fromNBT((CompoundTag)langNBT));
                    } else {
                        FTBQuestsLangSplitter.LOGGER.error("can't read lang file {}", path);
                    }
                }
            });
            if (!this.map.containsKey(file.getFallbackLocale())) {
                this.map.put(file.getFallbackLocale(), new TranslationTable());
            }
            FTBQuestsLangSplitter.LOGGER.info("loaded translation tables for {} language(s)", (Object)this.map.size());
        }
        catch (IOException e) {
            FTBQuestsLangSplitter.LOGGER.error("can't scan lang folder {}: {}", (Object)langFolder, (Object)e.getMessage());
        }
        this.saveToNBT(langFolder, false);
    }

    @Unique
    private static void langsplitter$writeToOriginalLangFile(Path localePath, Path filePath, Map<String, TranslationTable> localeMap, String locale, CompoundTag recovery) {
        if (TranslationManagerMixin.langsplitter$isValidLangFile(filePath)) {
            SNBTCompoundTag langNBT = SNBT.read((Path)filePath);
            if (langNBT != null) {
                TranslationTable table = localeMap.computeIfAbsent(locale, l -> new TranslationTable());
                Map<String, Either<String, List<String>>> tableMap = ((TranslationTableAccessor)table).langsplitter$getMap();
                AtomicBoolean merged = new AtomicBoolean();
                langNBT.getAllKeys().forEach(arg_0 -> TranslationManagerMixin.lambda$langsplitter$writeToOriginalLangFile$12((CompoundTag)langNBT, tableMap, table, merged, locale, localePath, filePath, recovery, arg_0));
                if (merged.get()) {
                    Path newPath = null;
                    try {
                        newPath = filePath.getParent().resolve(filePath.getFileName().toString() + "_merged");
                        Files.move(filePath, newPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        FTBQuestsLangSplitter.LOGGER.error("Error while renaming file from {} to {}", (Object)filePath, newPath);
                    }
                } else {
                    FTBQuestsLangSplitter.LOGGER.debug("File {} not merged because there was no change.", (Object)filePath);
                }
            } else {
                FTBQuestsLangSplitter.LOGGER.error("can't read lang file {}", (Object)filePath);
            }
        }
    }

    @Unique
    private static void langsplitter$addToRecovery(CompoundTag recovery, String fileName, String key, Either<String, List<String>> replaced, Tag newTag) {
        CompoundTag entries = recovery.getCompound(fileName);
        if (entries.isEmpty()) {
            recovery.put(fileName, (Tag)entries);
        }
        CompoundTag idEntry = new CompoundTag();
        entries.put(key, (Tag)idEntry);
        replaced.ifLeft(l -> idEntry.put("old", (Tag)StringTag.valueOf((String)l))).ifRight(r -> idEntry.put("old", (Tag)TranslationTableAccessor.langsplitter$listOfStr(r)));
        idEntry.put("new", newTag);
    }

    @Unique
    private static String langsplitter$getRelativePath(Path root, Path sibling) {
        return root.relativize(sibling).toString().replace('\\', '/');
    }

    @Unique
    private static boolean langsplitter$createFolder(Path folder) {
        if (!Files.exists(folder, new LinkOption[0])) {
            try {
                Files.createDirectories(folder, new FileAttribute[0]);
            }
            catch (IOException e) {
                FTBQuestsLangSplitter.LOGGER.error("can't create lang folder {}: {}", (Object)folder, (Object)e.getMessage());
                return false;
            }
        }
        return true;
    }

    @Unique
    private static boolean langsplitter$isValidLangFile(Path filePath) {
        if (filePath == null || filePath.getFileName() == null) {
            return false;
        }
        return filePath.getFileName().toString().toLowerCase(Locale.ROOT).endsWith(".snbt");
    }

    private static /* synthetic */ void lambda$langsplitter$writeToOriginalLangFile$12(CompoundTag langNBT, Map tableMap, TranslationTable table, AtomicBoolean merged, String locale, Path localePath, Path filePath, CompoundTag recovery, String key) {
        Tag entry = langNBT.get(key);
        Either newValue = null;
        ListTag newValueTag = null;
        if (entry instanceof ListTag) {
            ListTag lt = (ListTag)entry;
            if (lt.isEmpty()) {
                return;
            }
            newValue = Either.right(lt.stream().map(Tag::getAsString).toList());
            newValueTag = lt;
        }
        if (entry instanceof StringTag) {
            StringTag st = (StringTag)entry;
            if (st.getAsString().isEmpty()) {
                return;
            }
            newValue = Either.left((Object)st.getAsString());
            newValueTag = st;
        }
        if (newValue == null) {
            return;
        }
        Either replaced = tableMap.put(key, newValue);
        if (replaced == null) {
            ((TranslationTableAccessor)table).langsplitter$setSaveNeeded(true);
            merged.set(true);
        }
        if (replaced != null && !newValue.equals(replaced)) {
            FTBQuestsLangSplitter.LOGGER.warn("Key {} had it's value replaced at lang file {}!", (Object)key, (Object)locale);
            Either finalNewValue = newValue;
            replaced.ifLeft(l -> {
                FTBQuestsLangSplitter.LOGGER.warn("Old value: {}", l);
                finalNewValue.ifLeft(l2 -> FTBQuestsLangSplitter.LOGGER.warn("New value: {}", l2)).ifRight(r2 -> FTBQuestsLangSplitter.LOGGER.warn("New value: {}", r2));
            }).ifRight(r -> {
                FTBQuestsLangSplitter.LOGGER.warn("Old value: {}", r);
                finalNewValue.ifLeft(l2 -> FTBQuestsLangSplitter.LOGGER.warn("New value: {}", l2)).ifRight(r2 -> FTBQuestsLangSplitter.LOGGER.warn("New value: {}", r2));
            });
            String fileName = TranslationManagerMixin.langsplitter$getRelativePath(localePath, filePath);
            TranslationManagerMixin.langsplitter$addToRecovery(recovery, fileName, key, (Either<String, List<String>>)replaced, (Tag)newValueTag);
            ((TranslationTableAccessor)table).langsplitter$setSaveNeeded(true);
            merged.set(true);
        }
    }
}

