/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.courtyard;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import twilightforest.TwilightForestMod;
import twilightforest.enums.Diagonals;
import twilightforest.util.BoundingBoxUtils;
import twilightforest.world.components.structures.TFStructureComponent;
import twilightforest.world.components.structures.courtyard.CourtyardPathPiece;
import twilightforest.world.components.structures.courtyard.CourtyardTerrace;
import twilightforest.world.components.structures.courtyard.CourtyardTerraceHedge;
import twilightforest.world.components.structures.courtyard.CourtyardWall;
import twilightforest.world.components.structures.courtyard.CourtyardWallCornerInner;
import twilightforest.world.components.structures.courtyard.CourtyardWallCornerOuter;
import twilightforest.world.components.structures.courtyard.CourtyardWallPadder;
import twilightforest.world.components.structures.courtyard.NagaCourtyardHedgeCapComponent;
import twilightforest.world.components.structures.courtyard.NagaCourtyardHedgeCapPillarComponent;
import twilightforest.world.components.structures.courtyard.NagaCourtyardHedgeCornerComponent;
import twilightforest.world.components.structures.courtyard.NagaCourtyardHedgeIntersectionComponent;
import twilightforest.world.components.structures.courtyard.NagaCourtyardHedgeLineComponent;
import twilightforest.world.components.structures.courtyard.NagaCourtyardHedgePadderComponent;
import twilightforest.world.components.structures.courtyard.NagaCourtyardHedgeTJunctionComponent;

public abstract class StructureMazeGenerator
extends TFStructureComponent {
    protected final int[][] maze;
    private final int[][] cornerClipping = new int[4][2];
    private final int widthInCellCount;
    private final int heightInCellCount;
    private final StructureTemplateManager structureManager;
    protected BoundingBox sizeConstraints;

    public StructureMazeGenerator(StructureTemplateManager structureManager, StructurePieceType piece, CompoundTag nbt) {
        super(piece, nbt);
        this.widthInCellCount = nbt.getInt("mazeWidth");
        this.heightInCellCount = nbt.getInt("mazeHeight");
        this.maze = new int[this.widthInCellCount - 1][this.heightInCellCount - 1];
        ListTag mazeX = nbt.getList("maze", 9);
        for (int x = 0; x < this.widthInCellCount - 1; ++x) {
            Tag mazeY = mazeX.get(x);
            if (!(mazeY instanceof ListTag)) continue;
            for (int y = 0; y < this.heightInCellCount - 1; ++y) {
                this.maze[x][y] = ((ListTag)mazeY).getInt(y);
            }
        }
        this.sizeConstraints = BoundingBoxUtils.NBTToBoundingBox(nbt.getCompound("constraints"));
        this.structureManager = structureManager;
    }

    StructureMazeGenerator(StructurePieceType type, RandomSource rand, int i, int widthInCellCount, int heightInCellCount, int x, int y, int z, StructureTemplateManager structureManager) {
        super(type, i, x, y, z);
        this.widthInCellCount = widthInCellCount;
        this.heightInCellCount = heightInCellCount;
        this.structureManager = structureManager;
        this.maze = new int[widthInCellCount - 1][heightInCellCount - 1];
        StructureMazeGenerator.generateMaze(this.maze, this.cornerClipping, rand, this.widthInCellCount, this.heightInCellCount, 2);
        this.sizeConstraints = this.getBoundingBox();
    }

    public void addChildren(StructurePiece structureComponent, StructurePieceAccessor list, RandomSource random) {
        super.addChildren(structureComponent, list, random);
        int offset = 6;
        Rotation[] rotations = Rotation.values();
        this.processInnerWallsAndFloor(structureComponent, list, random, 6, rotations);
        this.processOuterWalls(structureComponent, list, random, 6, rotations);
    }

    private static void generateMaze(int[][] maze, int[][] cornerClippings, RandomSource random, int widthInCellCount, int heightInCellCount, int maximumClipping) {
        int x;
        WallFacing[][] rotations = new WallFacing[maze.length][maze[0].length];
        for (int x2 = 0; x2 < widthInCellCount - 1; ++x2) {
            for (int y = 0; y < heightInCellCount - 1; ++y) {
                rotations[x2][y] = WallFacing.values()[random.nextInt(WallFacing.values().length)];
                int[] nArray = maze[x2];
                int n = y;
                nArray[n] = nArray[n] | rotations[x2][y].BYTE;
            }
        }
        int[][] mazeLocal = (int[][])maze.clone();
        int halfWayPointX = widthInCellCount / 2 - 1;
        int halfWayPointY = heightInCellCount / 2 - 1;
        for (int y = 0; y < heightInCellCount - 1; ++y) {
            for (x = 0; x < widthInCellCount - 1; ++x) {
                if (x == halfWayPointX && y == halfWayPointY) continue;
                if (rotations[x][y] == WallFacing.WEST && x > 0) {
                    if (!rotations[x][y].unpackAndTest(maze[x - 1][y])) {
                        int[] nArray = maze[x - 1];
                        int n = y;
                        nArray[n] = nArray[n] | rotations[x][y].OPPOSITE;
                    } else {
                        int[] nArray = maze[x];
                        int n = y;
                        nArray[n] = nArray[n] & rotations[x][y].INVERTED;
                        int[] nArray2 = maze[x - 1];
                        int n2 = y;
                        nArray2[n2] = nArray2[n2] & rotations[x - 1][y].INVERTED_OPPOSITE;
                    }
                }
                if (rotations[x][y] == WallFacing.NORTH && y > 0) {
                    if (!rotations[x][y].unpackAndTest(maze[x][y - 1])) {
                        int[] nArray = maze[x];
                        int n = y - 1;
                        nArray[n] = nArray[n] | rotations[x][y].OPPOSITE;
                    } else {
                        int[] nArray = maze[x];
                        int n = y;
                        nArray[n] = nArray[n] & rotations[x][y].INVERTED;
                        int[] nArray3 = maze[x];
                        int n3 = y - 1;
                        nArray3[n3] = nArray3[n3] & rotations[x][y - 1].INVERTED_OPPOSITE;
                    }
                }
                if (rotations[x][y] == WallFacing.EAST && x < widthInCellCount - 2) {
                    if (!rotations[x][y].unpackAndTest(maze[x + 1][y])) {
                        int[] nArray = maze[x + 1];
                        int n = y;
                        nArray[n] = nArray[n] | rotations[x][y].OPPOSITE;
                    } else {
                        int[] nArray = maze[x];
                        int n = y;
                        nArray[n] = nArray[n] & rotations[x][y].INVERTED;
                        int[] nArray4 = maze[x + 1];
                        int n4 = y;
                        nArray4[n4] = nArray4[n4] & rotations[x + 1][y].INVERTED_OPPOSITE;
                    }
                }
                if (rotations[x][y] != WallFacing.SOUTH || y >= heightInCellCount - 2) continue;
                if (!rotations[x][y].unpackAndTest(maze[x][y + 1])) {
                    int[] nArray = maze[x];
                    int n = y + 1;
                    nArray[n] = nArray[n] | rotations[x][y].OPPOSITE;
                    continue;
                }
                int[] nArray = maze[x];
                int n = y;
                nArray[n] = nArray[n] & rotations[x][y].INVERTED;
                int[] nArray5 = maze[x];
                int n5 = y + 1;
                nArray5[n5] = nArray5[n5] & rotations[x][y + 1].INVERTED_OPPOSITE;
            }
        }
        WallFacing[] y = WallFacing.values();
        x = y.length;
        for (int i = 0; i < x; ++i) {
            WallFacing facing = y[i];
            int[] nArray = maze[halfWayPointX + facing.xOffset];
            int n = halfWayPointY + facing.zOffset;
            nArray[n] = nArray[n] & facing.INVERTED_OPPOSITE;
        }
        maze[halfWayPointX][halfWayPointY] = 16;
        for (int x3 = 1; x3 < maze.length; ++x3) {
            for (int y2 = 1; y2 < maze[x3].length; ++y2) {
                if (mazeLocal[x3][y2] != 0) continue;
                if (mazeLocal[x3 - 1][y2] == 0) {
                    int[] nArray = maze[x3];
                    int n = y2;
                    nArray[n] = nArray[n] | WallFacing.WEST.BYTE;
                    int[] nArray6 = maze[x3 - 1];
                    int n6 = y2;
                    nArray6[n6] = nArray6[n6] | WallFacing.WEST.OPPOSITE;
                }
                if (mazeLocal[x3][y2 - 1] != 0) continue;
                int[] nArray = maze[x3];
                int n = y2;
                nArray[n] = nArray[n] | WallFacing.NORTH.BYTE;
                int[] nArray7 = maze[x3];
                int n7 = y2 - 1;
                nArray7[n7] = nArray7[n7] | WallFacing.NORTH.OPPOSITE;
            }
        }
        for (Diagonals diagonals : Diagonals.values()) {
            cornerClippings[diagonals.ordinal()][0] = random.nextInt(maximumClipping) + 1;
            cornerClippings[diagonals.ordinal()][1] = random.nextInt(maximumClipping) + 1;
            for (int y3 = 0; y3 < cornerClippings[diagonals.ordinal()][0]; ++y3) {
                for (int x4 = 0; x4 < cornerClippings[diagonals.ordinal()][1]; ++x4) {
                    int[] nArray = maze[diagonals.operationX.convert(x4, widthInCellCount - 2)];
                    int n = diagonals.operationY.convert(y3, heightInCellCount - 2);
                    nArray[n] = nArray[n] | 0x10;
                }
            }
        }
    }

    private void processInnerWallsAndFloor(StructurePiece structureComponent, StructurePieceAccessor list, RandomSource random, int offset, Rotation[] rotations) {
        for (int x = 0; x < this.widthInCellCount - 1; ++x) {
            for (int y = 0; y < this.heightInCellCount - 1; ++y) {
                CourtyardPathPiece path2;
                boolean eastSouthHasNoTerraceOrIsSafe;
                NagaCourtyardHedgeLineComponent structureLine;
                NagaCourtyardHedgePadderComponent padding2;
                NagaCourtyardHedgePadderComponent padding;
                boolean yCenter;
                boolean xCenter = x == this.widthInCellCount / 2 - 1;
                boolean bl = yCenter = y == this.heightInCellCount / 2 - 1;
                if (!xCenter && !yCenter && (this.maze[x][y] & 0x10) == 16) continue;
                int rotation = 0;
                int xBB = this.sizeConstraints.minX() + x * 12 + offset;
                int yBB = this.sizeConstraints.minY() + 1;
                int zBB = this.sizeConstraints.minZ() + y * 12 + offset;
                if (!xCenter || !yCenter) {
                    Object structure;
                    switch (this.maze[x][y] & 0xF) {
                        case 2: {
                            ++rotation;
                        }
                        case 1: {
                            ++rotation;
                        }
                        case 8: {
                            ++rotation;
                        }
                        case 4: {
                            Rotation rotationCap = rotations[rotation];
                            if (random.nextBoolean()) {
                                structure = new NagaCourtyardHedgeCapComponent(this.structureManager, x * this.widthInCellCount + y, xBB, yBB, zBB, rotationCap);
                                break;
                            }
                            structure = new NagaCourtyardHedgeCapPillarComponent(this.structureManager, x * this.widthInCellCount + y, xBB, yBB, zBB, rotationCap);
                            break;
                        }
                        case 9: {
                            ++rotation;
                        }
                        case 12: {
                            ++rotation;
                        }
                        case 6: {
                            ++rotation;
                        }
                        case 3: {
                            Rotation rotationCorner = rotations[rotation];
                            structure = new NagaCourtyardHedgeCornerComponent(this.structureManager, this.maze[x][y], xBB, yBB, zBB, rotationCorner);
                            break;
                        }
                        case 13: {
                            ++rotation;
                        }
                        case 14: {
                            ++rotation;
                        }
                        case 7: {
                            ++rotation;
                        }
                        case 11: {
                            Rotation rotationT = rotations[rotation];
                            structure = new NagaCourtyardHedgeTJunctionComponent(this.structureManager, this.maze[x][y], xBB, yBB, zBB, rotationT);
                            break;
                        }
                        case 10: {
                            ++rotation;
                        }
                        case 5: {
                            Rotation rotationLine = rotations[rotation];
                            structure = new NagaCourtyardHedgeLineComponent(this.structureManager, this.maze[x][y], xBB, yBB, zBB, rotationLine);
                            break;
                        }
                        case 15: {
                            structure = new NagaCourtyardHedgeIntersectionComponent(this.structureManager, this.maze[x][y], xBB, yBB, zBB, Rotation.NONE);
                            break;
                        }
                        default: {
                            if (random.nextInt(150) == 0) {
                                structure = new CourtyardTerrace(this.maze[x][y], xBB - 6, yBB - 3, zBB - 6, Rotation.NONE, this.structureManager, TwilightForestMod.prefix("courtyard/terrace_statue"));
                                break;
                            }
                            structure = switch (random.nextInt(5)) {
                                case 1 -> new CourtyardTerrace(this.maze[x][y], xBB - 6, yBB - 3, zBB - 6, Rotation.NONE, this.structureManager, TwilightForestMod.prefix("courtyard/terrace_duct"));
                                case 2 -> new CourtyardTerrace(this.maze[x][y], xBB - 6, yBB - 3, zBB - 6, Rotation.NONE, this.structureManager, TwilightForestMod.prefix("courtyard/terrace_channel"));
                                case 3 -> new CourtyardTerrace(this.maze[x][y], xBB - 6, yBB - 3, zBB - 6, Rotation.NONE, this.structureManager, TwilightForestMod.prefix("courtyard/terrace_reservoir"));
                                case 4 -> new CourtyardTerraceHedge(this.maze[x][y], xBB - 6, yBB - 3, zBB - 6, Rotation.NONE, this.structureManager);
                                default -> new CourtyardTerrace(this.maze[x][y], xBB - 6, yBB - 3, zBB - 6, Rotation.NONE, this.structureManager, TwilightForestMod.prefix("courtyard/terrace_fire"));
                            };
                        }
                    }
                    list.addPiece((StructurePiece)structure);
                    structure.addChildren(structureComponent, list, random);
                }
                xBB = this.sizeConstraints.minX() + x * 12 + offset;
                zBB = this.sizeConstraints.minZ() + y * 12 + offset;
                boolean connectWest = WallFacing.WEST.unpackAndTest(this.maze[x][y]);
                boolean connectNorth = WallFacing.NORTH.unpackAndTest(this.maze[x][y]);
                boolean connectEast = WallFacing.EAST.unpackAndTest(this.maze[x][y]);
                boolean connectSouth = WallFacing.SOUTH.unpackAndTest(this.maze[x][y]);
                if (connectWest) {
                    padding = new NagaCourtyardHedgePadderComponent(this.structureManager, this.maze[x][y], xBB - 1, yBB, zBB, Rotation.NONE);
                    list.addPiece((StructurePiece)padding);
                    padding.addChildren(structureComponent, list, random);
                    if (x > 0 && (this.maze[x - 1][y] & 0x10) != 16) {
                        padding2 = new NagaCourtyardHedgePadderComponent(this.structureManager, this.maze[x][y], xBB - 7, yBB, zBB, Rotation.NONE);
                        list.addPiece((StructurePiece)padding2);
                        padding2.addChildren(structureComponent, list, random);
                    }
                    structureLine = new NagaCourtyardHedgeLineComponent(this.structureManager, this.maze[x][y], xBB - 6, yBB, zBB, Rotation.NONE);
                    list.addPiece((StructurePiece)structureLine);
                    structureLine.addChildren(structureComponent, list, random);
                }
                if (connectNorth) {
                    padding = new NagaCourtyardHedgePadderComponent(this.structureManager, this.maze[x][y], xBB + 4, yBB, zBB - 1, Rotation.CLOCKWISE_90);
                    list.addPiece((StructurePiece)padding);
                    padding.addChildren(structureComponent, list, random);
                    if (y > 0 && (this.maze[x][y - 1] & 0x10) != 16) {
                        padding2 = new NagaCourtyardHedgePadderComponent(this.structureManager, this.maze[x][y], xBB + 4, yBB, zBB - 7, Rotation.CLOCKWISE_90);
                        list.addPiece((StructurePiece)padding2);
                        padding2.addChildren(structureComponent, list, random);
                    }
                    structureLine = new NagaCourtyardHedgeLineComponent(this.structureManager, this.maze[x][y], xBB, yBB, zBB - 6, Rotation.CLOCKWISE_90);
                    list.addPiece((StructurePiece)structureLine);
                    structureLine.addChildren(structureComponent, list, random);
                }
                if ((x >= this.widthInCellCount - 2 || (this.maze[x + 1][y] & 0x10) == 16) && connectEast) {
                    padding = new NagaCourtyardHedgePadderComponent(this.structureManager, this.maze[x][y], xBB + 5, yBB, zBB, Rotation.NONE);
                    list.addPiece((StructurePiece)padding);
                    padding.addChildren(structureComponent, list, random);
                    structureLine = new NagaCourtyardHedgeLineComponent(this.structureManager, this.maze[x][y], xBB + 6, yBB, zBB, Rotation.NONE);
                    list.addPiece((StructurePiece)structureLine);
                    structureLine.addChildren(structureComponent, list, random);
                }
                if ((y >= this.heightInCellCount - 2 || (this.maze[x][y + 1] & 0x10) == 16) && connectSouth) {
                    padding = new NagaCourtyardHedgePadderComponent(this.structureManager, this.maze[x][y], xBB + 4, yBB, zBB + 5, Rotation.CLOCKWISE_90);
                    list.addPiece((StructurePiece)padding);
                    padding.addChildren(structureComponent, list, random);
                    structureLine = new NagaCourtyardHedgeLineComponent(this.structureManager, this.maze[x][y], xBB, yBB, zBB + 6, Rotation.CLOCKWISE_90);
                    list.addPiece((StructurePiece)structureLine);
                    structureLine.addChildren(structureComponent, list, random);
                }
                boolean hasNoTerrace = (this.maze[x][y] & 0xF) != 0;
                boolean westHasNoTerraceOrIsSafe = x == 0 || (this.maze[x - 1][y] & 0x10) == 16 || (this.maze[x - 1][y] & 0xF) != 0;
                boolean northHasNoTerraceOrIsSafe = y == 0 || (this.maze[x][y - 1] & 0x10) == 16 || (this.maze[x][y - 1] & 0xF) != 0;
                boolean eastHasNoTerraceOrIsSafe = x == this.widthInCellCount - 2 || (this.maze[x + 1][y] & 0x10) == 16;
                boolean southHasNoTerraceOrIsSafe = y == this.heightInCellCount - 2 || (this.maze[x][y + 1] & 0x10) == 16;
                boolean westNorthHasNoTerraceOrIsSafe = x == 0 || y == 0 || this.maze[x - 1][y - 1] != 0;
                boolean westSouthHasNoTerraceOrIsSafe = x == 0 || y >= this.heightInCellCount - 2 || this.maze[x - 1][y + 1] != 0;
                boolean eastNorthHasNoTerraceOrIsSafe = x >= this.widthInCellCount - 2 || y == 0 || this.maze[x + 1][y - 1] != 0;
                boolean bl2 = eastSouthHasNoTerraceOrIsSafe = x >= this.widthInCellCount - 2 || y >= this.heightInCellCount - 2 || this.maze[x + 1][y + 1] != 0;
                if (xCenter && yCenter) {
                    CourtyardPathPiece path = new CourtyardPathPiece(this.maze[x][y], xBB - 1, yBB - 1, zBB - 1, this.structureManager);
                    list.addPiece((StructurePiece)path);
                    path.addChildren(structureComponent, list, random);
                }
                if (hasNoTerrace && westHasNoTerraceOrIsSafe && !connectWest) {
                    path2 = new CourtyardPathPiece(this.maze[x][y], xBB - 7, yBB - 1, zBB - 1, this.structureManager);
                    list.addPiece((StructurePiece)path2);
                    path2.addChildren(structureComponent, list, random);
                }
                if (hasNoTerrace && northHasNoTerraceOrIsSafe && !connectNorth) {
                    path2 = new CourtyardPathPiece(this.maze[x][y], xBB - 1, yBB - 1, zBB - 7, this.structureManager);
                    list.addPiece((StructurePiece)path2);
                    path2.addChildren(structureComponent, list, random);
                }
                if (hasNoTerrace && eastHasNoTerraceOrIsSafe) {
                    path2 = new CourtyardPathPiece(this.maze[x][y], xBB + 5, yBB - 1, zBB - 1, this.structureManager);
                    list.addPiece((StructurePiece)path2);
                    path2.addChildren(structureComponent, list, random);
                }
                if (hasNoTerrace && southHasNoTerraceOrIsSafe) {
                    path2 = new CourtyardPathPiece(this.maze[x][y], xBB - 1, yBB - 1, zBB + 5, this.structureManager);
                    list.addPiece((StructurePiece)path2);
                    path2.addChildren(structureComponent, list, random);
                }
                if (hasNoTerrace && westHasNoTerraceOrIsSafe && northHasNoTerraceOrIsSafe && westNorthHasNoTerraceOrIsSafe) {
                    path2 = new CourtyardPathPiece(this.maze[x][y], xBB - 7, yBB - 1, zBB - 7, this.structureManager);
                    list.addPiece((StructurePiece)path2);
                    path2.addChildren(structureComponent, list, random);
                }
                if (hasNoTerrace && westHasNoTerraceOrIsSafe && southHasNoTerraceOrIsSafe && westSouthHasNoTerraceOrIsSafe) {
                    path2 = new CourtyardPathPiece(this.maze[x][y], xBB - 7, yBB - 1, zBB + 5, this.structureManager);
                    list.addPiece((StructurePiece)path2);
                    path2.addChildren(structureComponent, list, random);
                }
                if (hasNoTerrace && eastHasNoTerraceOrIsSafe && northHasNoTerraceOrIsSafe && eastNorthHasNoTerraceOrIsSafe) {
                    path2 = new CourtyardPathPiece(this.maze[x][y], xBB + 5, yBB - 1, zBB - 7, this.structureManager);
                    list.addPiece((StructurePiece)path2);
                    path2.addChildren(structureComponent, list, random);
                }
                if (!hasNoTerrace || !eastHasNoTerraceOrIsSafe || !southHasNoTerraceOrIsSafe || !eastSouthHasNoTerraceOrIsSafe) continue;
                path2 = new CourtyardPathPiece(this.maze[x][y], xBB + 5, yBB - 1, zBB + 5, this.structureManager);
                list.addPiece((StructurePiece)path2);
                path2.addChildren(structureComponent, list, random);
            }
        }
    }

    private void processOuterWalls(StructurePiece structureComponent, StructurePieceAccessor list, RandomSource random, int offset, Rotation[] rotations) {
        for (Diagonals diagonal : Diagonals.values()) {
            int zBoundX = diagonal.isTop() ? this.sizeConstraints.minZ() + this.cornerClipping[diagonal.ordinal()][0] * 12 - 3 : this.sizeConstraints.maxZ() - this.cornerClipping[diagonal.ordinal()][0] * 12 + 1;
            CourtyardWallPadder paddingStartX = new CourtyardWallPadder(this.cornerClipping[diagonal.ordinal()][1] * 2 + 1, diagonal.isLeft() ? this.sizeConstraints.minX() + 2 : this.sizeConstraints.maxX() - 2, this.sizeConstraints.minY() + 1, zBoundX, Rotation.NONE, this.structureManager);
            list.addPiece((StructurePiece)paddingStartX);
            paddingStartX.addChildren(structureComponent, list, random);
            int xPadOffset = diagonal.isLeft() ? 11 : -1;
            for (int i = 0; i < this.cornerClipping[diagonal.ordinal()][1] - 1; ++i) {
                int xBound = diagonal.isLeft() ? this.sizeConstraints.minX() + i * 12 + 3 : this.sizeConstraints.maxX() - i * 12 - 13;
                CourtyardWall wall = new CourtyardWall(i * 2, xBound, this.sizeConstraints.minY() + 1, zBoundX, Rotation.NONE, this.structureManager);
                list.addPiece((StructurePiece)wall);
                wall.addChildren(structureComponent, list, random);
                CourtyardWallPadder padding = new CourtyardWallPadder(i * 2 + 1, xBound + xPadOffset, this.sizeConstraints.minY() + 1, zBoundX, Rotation.NONE, this.structureManager);
                list.addPiece((StructurePiece)padding);
                padding.addChildren(structureComponent, list, random);
            }
            int xBoundZ = diagonal.isLeft() ? this.sizeConstraints.minX() + this.cornerClipping[diagonal.ordinal()][1] * 12 - 1 : this.sizeConstraints.maxX() - this.cornerClipping[diagonal.ordinal()][1] * 12 + 3;
            CourtyardWallPadder paddingStartZ = new CourtyardWallPadder(this.cornerClipping[diagonal.ordinal()][1] * 2 + 1, xBoundZ, this.sizeConstraints.minY() + 1, diagonal.isTop() ? this.sizeConstraints.minZ() + 2 : this.sizeConstraints.maxZ() - 2, Rotation.CLOCKWISE_90, this.structureManager);
            list.addPiece((StructurePiece)paddingStartZ);
            paddingStartZ.addChildren(structureComponent, list, random);
            int zPadOffset = diagonal.isTop() ? 11 : -1;
            for (int i = 0; i < this.cornerClipping[diagonal.ordinal()][0] - 1; ++i) {
                int zBound = diagonal.isTop() ? this.sizeConstraints.minZ() + i * 12 + 3 : this.sizeConstraints.maxZ() - i * 12 - 13;
                CourtyardWall wall = new CourtyardWall(i * 2, xBoundZ, this.sizeConstraints.minY() + 1, zBound, Rotation.CLOCKWISE_90, this.structureManager);
                list.addPiece((StructurePiece)wall);
                wall.addChildren(structureComponent, list, random);
                CourtyardWallPadder padding = new CourtyardWallPadder(i * 2 + 1, xBoundZ, this.sizeConstraints.minY() + 1, zBound + zPadOffset, Rotation.CLOCKWISE_90, this.structureManager);
                list.addPiece((StructurePiece)padding);
                padding.addChildren(structureComponent, list, random);
            }
            int wallCornerInnerX = this.sizeConstraints.minX() + diagonal.operationX.convert(this.cornerClipping[diagonal.ordinal()][1], this.widthInCellCount - 1) * 12;
            int wallCornerInnerZ = this.sizeConstraints.minZ() + diagonal.operationY.convert(this.cornerClipping[diagonal.ordinal()][0], this.heightInCellCount - 1) * 12;
            Rotation cornerRotation = rotations[diagonal.ordinal() % rotations.length];
            boolean shiftX = cornerRotation == Rotation.CLOCKWISE_180 || cornerRotation == Rotation.COUNTERCLOCKWISE_90;
            boolean shiftZ = cornerRotation == Rotation.CLOCKWISE_90 || cornerRotation == Rotation.CLOCKWISE_180;
            CourtyardWallCornerOuter corner1 = new CourtyardWallCornerOuter(diagonal.ordinal() * 3, wallCornerInnerX + (shiftZ ? (shiftX ? 1 : 7) : (shiftX ? -3 : 3)), this.sizeConstraints.minY() + 1, (diagonal.isTop() ? this.sizeConstraints.minZ() : this.sizeConstraints.maxZ() - 1) + (shiftZ ? (shiftX ? 4 : 0) : (shiftX ? 1 : -3)), cornerRotation, this.structureManager);
            list.addPiece((StructurePiece)corner1);
            corner1.addChildren(structureComponent, list, random);
            CourtyardWallCornerOuter corner2 = new CourtyardWallCornerOuter(diagonal.ordinal() * 3 + 1, (diagonal.isLeft() ? this.sizeConstraints.minX() : this.sizeConstraints.maxX() - 1) + (shiftZ ? (shiftX ? 1 : 4) : (shiftX ? -3 : 0)), this.sizeConstraints.minY() + 1, wallCornerInnerZ + (shiftZ ? (shiftX ? 7 : 3) : (shiftX ? 1 : -3)), cornerRotation, this.structureManager);
            list.addPiece((StructurePiece)corner2);
            corner2.addChildren(structureComponent, list, random);
            CourtyardWallCornerInner innerCorner = new CourtyardWallCornerInner(diagonal.ordinal() * 3 + 3, wallCornerInnerX + (shiftZ ? (shiftX ? -1 : 13) : (shiftX ? -9 : 5)), this.sizeConstraints.minY() + 1, wallCornerInnerZ + (shiftZ ? (shiftX ? 13 : 5) : (shiftX ? -1 : -9)), cornerRotation, this.structureManager);
            list.addPiece((StructurePiece)innerCorner);
            innerCorner.addChildren(structureComponent, list, random);
        }
        for (int i = this.cornerClipping[3][1]; i < this.widthInCellCount - 1 - this.cornerClipping[0][1]; ++i) {
            CourtyardWall wall = new CourtyardWall(i, this.sizeConstraints.minX() + i * 12 + offset - 3, this.sizeConstraints.minY() + 1, this.sizeConstraints.minZ() - 3, Rotation.NONE, this.structureManager);
            list.addPiece((StructurePiece)wall);
            wall.addChildren(structureComponent, list, random);
            CourtyardWallPadder padding = new CourtyardWallPadder(i, this.sizeConstraints.minX() + i * 12 + offset - 4, this.sizeConstraints.minY() + 1, this.sizeConstraints.minZ() - 3, Rotation.NONE, this.structureManager);
            list.addPiece((StructurePiece)padding);
            padding.addChildren(structureComponent, list, random);
        }
        CourtyardWallPadder padding2 = new CourtyardWallPadder(this.widthInCellCount - 1 - this.cornerClipping[0][1], this.sizeConstraints.minX() + (this.widthInCellCount - 1 - this.cornerClipping[0][1]) * 12 + offset - 4, this.sizeConstraints.minY() + 1, this.sizeConstraints.minZ() - 3, Rotation.NONE, this.structureManager);
        list.addPiece((StructurePiece)padding2);
        padding2.addChildren(structureComponent, list, random);
        for (int i = this.cornerClipping[2][1]; i < this.widthInCellCount - 1 - this.cornerClipping[1][1]; ++i) {
            CourtyardWall wall = new CourtyardWall(i, this.sizeConstraints.minX() + i * 12 + offset - 3, this.sizeConstraints.minY() + 1, this.sizeConstraints.maxZ() + 1, Rotation.NONE, this.structureManager);
            list.addPiece((StructurePiece)wall);
            wall.addChildren(structureComponent, list, random);
            CourtyardWallPadder padding = new CourtyardWallPadder(i, this.sizeConstraints.minX() + i * 12 + offset - 4, this.sizeConstraints.minY() + 1, this.sizeConstraints.maxZ() + 1, Rotation.NONE, this.structureManager);
            list.addPiece((StructurePiece)padding);
            padding.addChildren(structureComponent, list, random);
        }
        CourtyardWallPadder padding5 = new CourtyardWallPadder(this.widthInCellCount - 1 - this.cornerClipping[1][1], this.sizeConstraints.minX() + (this.widthInCellCount - 1 - this.cornerClipping[1][1]) * 12 + offset - 4, this.sizeConstraints.minY() + 1, this.sizeConstraints.maxZ() + 1, Rotation.NONE, this.structureManager);
        list.addPiece((StructurePiece)padding5);
        padding5.addChildren(structureComponent, list, random);
        for (int i = this.cornerClipping[3][0]; i < this.heightInCellCount - 1 - this.cornerClipping[2][0]; ++i) {
            CourtyardWall wall = new CourtyardWall(i, this.sizeConstraints.minX() - 1, this.sizeConstraints.minY() + 1, this.sizeConstraints.minZ() + i * 12 + offset - 3, Rotation.CLOCKWISE_90, this.structureManager);
            list.addPiece((StructurePiece)wall);
            wall.addChildren(structureComponent, list, random);
            CourtyardWallPadder padding = new CourtyardWallPadder(i, this.sizeConstraints.minX() - 1, this.sizeConstraints.minY() + 1, this.sizeConstraints.minZ() + i * 12 + offset - 4, Rotation.CLOCKWISE_90, this.structureManager);
            list.addPiece((StructurePiece)padding);
            padding.addChildren(structureComponent, list, random);
        }
        CourtyardWallPadder padding8 = new CourtyardWallPadder(this.heightInCellCount - 1 - this.cornerClipping[2][0], this.sizeConstraints.minX() - 1, this.sizeConstraints.minY() + 1, this.sizeConstraints.minZ() + (this.heightInCellCount - 1 - this.cornerClipping[2][0]) * 12 + offset - 4, Rotation.CLOCKWISE_90, this.structureManager);
        list.addPiece((StructurePiece)padding8);
        padding8.addChildren(structureComponent, list, random);
        for (int i = this.cornerClipping[0][0]; i < this.heightInCellCount - 1 - this.cornerClipping[1][0]; ++i) {
            CourtyardWall wall = new CourtyardWall(i, this.sizeConstraints.maxX() + 3, this.sizeConstraints.minY() + 1, this.sizeConstraints.minZ() + i * 12 + offset - 3, Rotation.CLOCKWISE_90, this.structureManager);
            list.addPiece((StructurePiece)wall);
            wall.addChildren(structureComponent, list, random);
            CourtyardWallPadder padding = new CourtyardWallPadder(i, this.sizeConstraints.maxX() + 3, this.sizeConstraints.minY() + 1, this.sizeConstraints.minZ() + i * 12 + offset - 4, Rotation.CLOCKWISE_90, this.structureManager);
            list.addPiece((StructurePiece)padding);
            padding.addChildren(structureComponent, list, random);
        }
        CourtyardWallPadder padding11 = new CourtyardWallPadder(this.heightInCellCount - 1 - this.cornerClipping[1][0], this.sizeConstraints.maxX() + 3, this.sizeConstraints.minY() + 1, this.sizeConstraints.minZ() + (this.heightInCellCount - 1 - this.cornerClipping[1][0]) * 12 + offset - 4, Rotation.CLOCKWISE_90, this.structureManager);
        list.addPiece((StructurePiece)padding11);
        padding11.addChildren(structureComponent, list, random);
    }

    private static String getStringFromFacings(int directions) {
        return switch (directions & 0xF) {
            case 2 -> " \u2577 ";
            case 1 -> " \u2576\u2500";
            case 8 -> " \u2575 ";
            case 4 -> "\u2500\u2574 ";
            case 9 -> " \u2514\u2500";
            case 12 -> "\u2500\u2518 ";
            case 6 -> "\u2500\u2510 ";
            case 3 -> " \u250c\u2500";
            case 13 -> "\u2500\u2534\u2500";
            case 14 -> "\u2500\u2524 ";
            case 7 -> "\u2500\u252c\u2500";
            case 11 -> " \u251c\u2500";
            case 10 -> " \u2502 ";
            case 5 -> "\u2500\u2500\u2500";
            case 15 -> "\u2500\u253c\u2500";
            default -> " \u2022 ";
        };
    }

    @Override
    protected void addAdditionalSaveData(StructurePieceSerializationContext ctx, CompoundTag tagCompound) {
        super.addAdditionalSaveData(ctx, tagCompound);
        ListTag mazeX = new ListTag();
        for (int x = 0; x < this.widthInCellCount - 1; ++x) {
            ListTag mazeY = new ListTag();
            for (int y = 0; y < this.heightInCellCount - 1; ++y) {
                mazeY.add((Object)IntTag.valueOf((int)this.maze[x][y]));
            }
            mazeX.add((Object)mazeY);
        }
        tagCompound.putInt("mazeWidth", this.widthInCellCount);
        tagCompound.putInt("mazeHeight", this.heightInCellCount);
        tagCompound.put("maze", (Tag)mazeX);
        tagCompound.put("constraints", (Tag)BoundingBoxUtils.boundingBoxToNBT(this.sizeConstraints));
    }

    protected static enum WallFacing {
        EAST(1, 4, 14, 11, Direction.EAST, 1, 0),
        SOUTH(2, 8, 13, 7, Direction.SOUTH, 0, 1),
        WEST(4, 1, 11, 14, Direction.WEST, -1, 0),
        NORTH(8, 2, 7, 13, Direction.NORTH, 0, -1);

        private final int BYTE;
        private final int OPPOSITE;
        private final int INVERTED;
        private final int INVERTED_OPPOSITE;
        private final int xOffset;
        private final int zOffset;

        private WallFacing(int bite, int oppositeBite, int inverted, int invertedOpposite, Direction enumFacing, int xOffset, int zOffset) {
            this.BYTE = bite;
            this.OPPOSITE = oppositeBite;
            this.INVERTED = inverted;
            this.INVERTED_OPPOSITE = invertedOpposite;
            this.xOffset = xOffset;
            this.zOffset = zOffset;
        }

        private boolean unpackAndTest(int directions) {
            return (this.BYTE & directions) == this.BYTE;
        }
    }
}

