/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trollcave;

import com.mojang.serialization.Codec;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.HugeRedMushroomFeature;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;
import twilightforest.util.features.FeatureLogic;

@ParametersAreNonnullByDefault
public class TrollHugeRedMushroomFeature
extends HugeRedMushroomFeature {
    public TrollHugeRedMushroomFeature(Codec<HugeMushroomFeatureConfiguration> config) {
        super(config);
    }

    protected void makeCap(LevelAccessor levelAccessor, RandomSource random, BlockPos pos, int height, BlockPos.MutableBlockPos mutableBlockPos, HugeMushroomFeatureConfiguration featureConfiguration) {
        for (int y = height - 3; y <= height; ++y) {
            int foliageRadius = y < height ? featureConfiguration.foliageRadius : featureConfiguration.foliageRadius - 1;
            int innerRadius = featureConfiguration.foliageRadius - 2;
            for (int x = -foliageRadius; x <= foliageRadius; ++x) {
                for (int z = -foliageRadius; z <= foliageRadius; ++z) {
                    if (y < height && !FeatureLogic.isEdge(x, z, foliageRadius)) continue;
                    mutableBlockPos.setWithOffset((Vec3i)pos, x, y, z);
                    if (levelAccessor.getBlockState((BlockPos)mutableBlockPos).is(BlockTags.FEATURES_CANNOT_REPLACE)) continue;
                    BlockState blockState = featureConfiguration.capProvider.getState(random, pos);
                    if (FeatureLogic.hasAllMushroomsProperties(blockState)) {
                        blockState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)blockState.setValue((Property)HugeMushroomBlock.UP, (Comparable)Boolean.valueOf(y >= height - 1))).setValue((Property)HugeMushroomBlock.WEST, (Comparable)Boolean.valueOf(x < -innerRadius))).setValue((Property)HugeMushroomBlock.EAST, (Comparable)Boolean.valueOf(x > innerRadius))).setValue((Property)HugeMushroomBlock.NORTH, (Comparable)Boolean.valueOf(z < -innerRadius))).setValue((Property)HugeMushroomBlock.SOUTH, (Comparable)Boolean.valueOf(z > innerRadius));
                    }
                    this.setBlock((LevelWriter)levelAccessor, (BlockPos)mutableBlockPos, blockState);
                }
            }
        }
    }
}

