/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class SnowUnderTreeFeature
extends Feature<NoneFeatureConfiguration> {
    public SnowUnderTreeFeature(Codec<NoneFeatureConfiguration> config) {
        super(config);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        BlockPos pos = ctx.origin();
        WorldGenLevel world = ctx.level();
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos mPosDown = new BlockPos.MutableBlockPos();
        for (int xi = 0; xi < 16; ++xi) {
            for (int zi = 0; zi < 16; ++zi) {
                int x = pos.getX() + xi;
                int z = pos.getZ() + zi;
                mPos.set(x, world.getHeight(Heightmap.Types.MOTION_BLOCKING, x, z) - 1, z);
                if (!(world.getBlockState((BlockPos)mPos).getBlock() instanceof LeavesBlock)) continue;
                mPos.set(x, world.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z), z);
                BlockState state = world.getBlockState((BlockPos)mPos);
                if (!state.isAir()) continue;
                mPosDown.set((Vec3i)mPos).move(Direction.DOWN);
                BlockState stateBelow = world.getBlockState((BlockPos)mPosDown);
                if (!stateBelow.isFaceSturdy((BlockGetter)world, (BlockPos)mPosDown, Direction.UP)) continue;
                world.setBlock((BlockPos)mPos, Blocks.SNOW.defaultBlockState(), 2);
                if (!stateBelow.hasProperty((Property)SnowyDirtBlock.SNOWY)) continue;
                world.setBlock((BlockPos)mPosDown, (BlockState)stateBelow.setValue((Property)SnowyDirtBlock.SNOWY, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
        return true;
    }
}

