/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.BlockFamilies;
import net.minecraft.data.BlockFamily;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.util.valueproviders.WeightedListInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.storage.loot.LootTable;
import twilightforest.data.TFBlockFamilies;
import twilightforest.loot.TFLootTables;

public record RuinedFoundationConfig(RuinedFoundationDimensions dimensions, RuinedFoundationBlocks blocks, ResourceKey<LootTable> lootTable) implements FeatureConfiguration
{
    public static final Codec<RuinedFoundationConfig> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)RuinedFoundationDimensions.CODEC.forGetter(RuinedFoundationConfig::dimensions), (App)RuinedFoundationBlocks.CODEC.forGetter(RuinedFoundationConfig::blocks), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("loot_table").forGetter(RuinedFoundationConfig::lootTable)).apply((Applicative)inst, RuinedFoundationConfig::new));

    public static RuinedFoundationConfig withDefaultBlocks(boolean floorWaterlogged) {
        RuinedFoundationBlocks foundationBlocks = RuinedFoundationBlocks.blocksFromFamilies(floorWaterlogged, BlockFamilies.OAK_PLANKS, BlockFamilies.COBBLESTONE, BlockFamilies.MOSSY_COBBLESTONE, (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.CHEST));
        return new RuinedFoundationConfig(RuinedFoundationDimensions.makeDefault(), foundationBlocks, TFLootTables.FOUNDATION_BASEMENT);
    }

    public record RuinedFoundationDimensions(IntProvider wallWidth, IntProvider wallHeights, IntProvider basementHeight, FloatProvider placeFloorTest) {
        public static final MapCodec<RuinedFoundationDimensions> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)IntProvider.codec((int)1, (int)16).fieldOf("wall_width").forGetter(RuinedFoundationDimensions::wallWidth), (App)IntProvider.codec((int)1, (int)32).fieldOf("wall_heights").forGetter(RuinedFoundationDimensions::wallHeights), (App)IntProvider.codec((int)0, (int)16).fieldOf("basement_height").forGetter(RuinedFoundationDimensions::basementHeight), (App)FloatProvider.codec((float)-8.0f, (float)8.0f).fieldOf("random_floor_chance").forGetter(RuinedFoundationDimensions::placeFloorTest)).apply((Applicative)inst, RuinedFoundationDimensions::new));

        public static RuinedFoundationDimensions makeDefault() {
            WeightedListInt basementHeights = new WeightedListInt(SimpleWeightedRandomList.builder().add((Object)ConstantInt.of((int)3), 1).add((Object)ConstantInt.of((int)0), 1).build());
            return new RuinedFoundationDimensions((IntProvider)UniformInt.of((int)5, (int)9), (IntProvider)UniformInt.of((int)1, (int)5), (IntProvider)basementHeights, (FloatProvider)UniformFloat.of((float)-2.0f, (float)1.0f));
        }
    }

    public record RuinedFoundationBlocks(BlockStateProvider floor, BlockStateProvider basementPosts, BlockStateProvider lootContainer, BlockStateProvider wallBlock, BlockStateProvider wallTop, BlockStateProvider decayedWall, BlockStateProvider decayedTop) {
        public static final MapCodec<RuinedFoundationBlocks> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)BlockStateProvider.CODEC.fieldOf("floor").forGetter(RuinedFoundationBlocks::floor), (App)BlockStateProvider.CODEC.fieldOf("basement_posts").forGetter(RuinedFoundationBlocks::basementPosts), (App)BlockStateProvider.CODEC.fieldOf("loot_container").forGetter(RuinedFoundationBlocks::lootContainer), (App)BlockStateProvider.CODEC.fieldOf("wall_block").forGetter(RuinedFoundationBlocks::wallBlock), (App)BlockStateProvider.CODEC.fieldOf("wall_top_block").forGetter(RuinedFoundationBlocks::wallTop), (App)BlockStateProvider.CODEC.fieldOf("decayed_wall_block").forGetter(RuinedFoundationBlocks::decayedWall), (App)BlockStateProvider.CODEC.fieldOf("decayed_wall_top_block").forGetter(RuinedFoundationBlocks::decayedTop)).apply((Applicative)inst, RuinedFoundationBlocks::new));

        public static RuinedFoundationBlocks blocksFromFamilies(boolean floorWaterlogged, BlockFamily floorMaterial, BlockFamily wallMaterial, BlockFamily decayedMaterial, BlockStateProvider chestBlockProvider) {
            boolean doFence = floorMaterial.get(BlockFamily.Variant.FENCE) != null;
            BlockFamily.Variant basementSupports = doFence ? BlockFamily.Variant.FENCE : BlockFamily.Variant.WALL;
            TFBlockFamilies.verifyFamilyShapes(floorMaterial, BlockFamily.Variant.SLAB, BlockFamily.Variant.STAIRS, basementSupports);
            TFBlockFamilies.verifyFamilyShapes(wallMaterial, BlockFamily.Variant.SLAB, BlockFamily.Variant.STAIRS);
            TFBlockFamilies.verifyFamilyShapes(decayedMaterial, BlockFamily.Variant.SLAB, BlockFamily.Variant.STAIRS);
            BlockState floorStairs = floorMaterial.get(BlockFamily.Variant.STAIRS).defaultBlockState();
            BlockState wallBlock = wallMaterial.getBaseBlock().defaultBlockState();
            BlockState wallStairs = wallMaterial.get(BlockFamily.Variant.STAIRS).defaultBlockState();
            BlockState decayedWall = decayedMaterial.getBaseBlock().defaultBlockState();
            BlockState decayedStairs = decayedMaterial.get(BlockFamily.Variant.STAIRS).defaultBlockState();
            WeightedStateProvider floor = new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)floorMaterial.getBaseBlock().defaultBlockState(), 39).add((Object)((BlockState)floorMaterial.get(BlockFamily.Variant.SLAB).defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(floorWaterlogged))), 1).add((Object)((BlockState)((BlockState)floorStairs.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(floorWaterlogged))), 6).add((Object)((BlockState)((BlockState)floorStairs.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(floorWaterlogged))), 2).add((Object)((BlockState)((BlockState)floorStairs.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.SOUTH)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(floorWaterlogged))), 6).add((Object)((BlockState)((BlockState)floorStairs.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(floorWaterlogged))), 2).build());
            WeightedStateProvider wallTop = new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)wallBlock, 5).add((Object)wallMaterial.get(BlockFamily.Variant.SLAB).defaultBlockState(), 1).add((Object)((BlockState)wallStairs.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)), 2).add((Object)((BlockState)wallStairs.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)), 2).build());
            WeightedStateProvider decayedTop = new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)decayedWall, 5).add((Object)decayedMaterial.get(BlockFamily.Variant.SLAB).defaultBlockState(), 1).add((Object)((BlockState)decayedStairs.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.EAST)), 2).add((Object)((BlockState)decayedStairs.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.WEST)), 2).build());
            return new RuinedFoundationBlocks((BlockStateProvider)floor, (BlockStateProvider)BlockStateProvider.simple((BlockState)floorMaterial.get(basementSupports).defaultBlockState()), chestBlockProvider, (BlockStateProvider)BlockStateProvider.simple((BlockState)wallBlock), (BlockStateProvider)wallTop, (BlockStateProvider)BlockStateProvider.simple((BlockState)decayedWall), (BlockStateProvider)decayedTop);
        }
    }
}

