/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class DarkForestFeature
extends Feature<RandomPatchConfiguration> {
    public DarkForestFeature(Codec<RandomPatchConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<RandomPatchConfiguration> ctx) {
        WorldGenLevel reader = ctx.level();
        BlockPos pos = ctx.origin();
        RandomSource rand = ctx.random();
        RandomPatchConfiguration config = (RandomPatchConfiguration)ctx.config();
        boolean foundDirt = false;
        if (pos.getY() <= 40) {
            int seaLevel = ctx.chunkGenerator().getSeaLevel();
            for (int dy = pos.getY(); dy >= seaLevel; --dy) {
                BlockState state = reader.getBlockState(new BlockPos(pos.getX(), dy - 1, pos.getZ()));
                if (state.is(BlockTags.DIRT) && reader.getBlockState(pos).canBeReplaced()) {
                    foundDirt = true;
                    pos = new BlockPos(pos.getX(), dy, pos.getZ());
                    break;
                }
                if (state.is(BlockTags.BASE_STONE_OVERWORLD) || state.is(BlockTags.SAND)) break;
            }
        }
        if (!foundDirt) {
            return false;
        }
        int i = 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int j = config.xzSpread() + 1;
        int k = config.ySpread() + 1;
        for (int l = 0; l < config.tries(); ++l) {
            blockpos$mutableblockpos.setWithOffset((Vec3i)pos, rand.nextInt(j) - rand.nextInt(j), rand.nextInt(k) - rand.nextInt(k), rand.nextInt(j) - rand.nextInt(j));
            if (!((PlacedFeature)config.feature().value()).place(reader, ctx.chunkGenerator(), rand, (BlockPos)blockpos$mutableblockpos)) continue;
            ++i;
        }
        return i > 0;
    }
}

