/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;
import twilightforest.init.TFDataMaps;
import twilightforest.init.TFItems;
import twilightforest.item.mapdata.TFMazeMapData;
import twilightforest.util.datamaps.OreMapOreColor;

public class MazeMapItem
extends MapItem {
    public static final String STR_ID = "mazemap";
    private static final int YSEARCH = 3;
    protected final boolean mapOres;

    public MazeMapItem(boolean mapOres, Item.Properties properties) {
        super(properties);
        this.mapOres = mapOres;
    }

    public static ItemStack setupNewMap(Level level, int worldX, int worldZ, byte scale, boolean trackingPosition, boolean unlimitedTracking, int worldY, boolean mapOres) {
        ItemStack itemstack = new ItemStack(mapOres ? (ItemLike)TFItems.FILLED_ORE_MAP.get() : (ItemLike)TFItems.FILLED_MAZE_MAP.get());
        MazeMapItem.createMapData(itemstack, level, worldX, worldZ, scale, trackingPosition, unlimitedTracking, (ResourceKey<Level>)level.dimension(), worldY, mapOres);
        return itemstack;
    }

    @Nullable
    public static TFMazeMapData getData(ItemStack stack, Level level) {
        MapId id = (MapId)stack.get(DataComponents.MAP_ID);
        return id == null ? null : TFMazeMapData.getMazeMapData(level, MazeMapItem.getMapName(id.id()));
    }

    @Nullable
    protected TFMazeMapData getCustomMapData(ItemStack stack, Level level) {
        TFMazeMapData mapdata = MazeMapItem.getData(stack, level);
        if (mapdata == null && !level.isClientSide()) {
            BlockPos pos = level.getSharedSpawnPos();
            mapdata = MazeMapItem.createMapData(stack, level, pos.getX(), pos.getZ(), 0, false, false, (ResourceKey<Level>)level.dimension(), pos.getY(), this.mapOres);
        }
        return mapdata;
    }

    private static TFMazeMapData createMapData(ItemStack stack, Level level, int x, int z, int scale, boolean trackingPosition, boolean unlimitedTracking, ResourceKey<Level> dimension, int y, boolean ore) {
        MapId i = level.getFreeMapId();
        int mapSize = 128 * (1 << scale);
        int roundX = Mth.floor((double)(((double)x + 64.0) / (double)mapSize));
        int roundZ = Mth.floor((double)(((double)z + 64.0) / (double)mapSize));
        int scaledX = roundX * mapSize + mapSize / 2 - 64;
        int scaledZ = roundZ * mapSize + mapSize / 2 - 64;
        TFMazeMapData mapdata = new TFMazeMapData(scaledX, scaledZ, (byte)scale, trackingPosition, unlimitedTracking, false, dimension);
        mapdata.calculateMapCenter(level, x, y, z);
        mapdata.ore = ore;
        TFMazeMapData.registerMazeMapData(level, mapdata, MazeMapItem.getMapName(i.id()));
        stack.set(DataComponents.MAP_ID, (Object)i);
        return mapdata;
    }

    public static String getMapName(int id) {
        return "mazemap_" + id;
    }

    public void update(Level level, Entity viewer, MapItemSavedData data) {
        if (level.dimension() == data.dimension && viewer instanceof Player) {
            int blocksPerPixel = 1 << data.scale;
            int centerX = data.centerX;
            int centerZ = data.centerZ;
            int viewerX = Mth.floor((double)(viewer.getX() - (double)centerX)) / blocksPerPixel + 64;
            int viewerZ = Mth.floor((double)(viewer.getZ() - (double)centerZ)) / blocksPerPixel + 64;
            int viewRadiusPixels = 16;
            if (level.dimensionType().hasCeiling()) {
                viewRadiusPixels /= 2;
            }
            MapItemSavedData.HoldingPlayer mapdata$mapinfo = data.getHoldingPlayer((Player)viewer);
            ++mapdata$mapinfo.step;
            boolean flag = false;
            for (int xPixel = viewerX - viewRadiusPixels + 1; xPixel < viewerX + viewRadiusPixels; ++xPixel) {
                if ((xPixel & 0xF) != (mapdata$mapinfo.step & 0xF) && !flag) continue;
                flag = false;
                for (int zPixel = viewerZ - viewRadiusPixels - 1; zPixel < viewerZ + viewRadiusPixels; ++zPixel) {
                    byte b1;
                    byte b0;
                    if (xPixel < 0 || zPixel < -1 || xPixel >= 128 || zPixel >= 128) continue;
                    int xPixelDist = xPixel - viewerX;
                    int zPixelDist = zPixel - viewerZ;
                    boolean shouldFuzz = xPixelDist * xPixelDist + zPixelDist * zPixelDist > (viewRadiusPixels - 2) * (viewRadiusPixels - 2);
                    int worldX = (centerX / blocksPerPixel + xPixel - 64) * blocksPerPixel;
                    int worldZ = (centerZ / blocksPerPixel + zPixel - 64) * blocksPerPixel;
                    HashMultiset multiset = HashMultiset.create();
                    LevelChunk chunk = level.getChunkAt(new BlockPos(worldX, 0, worldZ));
                    int brightness = 1;
                    if (chunk.isEmpty()) continue;
                    int worldXRounded = worldX & 0xF;
                    int worldZRounded = worldZ & 0xF;
                    if (level.dimensionType().hasCeiling()) {
                        int l3 = worldX + worldZ * 231871;
                        if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                            multiset.add((Object)MapColor.DIRT, 10);
                        } else {
                            multiset.add((Object)MapColor.STONE, 100);
                        }
                    } else {
                        int yCenter = ((TFMazeMapData)data).yCenter;
                        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(worldXRounded, yCenter, worldZRounded);
                        BlockState state = chunk.getBlockState((BlockPos)blockpos$mutableblockpos);
                        multiset.add((Object)state.getMapColor((BlockGetter)level, (BlockPos)blockpos$mutableblockpos));
                        if (state.is(Blocks.STONE) || state.isAir()) {
                            for (int i = -3; i <= 3; ++i) {
                                blockpos$mutableblockpos.setY(yCenter + i);
                                BlockState searchID = chunk.getBlockState((BlockPos)blockpos$mutableblockpos);
                                if (!searchID.is(Blocks.STONE) || searchID.isAir()) continue;
                                state = searchID;
                                if (i > 0) {
                                    brightness = 2;
                                }
                                if (i >= 0) break;
                                brightness = 0;
                                break;
                            }
                        }
                        if (this.mapOres) {
                            OreMapOreColor color = (OreMapOreColor)state.getBlock().builtInRegistryHolder().getData(TFDataMaps.ORE_MAP_ORE_COLOR);
                            if (color != null) {
                                multiset.add((Object)color.color(), 1000);
                            } else if (!state.isAir() && state.is(Tags.Blocks.ORES)) {
                                multiset.add((Object)MapColor.COLOR_PINK, 1000);
                            }
                        }
                    }
                    MapColor mapcolor = (MapColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)MapColor.NONE);
                    if (zPixel < 0 || xPixelDist * xPixelDist + zPixelDist * zPixelDist >= viewRadiusPixels * viewRadiusPixels || shouldFuzz && (xPixel + zPixel & 1) == 0 || (b0 = data.colors[xPixel + zPixel * 128]) == (b1 = (byte)(mapcolor.id * 4 + brightness))) continue;
                    data.setColor(xPixel, zPixel, b1);
                    data.setDirty();
                    flag = true;
                }
            }
        }
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        TFMazeMapData mapdata;
        if (!level.isClientSide() && (mapdata = this.getCustomMapData(stack, level)) != null) {
            Player player;
            if (entity instanceof Player) {
                MapDecoration decoration;
                Player entityplayer = (Player)entity;
                mapdata.tickCarriedBy(entityplayer, stack);
                int yProximity = Mth.floor((double)(entityplayer.getY() - (double)mapdata.yCenter));
                if ((yProximity < -3 || yProximity > 3) && (decoration = (MapDecoration)mapdata.decorations.get(entityplayer.getName().getString())) != null) {
                    mapdata.decorations.put(entityplayer.getName().getString(), new MapDecoration(MapDecorationTypes.PLAYER_OFF_MAP, decoration.x(), decoration.y(), decoration.rot(), Optional.empty()));
                }
            }
            if (!mapdata.locked && (isSelected || entity instanceof Player && (player = (Player)entity).getOffhandItem() == stack)) {
                this.update(level, entity, mapdata);
            }
        }
    }

    public void onCraftedBy(ItemStack stack, Level level, Player player) {
    }

    @Nullable
    public Packet<?> getUpdatePacket(ItemStack stack, Level level, Player player) {
        MapId mapId = (MapId)stack.get(DataComponents.MAP_ID);
        TFMazeMapData mapdata = this.getCustomMapData(stack, level);
        return mapId == null || mapdata == null ? null : mapdata.getUpdatePacket(mapId, player);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        MapId mapId = (MapId)stack.get(DataComponents.MAP_ID);
        if (mapId != null) {
            TFMazeMapData data = TFMazeMapData.getClientMagicMapData(MazeMapItem.getMapName(mapId.id()));
            if (flag.isAdvanced()) {
                if (data != null) {
                    tooltip.add((Component)Component.translatable((String)"item.twilightforest.maze_map.y_level", (Object[])new Object[]{data.yCenter}).withStyle(ChatFormatting.GRAY));
                    tooltip.add((Component)Component.translatable((String)"filled_map.id", (Object[])new Object[]{mapId.id()}).withStyle(ChatFormatting.GRAY));
                    tooltip.add((Component)Component.translatable((String)"filled_map.scale", (Object[])new Object[]{1 << data.scale}).withStyle(ChatFormatting.GRAY));
                    tooltip.add((Component)Component.translatable((String)"filled_map.level", (Object[])new Object[]{data.scale, 4}).withStyle(ChatFormatting.GRAY));
                } else {
                    tooltip.add((Component)Component.translatable((String)"filled_map.unknown").withStyle(ChatFormatting.GRAY));
                }
            } else {
                tooltip.add(MapItem.getTooltipForId((MapId)mapId));
            }
        }
    }
}

