/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init.custom;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import twilightforest.TFRegistries;
import twilightforest.TwilightForestMod;
import twilightforest.client.MagicPaintingTextureManager;
import twilightforest.data.AtlasGenerator;
import twilightforest.data.LangGenerator;
import twilightforest.entity.MagicPaintingVariant;

public class MagicPaintingVariants {
    public static final Codec<Holder<MagicPaintingVariant>> CODEC = RegistryFileCodec.create(TFRegistries.Keys.MAGIC_PAINTINGS, MagicPaintingVariant.CODEC, (boolean)false);
    public static final StreamCodec<? super RegistryFriendlyByteBuf, Holder<MagicPaintingVariant>> STREAM_CODEC = ByteBufCodecs.holderRegistry(TFRegistries.Keys.MAGIC_PAINTINGS);
    public static final ResourceKey<MagicPaintingVariant> DARKNESS = MagicPaintingVariants.makeKey(TwilightForestMod.prefix("darkness"));
    public static final ResourceKey<MagicPaintingVariant> LUCID_LANDS = MagicPaintingVariants.makeKey(TwilightForestMod.prefix("lucid_lands"));
    public static final ResourceKey<MagicPaintingVariant> THE_HOSTILE_PARADISE = MagicPaintingVariants.makeKey(TwilightForestMod.prefix("the_hostile_paradise"));
    public static final ResourceKey<MagicPaintingVariant> CASTAWAY_PARADISE = MagicPaintingVariants.makeKey(TwilightForestMod.prefix("castaway_paradise"));
    public static final ResourceKey<MagicPaintingVariant> MUSIC_IN_THE_MIRE = MagicPaintingVariants.makeKey(TwilightForestMod.prefix("music_in_the_mire"));
    public static final ResourceKey<MagicPaintingVariant> DEFAULT = LUCID_LANDS;

    private static ResourceKey<MagicPaintingVariant> makeKey(ResourceLocation name) {
        return ResourceKey.create(TFRegistries.Keys.MAGIC_PAINTINGS, (ResourceLocation)name);
    }

    public static void bootstrap(BootstrapContext<MagicPaintingVariant> context) {
        MagicPaintingVariants.register(context, DARKNESS, "Darkness", "???", 4, 2, MagicPaintingTextureManager.BACK_SPRITE_LOCATION, List.of(new MagicPaintingVariant.Layer("background", null, null, true, true), new MagicPaintingVariant.Layer("sky", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.VIEW_ANGLE, 0.01f, 128, 32), new MagicPaintingVariant.Layer.OpacityModifier(MagicPaintingVariant.Layer.OpacityModifier.Type.SINE_TIME, 0.03f, false, 0.0f, 1.0f), true, true), new MagicPaintingVariant.Layer("terrain", null, null, false, true), new MagicPaintingVariant.Layer("gems", null, null, true, true), new MagicPaintingVariant.Layer("gems", null, new MagicPaintingVariant.Layer.OpacityModifier(MagicPaintingVariant.Layer.OpacityModifier.Type.DAY_TIME, 2.0f, true, 0.0f, 1.0f, 1.0f, 23999.0f), true, true), new MagicPaintingVariant.Layer("lightning", null, new MagicPaintingVariant.Layer.OpacityModifier(MagicPaintingVariant.Layer.OpacityModifier.Type.LIGHTNING, 1.0f, false, 0.0f, 1.0f), true, true), new MagicPaintingVariant.Layer("frame", null, null, false, false)));
        MagicPaintingVariants.register(context, LUCID_LANDS, "Lucid Lands", "Androsa", 3, 3, MagicPaintingTextureManager.BACK_SPRITE_LOCATION, List.of(new MagicPaintingVariant.Layer("background", null, null, true, true), new MagicPaintingVariant.Layer("clouds", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.LINEAR_TIME, 7.5E-4f, 122, 48), null, true, true), new MagicPaintingVariant.Layer("mookaite_mesa", null, null, true, true), new MagicPaintingVariant.Layer("agate_jungle", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.VIEW_ANGLE, 0.005f, 58, 48), null, true, true), new MagicPaintingVariant.Layer("crystal_plains", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.VIEW_ANGLE, 0.006f, 74, 48), null, true, true), new MagicPaintingVariant.Layer("background_gold", null, new MagicPaintingVariant.Layer.OpacityModifier(MagicPaintingVariant.Layer.OpacityModifier.Type.HOLDING_ITEM, 0.01f, false, 0.0f, 1.0f, new ItemStack((ItemLike)Items.GOLD_INGOT)), true, true), new MagicPaintingVariant.Layer("clouds_gold", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.LINEAR_TIME, 7.5E-4f, 122, 48), new MagicPaintingVariant.Layer.OpacityModifier(MagicPaintingVariant.Layer.OpacityModifier.Type.HOLDING_ITEM, 0.01f, false, 0.0f, 1.0f, new ItemStack((ItemLike)Items.GOLD_INGOT)), true, true), new MagicPaintingVariant.Layer("golden_hills", null, new MagicPaintingVariant.Layer.OpacityModifier(MagicPaintingVariant.Layer.OpacityModifier.Type.HOLDING_ITEM, 0.01f, false, 0.0f, 1.0f, new ItemStack((ItemLike)Items.GOLD_INGOT)), true, true), new MagicPaintingVariant.Layer("golden_forest", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.VIEW_ANGLE, 0.005f, 58, 48), new MagicPaintingVariant.Layer.OpacityModifier(MagicPaintingVariant.Layer.OpacityModifier.Type.HOLDING_ITEM, 0.01f, false, 0.0f, 1.0f, new ItemStack((ItemLike)Items.GOLD_INGOT)), true, true), new MagicPaintingVariant.Layer("golden_sands", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.VIEW_ANGLE, 0.006f, 74, 48), new MagicPaintingVariant.Layer.OpacityModifier(MagicPaintingVariant.Layer.OpacityModifier.Type.HOLDING_ITEM, 0.01f, false, 0.0f, 1.0f, new ItemStack((ItemLike)Items.GOLD_INGOT)), true, true), new MagicPaintingVariant.Layer("background_corrupt", null, new MagicPaintingVariant.Layer.OpacityModifier(MagicPaintingVariant.Layer.OpacityModifier.Type.MOB_EFFECT_CATEGORY, 0.01f, false, 0.0f, 1.0f, MobEffectCategory.HARMFUL), true, true), new MagicPaintingVariant.Layer("clouds_corrupt", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.LINEAR_TIME, 7.5E-4f, 122, 48), new MagicPaintingVariant.Layer.OpacityModifier(MagicPaintingVariant.Layer.OpacityModifier.Type.MOB_EFFECT_CATEGORY, 0.01f, false, 0.0f, 1.0f, MobEffectCategory.HARMFUL), false, true), new MagicPaintingVariant.Layer("goldstone_peaks", null, new MagicPaintingVariant.Layer.OpacityModifier(MagicPaintingVariant.Layer.OpacityModifier.Type.MOB_EFFECT_CATEGORY, 0.01f, false, 0.0f, 1.0f, MobEffectCategory.HARMFUL), false, true), new MagicPaintingVariant.Layer("goldstone_peaks_overlay", null, new MagicPaintingVariant.Layer.OpacityModifier(MagicPaintingVariant.Layer.OpacityModifier.Type.MOB_EFFECT_CATEGORY, 0.01f, false, 0.0f, 1.0f, MobEffectCategory.HARMFUL), true, true), new MagicPaintingVariant.Layer("goldstone_forest", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.VIEW_ANGLE, 0.005f, 58, 48), new MagicPaintingVariant.Layer.OpacityModifier(MagicPaintingVariant.Layer.OpacityModifier.Type.MOB_EFFECT_CATEGORY, 0.01f, false, 0.0f, 1.0f, MobEffectCategory.HARMFUL), false, true), new MagicPaintingVariant.Layer("goldstone_plains", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.VIEW_ANGLE, 0.006f, 74, 48), new MagicPaintingVariant.Layer.OpacityModifier(MagicPaintingVariant.Layer.OpacityModifier.Type.MOB_EFFECT_CATEGORY, 0.01f, false, 0.0f, 1.0f, MobEffectCategory.HARMFUL), false, true), new MagicPaintingVariant.Layer("frame", null, null, false, false)));
        MagicPaintingVariants.register(context, THE_HOSTILE_PARADISE, "The Hostile Paradise", "Oz", 3, 2, MagicPaintingTextureManager.BACK_SPRITE_LOCATION, List.of(new MagicPaintingVariant.Layer("1_background", null, null, true, true), new MagicPaintingVariant.Layer("2_distant_islands_par", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.VIEW_ANGLE, 0.02f, 86, 38), null, true, true), new MagicPaintingVariant.Layer("3_gold_dungeon_par", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.VIEW_ANGLE, 0.02f, 78, 36), null, true, true), new MagicPaintingVariant.Layer("4_fog_1_opa", null, new MagicPaintingVariant.Layer.OpacityModifier(MagicPaintingVariant.Layer.OpacityModifier.Type.DISTANCE, 1.0f, false, 0.0f, 1.0f, 4.0f, 12.0f), true, true), new MagicPaintingVariant.Layer("5_silver_dungeon_par", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.VIEW_ANGLE, 0.02f, 70, 36), null, true, true), new MagicPaintingVariant.Layer("6_fog_2_opa", null, new MagicPaintingVariant.Layer.OpacityModifier(MagicPaintingVariant.Layer.OpacityModifier.Type.DISTANCE, 1.0f, false, 0.0f, 1.0f, 5.0f, 15.0f), true, true), new MagicPaintingVariant.Layer("7_portal_par", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.VIEW_ANGLE, 0.02f, 62, 34), null, true, true), new MagicPaintingVariant.Layer("8_fog_3_opa", null, new MagicPaintingVariant.Layer.OpacityModifier(MagicPaintingVariant.Layer.OpacityModifier.Type.DISTANCE, 1.0f, false, 0.0f, 1.0f, 6.0f, 18.0f), true, true), new MagicPaintingVariant.Layer("9_field_par", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.VIEW_ANGLE, 0.02f, 54, 34), null, true, true), new MagicPaintingVariant.Layer("10_flowers_par", null, null, true, true), new MagicPaintingVariant.Layer("11_fog_4_opa", null, new MagicPaintingVariant.Layer.OpacityModifier(MagicPaintingVariant.Layer.OpacityModifier.Type.DISTANCE, 1.0f, false, 0.0f, 1.0f, 12.0f, 24.0f), true, true), new MagicPaintingVariant.Layer("12_clouds_par", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.VIEW_ANGLE, 0.02f, 58, 32), new MagicPaintingVariant.Layer.OpacityModifier(MagicPaintingVariant.Layer.OpacityModifier.Type.DISTANCE, 1.0f, false, 0.0f, 1.0f, 12.0f, 24.0f), true, true), new MagicPaintingVariant.Layer("13_frame", null, null, false, false)));
        MagicPaintingVariants.register(context, CASTAWAY_PARADISE, "Castaway Paradise", "HexaBlu", 2, 4, MagicPaintingTextureManager.BACK_SPRITE_LOCATION, List.of(new MagicPaintingVariant.Layer("sunset", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.VIEW_ANGLE, 0.01f, 64, 64), null, true, true), new MagicPaintingVariant.Layer("sun", null, null, true, true), new MagicPaintingVariant.Layer("faraway_palm", null, null, false, true), new MagicPaintingVariant.Layer("ocean", null, null, false, true), new MagicPaintingVariant.Layer("deckchair", null, null, false, true), new MagicPaintingVariant.Layer("palm_tree", null, null, false, true), new MagicPaintingVariant.Layer("frame", null, null, false, false)));
        MagicPaintingVariants.register(context, MUSIC_IN_THE_MIRE, "Music in the Mire", "TripleHeadedSheep", 4, 3, MagicPaintingTextureManager.BACK_SPRITE_LOCATION, List.of(new MagicPaintingVariant.Layer("bl_sky", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.VIEW_ANGLE, 0.015f, 88, 56), null, false, true), new MagicPaintingVariant.Layer("bl_roots", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.VIEW_ANGLE, 0.015f, 84, 52), null, true, true), new MagicPaintingVariant.Layer("bl_lightning", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.VIEW_ANGLE, 0.015f, 78, 52), new MagicPaintingVariant.Layer.OpacityModifier(MagicPaintingVariant.Layer.OpacityModifier.Type.LIGHTNING, 1.0f, false, 0.0f, 1.0f), false, true), new MagicPaintingVariant.Layer("bl_mid", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.VIEW_ANGLE, 0.015f, 76, 52), null, false, true), new MagicPaintingVariant.Layer("bl_mid_lightning", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.VIEW_ANGLE, 0.015f, 76, 52), new MagicPaintingVariant.Layer.OpacityModifier(MagicPaintingVariant.Layer.OpacityModifier.Type.LIGHTNING, 0.2f, false, 0.0f, 1.0f), false, true), new MagicPaintingVariant.Layer("bl_fog", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.VIEW_ANGLE, 0.015f, 76, 52), new MagicPaintingVariant.Layer.OpacityModifier(MagicPaintingVariant.Layer.OpacityModifier.Type.DAY_TIME, 0.25f, false, 0.0f, 1.0f, 22331.0f, 2000.0f), false, true), new MagicPaintingVariant.Layer("bl_foreground", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.VIEW_ANGLE, 0.015f, 74, 48), null, false, true), new MagicPaintingVariant.Layer("bl_foreground_lightning", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.VIEW_ANGLE, 0.015f, 74, 48), new MagicPaintingVariant.Layer.OpacityModifier(MagicPaintingVariant.Layer.OpacityModifier.Type.LIGHTNING, 0.16666667f, false, 0.0f, 1.0f), false, true), new MagicPaintingVariant.Layer("bl_greeblings", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.VIEW_ANGLE, 0.015f, 74, 48), null, false, true), new MagicPaintingVariant.Layer("bl_greeblings_lightning", new MagicPaintingVariant.Layer.Parallax(MagicPaintingVariant.Layer.Parallax.Type.VIEW_ANGLE, 0.015f, 74, 48), new MagicPaintingVariant.Layer.OpacityModifier(MagicPaintingVariant.Layer.OpacityModifier.Type.LIGHTNING, 0.14285715f, false, 0.0f, 1.0f), false, true), new MagicPaintingVariant.Layer("bl_frame", null, null, false, false)));
    }

    private static void register(BootstrapContext<MagicPaintingVariant> context, ResourceKey<MagicPaintingVariant> key, String title, String author, int width, int height, ResourceLocation backSprite, List<MagicPaintingVariant.Layer> layers) {
        MutableComponent authorComponent = Component.translatable((String)key.location().toLanguageKey("magic_painting", "author"));
        MagicPaintingVariant variant = new MagicPaintingVariant(width * 16, height * 16, layers, (Component)authorComponent, backSprite);
        AtlasGenerator.MAGIC_PAINTING_HELPER.put(key.location(), variant);
        LangGenerator.MAGIC_PAINTING_HELPER.put(key.location(), (Pair<String, String>)Pair.of((Object)title, (Object)author));
        context.register(key, (Object)variant);
    }
}

