/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import twilightforest.entity.ai.goal.HoverBaseGoal;
import twilightforest.entity.boss.SnowQueen;

public class HoverThenDropGoal
extends HoverBaseGoal<SnowQueen> {
    private int hoverTimer;
    private int dropTimer;
    private int seekTimer;
    private final int maxHoverTime;
    private final int maxDropTime;
    private final int maxSeekTime;
    private double dropY;

    public HoverThenDropGoal(SnowQueen snowQueen, int hoverTime, int dropTime) {
        super(snowQueen, 6.0f, 0.0f);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.maxHoverTime = hoverTime;
        this.maxSeekTime = hoverTime;
        this.maxDropTime = dropTime;
        this.hoverTimer = 0;
    }

    public boolean canUse() {
        LivingEntity target = ((SnowQueen)this.attacker).getTarget();
        if (target == null) {
            return false;
        }
        if (!target.isAlive()) {
            return false;
        }
        return ((SnowQueen)this.attacker).getCurrentPhase() == SnowQueen.Phase.DROP;
    }

    public boolean canContinueToUse() {
        LivingEntity target = ((SnowQueen)this.attacker).getTarget();
        if (target == null || !target.isAlive()) {
            return false;
        }
        if (((SnowQueen)this.attacker).getCurrentPhase() != SnowQueen.Phase.DROP) {
            return false;
        }
        if (this.seekTimer > this.maxSeekTime) {
            return false;
        }
        if (((SnowQueen)this.attacker).distanceToSqr(this.hoverPosX, this.hoverPosY, this.hoverPosZ) <= 1.0) {
            ++this.hoverTimer;
            return true;
        }
        if (this.dropTimer < this.maxDropTime) {
            return true;
        }
        ((SnowQueen)this.attacker).incrementSuccessfulDrops();
        return false;
    }

    public void stop() {
        this.hoverTimer = 0;
        this.dropTimer = 0;
    }

    public void tick() {
        if (this.hoverTimer > 0) {
            ++this.hoverTimer;
        } else {
            ++this.seekTimer;
        }
        if (this.hoverTimer < this.maxHoverTime) {
            double offsetX = this.hoverPosX - ((SnowQueen)this.attacker).getX();
            double offsetY = this.hoverPosY - ((SnowQueen)this.attacker).getY();
            double offsetZ = this.hoverPosZ - ((SnowQueen)this.attacker).getZ();
            double distanceDesired = offsetX * offsetX + offsetY * offsetY + offsetZ * offsetZ;
            distanceDesired = Mth.sqrt((float)((float)distanceDesired));
            double velX = offsetX / distanceDesired * 0.05;
            double velY = offsetY / distanceDesired * 0.1;
            double velZ = offsetZ / distanceDesired * 0.05;
            ((SnowQueen)this.attacker).push(velX, velY += 0.05, velZ);
            LivingEntity target = ((SnowQueen)this.attacker).getTarget();
            if (target != null) {
                ((SnowQueen)this.attacker).lookAt((Entity)target, 30.0f, 30.0f);
                ((SnowQueen)this.attacker).getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
            }
        } else {
            ++this.dropTimer;
            if (((SnowQueen)this.attacker).getY() > this.dropY) {
                ((SnowQueen)this.attacker).destroyBlocksInAABB(((SnowQueen)this.attacker).getBoundingBox().inflate(1.0, 0.5, 1.0));
            }
        }
    }

    @Override
    protected void makeNewHoverSpot(LivingEntity target) {
        super.makeNewHoverSpot(target);
        this.dropY = target.getY() - 1.0;
        this.seekTimer = 0;
    }
}

