/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import twilightforest.client.particle.data.LeafParticleData;

public class LeafParticle
extends TextureSheetParticle {
    private final Vec3 target;
    private float rot;

    public LeafParticle(ClientLevel world, double x, double y, double z, double vx, double vy, double vz) {
        this(world, x, y, z, vx, vy, vz, 1.0f);
    }

    public LeafParticle(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, float scale) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.target = new Vec3(x, y, z);
        this.xd *= 0.1;
        this.yd *= 0.1;
        this.zd *= 0.1;
        this.xd += vx * 0.4;
        this.yd += vy * 0.4;
        this.zd += vz * 0.4;
        this.bCol = 1.0f;
        this.gCol = 1.0f;
        this.rCol = 1.0f;
        this.alpha = 0.0f;
        this.quadSize *= 0.75f * (this.random.nextBoolean() ? -1.0f : 1.0f);
        this.quadSize *= scale;
        this.lifetime = 160 + (int)(this.random.nextFloat() * 30.0f);
        this.lifetime = (int)((float)this.lifetime * scale);
        this.hasPhysics = true;
        this.oRoll = this.roll = this.random.nextFloat() * 2.0f - 1.0f;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.move(this.xd, this.yd, this.zd);
        this.yd *= 0.7;
        this.yd -= 0.02;
        if (this.onGround) {
            this.xd *= 0.7;
            this.zd *= 0.7;
        } else {
            this.rot += 5.0f;
            if (this.xd == 0.0) {
                this.xd += (double)((float)(this.random.nextBoolean() ? 1 : -1) * 0.001f);
            }
            if (this.zd == 0.0) {
                this.zd += (double)((float)(this.random.nextBoolean() ? 1 : -1) * 0.001f);
            }
            if (this.random.nextInt(5) == 0) {
                this.xd += Math.signum(this.target.x - this.x) * (double)this.random.nextFloat() * (double)0.005f;
            }
            if (this.random.nextInt(5) == 0) {
                this.zd += Math.signum(this.target.z - this.z) * (double)this.random.nextFloat() * (double)0.005f;
            }
        }
    }

    public void render(VertexConsumer buffer, Camera entity, float partialTicks) {
        this.alpha = Math.min((float)Mth.clamp((int)this.age, (int)0, (int)20) / 20.0f, (float)Mth.clamp((int)(this.lifetime - this.age), (int)0, (int)20) / 20.0f);
        Quaternionf quaternion = new Quaternionf();
        if (this.roll != 0.0f) {
            quaternion.rotateZ(Mth.lerp((float)partialTicks, (float)this.oRoll, (float)this.roll));
        }
        quaternion.rotateY(Mth.cos((float)((float)Math.toRadians(this.rot % 360.0f))));
        this.renderRotatedQuad(buffer, entity, quaternion, partialTicks);
        quaternion.rotateY((float)(-Math.PI)).rotateZ(1.5707964f);
        this.renderRotatedQuad(buffer, entity, quaternion, partialTicks);
    }

    public int getLightColor(float partialTicks) {
        return 0xF000F0;
    }

    public record Factory(SpriteSet sprite) implements ParticleProvider<LeafParticleData>
    {
        public Particle createParticle(LeafParticleData data, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            LeafParticle particle = new LeafParticle(level, x, y, z, xSpeed, ySpeed, zSpeed);
            particle.setColor((float)data.r() / 255.0f, (float)data.g() / 255.0f, (float)data.b() / 255.0f);
            particle.pickSprite(this.sprite);
            return particle;
        }
    }
}

