/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import twilightforest.client.JappaPackReloadListener;
import twilightforest.client.model.entity.TrophyBlockModel;
import twilightforest.client.renderer.entity.SnowQueenRenderer;
import twilightforest.entity.boss.SnowQueen;

public class SnowQueenModel
extends HumanoidModel<SnowQueen>
implements TrophyBlockModel {
    public SnowQueenModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition checkForPack() {
        return JappaPackReloadListener.INSTANCE.isJappaPackLoaded() ? SnowQueenModel.createJappaModel() : SnowQueenModel.create();
    }

    private static LayerDefinition create() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.ZERO);
        PartDefinition crown = head.addOrReplaceChild("crown", CubeListBuilder.create(), PartPose.ZERO);
        SnowQueenModel.makeFrontCrown(crown, -1.0f, -4.0f, 10.0f, 0);
        SnowQueenModel.makeFrontCrown(crown, 0.0f, 4.0f, -10.0f, 1);
        SnowQueenModel.makeSideCrown(crown, -1.0f, -4.0f, 10.0f, 0);
        SnowQueenModel.makeSideCrown(crown, 0.0f, 4.0f, -10.0f, 1);
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 23.0f, 4.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(16, 16).addBox(-2.0f, -2.0f, -1.5f, 3.0f, 12.0f, 3.0f), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(16, 16).addBox(-1.0f, -2.0f, -1.3f, 3.0f, 12.0f, 3.0f), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 12.0f, 3.0f), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 12.0f, 3.0f), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    private static void makeSideCrown(PartDefinition parent, float spikeDepth, float crownX, float angle, int iteration) {
        PartDefinition crownSide = parent.addOrReplaceChild("crown_side_" + iteration, CubeListBuilder.create().texOffs(28, 28).addBox(-3.5f, -0.5f, -0.5f, 7.0f, 1.0f, 1.0f), PartPose.offsetAndRotation((float)crownX, (float)-6.0f, (float)0.0f, (float)0.0f, (float)1.5707964f, (float)0.0f));
        crownSide.addOrReplaceChild("spike_4", CubeListBuilder.create().texOffs(48, 27).addBox(-0.5f, -3.5f, spikeDepth, 1.0f, 4.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)(angle * 1.5f * ((float)Math.PI / 180)), (float)0.0f, (float)0.0f));
        crownSide.addOrReplaceChild("spike_3l", CubeListBuilder.create().texOffs(52, 28).addBox(-0.5f, -2.5f, spikeDepth, 1.0f, 3.0f, 1.0f), PartPose.offsetAndRotation((float)-2.5f, (float)0.0f, (float)0.0f, (float)(angle * ((float)Math.PI / 180)), (float)0.0f, (float)-0.17453292f));
        crownSide.addOrReplaceChild("spike_3r", CubeListBuilder.create().texOffs(52, 28).addBox(-0.5f, -2.5f, spikeDepth, 1.0f, 3.0f, 1.0f), PartPose.offsetAndRotation((float)2.5f, (float)0.0f, (float)0.0f, (float)(angle * ((float)Math.PI / 180)), (float)0.0f, (float)0.17453292f));
    }

    private static void makeFrontCrown(PartDefinition parent, float spikeDepth, float crownZ, float angle, int iteration) {
        PartDefinition crownFront = parent.addOrReplaceChild("crown_front_" + iteration, CubeListBuilder.create().texOffs(28, 30).addBox(-4.5f, -0.5f, -0.5f, 9.0f, 1.0f, 1.0f), PartPose.offset((float)0.0f, (float)-6.0f, (float)crownZ));
        crownFront.addOrReplaceChild("spike_4", CubeListBuilder.create().texOffs(48, 27).addBox(-0.5f, -3.5f, spikeDepth, 1.0f, 4.0f, 1.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)(angle * 1.5f * ((float)Math.PI / 180)), (float)0.0f, (float)0.0f));
        crownFront.addOrReplaceChild("spike_3l", CubeListBuilder.create().texOffs(52, 28).addBox(-0.5f, -2.5f, spikeDepth, 1.0f, 3.0f, 1.0f), PartPose.offsetAndRotation((float)-2.5f, (float)0.0f, (float)0.0f, (float)(angle * ((float)Math.PI / 180)), (float)0.0f, (float)-0.17453292f));
        crownFront.addOrReplaceChild("spike_3r", CubeListBuilder.create().texOffs(52, 28).addBox(-0.5f, -2.5f, spikeDepth, 1.0f, 3.0f, 1.0f), PartPose.offsetAndRotation((float)2.5f, (float)0.0f, (float)0.0f, (float)(angle * ((float)Math.PI / 180)), (float)0.0f, (float)0.17453292f));
    }

    private static LayerDefinition createJappaModel() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f).texOffs(32, 45).addBox(-4.5f, 10.0f, -2.5f, 9.0f, 14.0f, 5.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(14, 32).addBox(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(16, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 32).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition hat = partdefinition.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.ZERO);
        hat.addOrReplaceChild("crown_front", CubeListBuilder.create().texOffs(24, 0).addBox(-5.0f, -4.0f, 0.0f, 10.0f, 4.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)-4.0f, (float)0.3926991f, (float)0.0f, (float)0.0f));
        hat.addOrReplaceChild("crown_right", CubeListBuilder.create().texOffs(24, 4).addBox(-5.0f, -4.0f, 0.0f, 10.0f, 4.0f, 0.0f), PartPose.offsetAndRotation((float)-4.0f, (float)-6.0f, (float)0.0f, (float)0.3926991f, (float)1.5707964f, (float)0.0f));
        hat.addOrReplaceChild("crown_left", CubeListBuilder.create().texOffs(44, 4).addBox(-5.0f, -4.0f, 0.0f, 10.0f, 4.0f, 0.0f), PartPose.offsetAndRotation((float)4.0f, (float)-6.0f, (float)0.0f, (float)-0.3926991f, (float)1.5707964f, (float)0.0f));
        hat.addOrReplaceChild("crown_back", CubeListBuilder.create().texOffs(44, 0).addBox(-5.0f, -4.0f, 0.0f, 10.0f, 4.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)4.0f, (float)-0.3926991f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(SnowQueen entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (entity.getCurrentPhase() == SnowQueen.Phase.BEAM) {
            if (entity.isBreathing()) {
                float f6 = Mth.sin((float)(this.attackTime * (float)Math.PI));
                float f7 = Mth.sin((float)((1.0f - (1.0f - this.attackTime) * (1.0f - this.attackTime)) * (float)Math.PI));
                this.rightArm.zRot = 0.0f;
                this.leftArm.zRot = 0.0f;
                this.rightArm.yRot = -(0.1f - f6 * 0.6f);
                this.leftArm.yRot = 0.1f - f6 * 0.6f;
                this.rightArm.xRot = -1.5707964f;
                this.leftArm.xRot = -1.5707964f;
                this.rightArm.xRot -= f6 * 1.2f - f7 * 0.4f;
                this.leftArm.xRot -= f6 * 1.2f - f7 * 0.4f;
                AnimationUtils.bobArms((ModelPart)this.rightArm, (ModelPart)this.leftArm, (float)ageInTicks);
            } else {
                this.rightArm.xRot += (float)Math.PI;
                this.leftArm.xRot += (float)Math.PI;
            }
        }
    }

    @Override
    public void renderTrophy(PoseStack stack, MultiBufferSource buffer, int light, int overlay, int color, ItemDisplayContext context) {
        if (!JappaPackReloadListener.INSTANCE.isJappaPackLoaded()) {
            stack.translate(0.0f, 0.25f, 0.0f);
        }
        VertexConsumer consumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)SnowQueenRenderer.TEXTURE));
        this.head.render(stack, consumer, light, overlay, color);
        this.hat.render(stack, consumer, light, overlay, color);
    }

    @Override
    public void setupRotationsForTrophy(float x, float y, float z, float mouthAngle) {
        this.head.yRot = y * ((float)Math.PI / 180);
        this.head.xRot = z * ((float)Math.PI / 180);
    }
}

