/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import net.minecraft.client.model.SheepModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import twilightforest.client.JappaPackReloadListener;
import twilightforest.entity.passive.Bighorn;

public class BighornModel<T extends Bighorn>
extends SheepModel<T> {
    public BighornModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition checkForPack() {
        return JappaPackReloadListener.INSTANCE.isJappaPackLoaded() ? BighornModel.createJappaModel() : BighornModel.create();
    }

    private static LayerDefinition create() {
        MeshDefinition meshdefinition = SheepModel.createBodyMesh((int)0, (CubeDeformation)CubeDeformation.NONE);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -4.0f, -6.0f, 6.0f, 6.0f, 7.0f), PartPose.offset((float)0.0f, (float)6.0f, (float)-8.0f));
        head.addOrReplaceChild("left_horn", CubeListBuilder.create().texOffs(28, 16).addBox(-5.0f, -4.0f, -4.0f, 2.0f, 2.0f, 2.0f).texOffs(16, 13).addBox(-6.0f, -5.0f, -3.0f, 2.0f, 2.0f, 4.0f).texOffs(16, 19).addBox(-7.0f, -4.0f, 0.0f, 2.0f, 5.0f, 2.0f).texOffs(18, 27).addBox(-8.0f, 0.0f, -2.0f, 2.0f, 2.0f, 3.0f).texOffs(28, 27).addBox(-9.0f, -1.0f, -3.0f, 2.0f, 2.0f, 1.0f), PartPose.ZERO);
        head.addOrReplaceChild("right_horn", CubeListBuilder.create().texOffs(28, 16).addBox(3.0f, -4.0f, -4.0f, 2.0f, 2.0f, 2.0f).texOffs(16, 13).addBox(4.0f, -5.0f, -3.0f, 2.0f, 2.0f, 4.0f).texOffs(16, 19).addBox(5.0f, -4.0f, 0.0f, 2.0f, 5.0f, 2.0f).texOffs(18, 27).addBox(6.0f, 0.0f, -2.0f, 2.0f, 2.0f, 3.0f).texOffs(28, 27).addBox(7.0f, -1.0f, -3.0f, 2.0f, 2.0f, 1.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(36, 10).addBox(-4.0f, -9.0f, -7.0f, 8.0f, 15.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)5.0f, (float)2.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)-3.0f, (float)12.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)3.0f, (float)12.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)-3.0f, (float)12.0f, (float)-5.0f));
        partdefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)3.0f, (float)12.0f, (float)-5.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    private static LayerDefinition createJappaModel() {
        MeshDefinition meshdefinition = SheepModel.createBodyMesh((int)0, (CubeDeformation)CubeDeformation.NONE);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(38, 0).addBox(-3.0f, -4.0f, -6.0f, 6.0f, 6.0f, 7.0f), PartPose.offset((float)0.0f, (float)5.0f, (float)-8.0f));
        head.addOrReplaceChild("right_horn", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -1.0f, -7.0f, 3.0f, 3.0f, 5.0f).texOffs(0, 8).addBox(-4.0f, 2.0f, -9.0f, 3.0f, 2.0f, 5.0f).texOffs(4, 15).addBox(-4.0f, 0.0f, -11.0f, 2.0f, 3.0f, 2.0f), PartPose.offsetAndRotation((float)-2.0f, (float)-3.0f, (float)-1.0f, (float)0.0f, (float)0.3926991f, (float)0.21816616f));
        head.addOrReplaceChild("left_horn", CubeListBuilder.create().texOffs(16, 0).addBox(0.0f, -1.0f, -7.0f, 3.0f, 3.0f, 5.0f).texOffs(16, 8).addBox(1.0f, 2.0f, -9.0f, 3.0f, 2.0f, 5.0f).texOffs(20, 15).addBox(2.0f, 0.0f, -11.0f, 2.0f, 3.0f, 2.0f), PartPose.offsetAndRotation((float)2.0f, (float)-3.0f, (float)-1.0f, (float)0.0f, (float)-0.3926991f, (float)-0.21816616f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(34, 13).addBox(-4.5f, -14.0f, -3.0f, 9.0f, 16.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)10.0f, (float)6.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(0, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)-3.0f, (float)12.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(16, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)3.0f, (float)12.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(0, 32).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)-3.0f, (float)12.0f, (float)-5.0f));
        partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(16, 32).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)3.0f, (float)12.0f, (float)-5.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        this.head.getChild((String)"left_horn").visible = !entity.isBaby();
        this.head.getChild((String)"right_horn").visible = !entity.isBaby();
        super.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTicks);
    }
}

