/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;
import twilightforest.block.JarBlock;
import twilightforest.block.entity.MasonJarBlockEntity;
import twilightforest.init.TFSounds;

public class MasonJarBlock
extends JarBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<MasonJarBlock> CODEC = MasonJarBlock.simpleCodec(MasonJarBlock::new);

    public MasonJarBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new MasonJarBlockEntity(pos, state);
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (super.useItemOn(stack, state, level, pos, player, hand, hitResult) == ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof MasonJarBlockEntity) {
                MasonJarBlockEntity blockEntity2 = (MasonJarBlockEntity)blockEntity;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    MasonJarBlockEntity.MasonJarItemStackHandler handler = blockEntity2.getItemHandler();
                    if (stack.isEmpty()) {
                        ItemStack test = handler.extractItem(0, Integer.MAX_VALUE, true);
                        if (!test.isEmpty()) {
                            if (player.isSecondaryUseActive()) {
                                player.displayClientMessage((Component)Component.literal((String)(test.getItem().getName(test).getString() + " x" + test.getCount())), true);
                                serverLevel.playSound(null, pos, (SoundEvent)TFSounds.JAR_WIGGLE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                                blockEntity2.wobble(DecoratedPotBlockEntity.WobbleStyle.NEGATIVE);
                            } else {
                                ItemStack attainedStack = handler.extractItem(0, Integer.MAX_VALUE, false);
                                player.setItemInHand(hand, attainedStack);
                                serverLevel.playSound(null, pos, (SoundEvent)TFSounds.JAR_REMOVE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                                serverLevel.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                            }
                        } else {
                            serverLevel.playSound(null, pos, (SoundEvent)TFSounds.JAR_WIGGLE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                            blockEntity2.wobble(DecoratedPotBlockEntity.WobbleStyle.NEGATIVE);
                        }
                    } else if (handler.insertItem(0, stack, true).getCount() < stack.getCount()) {
                        blockEntity2.setItemRotation(RotationSegment.convertToSegment((float)(player.getYRot() + 180.0f)));
                        player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                        ItemStack inserted = stack.copy();
                        ItemStack returned = handler.insertItem(0, stack, false);
                        player.setItemInHand(hand, returned);
                        float pitch = (float)(inserted.getCount() - returned.getCount()) / (float)inserted.getMaxStackSize();
                        serverLevel.playSound(null, pos, (SoundEvent)TFSounds.JAR_INSERT.get(), SoundSource.BLOCKS, 1.0f, 0.7f + 0.5f * pitch);
                        serverLevel.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                    } else {
                        serverLevel.playSound(null, pos, (SoundEvent)TFSounds.JAR_WIGGLE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        blockEntity2.wobble(DecoratedPotBlockEntity.WobbleStyle.NEGATIVE);
                    }
                }
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Override
    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        Object object = params.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof MasonJarBlockEntity) {
            MasonJarBlockEntity jarBlockEntity = (MasonJarBlockEntity)((Object)object);
            params = params.withDynamicDrop(ShulkerBoxBlock.CONTENTS, stackConsumer -> stackConsumer.accept(jarBlockEntity.getItemHandler().getItem()));
        }
        return super.getDrops(state, params);
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public boolean hasDynamicLightEmission(BlockState state) {
        return true;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        AuxiliaryLightManager lightManager = level.getAuxLightManager(pos);
        if (lightManager != null) {
            return lightManager.getLightAt(pos);
        }
        return super.getLightEmission(state, level, pos);
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MasonJarBlockEntity) {
            MasonJarBlockEntity jarBlockEntity = (MasonJarBlockEntity)blockEntity;
            ItemStack itemstack = jarBlockEntity.getItemHandler().getItem();
            return Mth.lerpDiscrete((float)(itemstack.isEmpty() ? 0.0f : (float)itemstack.getCount() / (float)itemstack.getMaxStackSize()), (int)0, (int)15);
        }
        return 0;
    }
}

