/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import twilightforest.block.JarBlock;
import twilightforest.block.entity.JarBlockEntity;
import twilightforest.components.item.JarLid;
import twilightforest.config.TFConfig;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDataComponents;
import twilightforest.init.TFSounds;

public class CicadaJarBlock
extends JarBlock {
    public CicadaJarBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        BlockEntity blockEntity;
        if (player.isShiftKeyDown() && (blockEntity = level.getBlockEntity(pos)) instanceof JarBlockEntity) {
            JarBlockEntity jarBE = (JarBlockEntity)blockEntity;
            ItemEntity cicada = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), new ItemStack(TFBlocks.CICADA));
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            cicada.spawnAtLocation(cicada.getItem());
            cicada.spawnAtLocation((ItemStack)Util.make((Object)new ItemStack((ItemLike)TFBlocks.MASON_JAR.get()), jar -> jar.set((DataComponentType)TFDataComponents.JAR_LID.get(), (Object)new JarLid(jarBE.lid))));
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useWithoutItem(state, level, pos, player, result);
    }

    @Override
    public Item getDefaultLid() {
        return TFBlocks.CANOPY_LOG.asItem();
    }

    public void destroy(LevelAccessor accessor, BlockPos pos, BlockState state) {
        super.destroy(accessor, pos, state);
        if (accessor.isClientSide()) {
            Minecraft.getInstance().getSoundManager().stop(((SoundEvent)TFSounds.CICADA.get()).getLocation(), SoundSource.BLOCKS);
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        double dx = (float)pos.getX() + ((random.nextFloat() - random.nextFloat()) * 0.2f + 0.5f);
        double dy = (float)pos.getY() + 0.4f + (random.nextFloat() - random.nextFloat()) * 0.2f;
        double dz = (float)pos.getZ() + ((random.nextFloat() - random.nextFloat()) * 0.2f + 0.5f);
        level.addParticle((ParticleOptions)ParticleTypes.NOTE, dx, dy, dz, 0.0, 0.0, 0.0);
        if (level.getRandom().nextInt(75) == 0 && !TFConfig.silentCicadas) {
            level.playLocalSound((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (SoundEvent)TFSounds.CICADA.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
    }
}

