/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.lighting;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import java.util.Objects;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import org.jetbrains.annotations.Nullable;

public class SimpleBrightnessModel
implements IVertexOperation {
    public static final int operationIndex = IVertexOperation.registerOperation();
    public static SimpleBrightnessModel instance = new SimpleBrightnessModel();
    @Nullable
    public BlockAndTintGetter access;
    public BlockPos pos = BlockPos.ZERO;
    private int sampled = 0;
    private final int[] samples = new int[6];

    public void locate(BlockAndTintGetter a, BlockPos bPos) {
        this.access = a;
        this.pos = bPos;
        this.sampled = 0;
    }

    public int sample(int side) {
        Objects.requireNonNull(this.access, "SimpleBrightnessModel must be located first.");
        if ((this.sampled & 1 << side) == 0) {
            this.samples[side] = LevelRenderer.getLightColor((BlockAndTintGetter)this.access, (BlockPos)this.pos.relative(Direction.BY_3D_DATA[side]));
            this.sampled |= 1 << side;
        }
        return this.samples[side];
    }

    @Override
    public boolean load(CCRenderState ccrs) {
        ccrs.pipeline.addDependency(ccrs.sideAttrib);
        return true;
    }

    @Override
    public void operate(CCRenderState ccrs) {
        ccrs.brightness = this.sample(ccrs.side);
    }

    @Override
    public int operationID() {
        return operationIndex;
    }
}

