/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal;

import codechicken.lib.colour.EnumColour;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.lib.vec.Cuboid6;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;

public class HighlightHandler {
    private static final CrashLock LOCK = new CrashLock("Already Initialized");
    private static final Cuboid6 BOX = Cuboid6.full.copy().expand(0.02);
    private static final float[] RED = EnumColour.RED.getColour(128).packArray();
    @Nullable
    public static BlockPos highlight;
    public static boolean useDepth;
    private static final RenderType box;
    private static final RenderStateShard.DepthTestStateShard DISABLE_DEPTH;
    private static final RenderType boxNoDepth;

    public static void init() {
        LOCK.lock();
        NeoForge.EVENT_BUS.addListener(HighlightHandler::renderLevelLast);
    }

    private static void renderLevelLast(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        if (highlight != null) {
            MultiBufferSource.BufferSource source = Minecraft.getInstance().renderBuffers().bufferSource();
            Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
            Vec3 cameraPos = camera.getPosition();
            PoseStack pStack = event.getPoseStack();
            pStack.pushPose();
            pStack.translate(-cameraPos.x, -cameraPos.y, -cameraPos.z);
            pStack.translate((float)highlight.getX(), (float)highlight.getY(), (float)highlight.getZ());
            RenderUtils.bufferCuboidSolid(new TransformingVertexConsumer(source.getBuffer(useDepth ? box : boxNoDepth), pStack), BOX, RED[0], RED[1], RED[2], RED[3]);
            source.endBatch();
            pStack.popPose();
        }
    }

    static {
        useDepth = true;
        box = RenderType.create((String)"ccl:box_depth", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.POSITION_COLOR_SHADER).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setWriteMaskState(RenderStateShard.COLOR_WRITE).createCompositeState(false));
        DISABLE_DEPTH = new RenderStateShard.DepthTestStateShard("none", 519){

            public void setupRenderState() {
                RenderSystem.disableDepthTest();
            }
        };
        boxNoDepth = RenderType.create((String)"ccl:box_no_depth", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.POSITION_COLOR_SHADER).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setWriteMaskState(RenderStateShard.COLOR_WRITE).setDepthTestState(DISABLE_DEPTH).createCompositeState(false));
    }
}

