/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.block.component.tile;

import codechicken.lib.block.ModularBlockEntity;
import codechicken.lib.block.ModularTileBlock;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.util.ArrayUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class InventoryComponent
extends ModularTileBlock.TileComponent<Data> {
    private final int size;
    private final int limit;
    private final List<Listener> changeListeners = new LinkedList<Listener>();

    private InventoryComponent(int size, int limit) {
        this.size = size;
        this.limit = limit;
    }

    public void onChanged(Listener listener) {
        this.changeListeners.add(listener);
    }

    @Override
    protected Data createData(ModularBlockEntity ent) {
        return new Data(ent, this, this.size, this.limit);
    }

    public class Data
    extends ModularBlockEntity.DataComponent
    implements Container {
        private final ItemStack[] items;
        private final int limit;

        protected Data(ModularBlockEntity tile, ModularTileBlock.TileComponent<?> tileComponent, int size, int limit) {
            super(tile, tileComponent);
            this.items = ArrayUtils.fill(new ItemStack[size], ItemStack.EMPTY);
            this.limit = limit;
        }

        public void clearContent() {
            ArrayUtils.fill(this.items, ItemStack.EMPTY);
        }

        public int getContainerSize() {
            return this.items.length;
        }

        public boolean isEmpty() {
            for (ItemStack item : this.items) {
                if (item.isEmpty()) continue;
                return false;
            }
            return true;
        }

        public ItemStack getItem(int slot) {
            return this.items[slot];
        }

        public ItemStack removeItem(int slot, int amount) {
            return InventoryUtils.decrStackSize(this, slot, amount);
        }

        public ItemStack removeItemNoUpdate(int slot) {
            return InventoryUtils.removeStackFromSlot(this, slot);
        }

        public void setItem(int slot, ItemStack stack) {
            this.items[slot] = stack;
            this.setChanged();
        }

        public void setChanged() {
            this.tile.setChanged();
            for (Listener listener : InventoryComponent.this.changeListeners) {
                listener.onChanged(this);
            }
        }

        public boolean stillValid(Player player) {
            return true;
        }

        public int getMaxStackSize() {
            return this.limit;
        }

        @Override
        protected void save(CompoundTag tag, HolderLookup.Provider registries) {
            tag.put("Items", (Tag)InventoryUtils.writeItemStacksToTag(registries, this.items));
        }

        @Override
        protected void load(CompoundTag tag, HolderLookup.Provider registries) {
            InventoryUtils.readItemStacksFromTag(registries, this.items, tag.getList("Items", 10));
        }
    }

    public static interface Listener {
        public void onChanged(Data var1);
    }
}

