/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util;

import de.srendi.advancedperipherals.common.blocks.blockentities.EnergyDetectorEntity;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyStorageProxy
implements IEnergyStorage {
    private final EnergyDetectorEntity energyDetectorTE;
    private int maxTransferRate;
    private int transferredInThisTick = 0;

    public EnergyStorageProxy(EnergyDetectorEntity energyDetectorTE, int maxTransferRate) {
        this.energyDetectorTE = energyDetectorTE;
        this.maxTransferRate = maxTransferRate;
    }

    public boolean canReceive() {
        return true;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        IEnergyStorage out = this.energyDetectorTE.getOutputStorage();
        if (out == null) {
            return 0;
        }
        int transferred = out.receiveEnergy(Math.min(maxReceive, this.maxTransferRate - this.transferredInThisTick), simulate);
        if (!simulate) {
            this.transferredInThisTick += transferred;
        }
        return transferred;
    }

    public int getEnergyStored() {
        IEnergyStorage out = this.energyDetectorTE.getOutputStorage();
        if (out == null) {
            return 0;
        }
        return out.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        IEnergyStorage out = this.energyDetectorTE.getOutputStorage();
        if (out == null) {
            return 0;
        }
        return out.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return false;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getMaxTransferRate() {
        return this.maxTransferRate;
    }

    public void setMaxTransferRate(int rate) {
        this.maxTransferRate = rate;
    }

    public void resetTransferedInThisTick() {
        this.transferredInThisTick = 0;
    }

    public int getTransferredInThisTick() {
        return this.transferredInThisTick;
    }
}

