/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.computer.ComputerSide;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoordUtil {
    public static boolean isInRange(@Nullable BlockPos pos, @Nullable Level world, @Nullable Player player, int range, int maxRange) {
        if (pos == null || world == null || player == null) {
            return false;
        }
        if (range == 0 || maxRange == 0) {
            return false;
        }
        if (range < 0) {
            if (maxRange < 0) {
                return true;
            }
            range = maxRange;
        } else if (maxRange > 0 && range > maxRange) {
            range = maxRange;
        }
        return CoordUtil.isPlayerInBlockRange(pos, world, player, range);
    }

    private static boolean isPlayerInBlockRange(@NotNull BlockPos pos, @NotNull Level world, @NotNull Player player, double range) {
        if (range != -1.0 && player.level() != world) {
            return false;
        }
        double x = player.getX();
        double y = player.getY();
        double ey = player.getEyeY();
        double z = player.getZ();
        if (ey > y) {
            double tmp = ey;
            ey = y;
            y = tmp;
        }
        double bx = (double)pos.getX() + 0.5;
        double by = (double)pos.getY() + 0.5;
        double bz = (double)pos.getZ() + 0.5;
        return Math.abs(x - bx) <= range && Math.abs(z - bz) <= range && (y <= by && by <= ey || Math.min(Math.abs(y - by), Math.abs(ey - by)) <= range);
    }

    public static boolean isInRange(@Nullable BlockPos pos, @Nullable Level world, @Nullable Player player, int x, int y, int z, int maxRange) {
        if (pos == null || world == null || player == null) {
            return false;
        }
        x = Math.min(Math.abs(x), maxRange != -1 ? maxRange : Integer.MAX_VALUE);
        y = Math.min(Math.abs(y), maxRange != -1 ? maxRange : Integer.MAX_VALUE);
        z = Math.min(Math.abs(z), maxRange != -1 ? maxRange : Integer.MAX_VALUE);
        return CoordUtil.isPlayerInBlockRangeXYZ(pos, world, player, x, y, z, maxRange);
    }

    private static boolean isPlayerInBlockRangeXYZ(@NotNull BlockPos pos, @NotNull Level world, @NotNull Player player, double dx, double dy, double dz, int maxRange) {
        if (maxRange != -1 && player.level() != world) {
            return false;
        }
        double x = player.getX();
        double y = player.getY();
        double ey = player.getEyeY();
        double z = player.getZ();
        if (ey > y) {
            double tmp = ey;
            ey = y;
            y = tmp;
        }
        double bx = (double)pos.getX() + 0.5;
        double by = (double)pos.getY() + 0.5;
        double bz = (double)pos.getZ() + 0.5;
        return Math.abs(x - bx) <= dx && Math.abs(z - bz) <= dz && (y <= by && by <= ey || Math.min(Math.abs(y - by), Math.abs(ey - by)) <= dy);
    }

    public static boolean isInRange(@Nullable BlockPos blockPos, @Nullable Player player, @Nullable Level world, @NotNull BlockPos firstPos, @NotNull BlockPos secondPos, int maxRange) {
        if (blockPos == null || world == null || player == null) {
            return false;
        }
        double i = Math.abs(player.getX() - (double)blockPos.getX());
        double j = Math.abs(player.getZ() - (double)blockPos.getZ());
        int n = maxRange != -1 ? maxRange : Integer.MAX_VALUE;
        if (i + j > (double)n) {
            return false;
        }
        return world.getNearbyPlayers(TargetingConditions.forNonCombat(), null, new AABB((double)firstPos.getX(), (double)firstPos.getY(), (double)firstPos.getZ(), (double)secondPos.getX(), (double)secondPos.getY(), (double)secondPos.getZ())).contains(player);
    }

    @Nullable
    public static Direction getDirection(FrontAndTop orientation, String computerSide) throws LuaException {
        if (computerSide == null) {
            return null;
        }
        Direction dir = Direction.byName((String)(computerSide = computerSide.toLowerCase(Locale.ROOT)));
        if (dir != null) {
            return dir;
        }
        Direction top = orientation.top();
        Direction front = orientation.front();
        ComputerSide side = ComputerSide.valueOfInsensitive((String)computerSide);
        if (side == null) {
            return null;
        }
        if (front.getAxis() == Direction.Axis.Y) {
            return switch (side) {
                default -> throw new MatchException(null, null);
                case ComputerSide.FRONT -> front;
                case ComputerSide.BACK -> front.getOpposite();
                case ComputerSide.TOP -> top;
                case ComputerSide.BOTTOM -> top.getOpposite();
                case ComputerSide.RIGHT -> top.getClockWise();
                case ComputerSide.LEFT -> top.getCounterClockWise();
            };
        }
        return switch (side) {
            default -> throw new MatchException(null, null);
            case ComputerSide.FRONT -> front;
            case ComputerSide.BACK -> front.getOpposite();
            case ComputerSide.TOP -> Direction.UP;
            case ComputerSide.BOTTOM -> Direction.DOWN;
            case ComputerSide.RIGHT -> front.getCounterClockWise();
            case ComputerSide.LEFT -> front.getClockWise();
        };
    }
}

