/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.operations;

import de.srendi.advancedperipherals.common.addons.computercraft.operations.SingleOperationContext;
import de.srendi.advancedperipherals.common.setup.DataComponents;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralOperation;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.component.DataComponentType;
import net.neoforged.neoforge.common.ModConfigSpec;

public enum SingleOperation implements IPeripheralOperation<SingleOperationContext>
{
    DIG(1000, 1),
    USE_ON_BLOCK(5000, 1),
    SUCK(1000, 1),
    USE_ON_ANIMAL(2500, 10),
    CAPTURE_ANIMAL(50000, 100),
    WARP(1000, DistancePolicy.IGNORED, CountPolicy.MULTIPLY, 1, DistancePolicy.SQRT, CountPolicy.MULTIPLY),
    ACCURE_PLACE(1000, DistancePolicy.IGNORED, CountPolicy.MULTIPLY, 1, DistancePolicy.LINEAR, CountPolicy.MULTIPLY);

    private final int defaultCooldown;
    private final DistancePolicy distanceCooldownPolicy;
    private final CountPolicy countCooldownPolicy;
    private final int defaultCost;
    private final DistancePolicy distanceCostPolicy;
    private final CountPolicy countCostPolicy;
    private ModConfigSpec.IntValue cooldown;
    private ModConfigSpec.IntValue cost;

    private SingleOperation(int defaultCooldown, DistancePolicy distanceCooldownPolicy, CountPolicy countCooldownPolicy, int defaultCost, DistancePolicy distanceCostPolicy, CountPolicy countCostPolicy) {
        this.defaultCooldown = defaultCooldown;
        this.defaultCost = defaultCost;
        this.distanceCooldownPolicy = distanceCooldownPolicy;
        this.countCooldownPolicy = countCooldownPolicy;
        this.distanceCostPolicy = distanceCostPolicy;
        this.countCostPolicy = countCostPolicy;
    }

    private SingleOperation(int defaultCooldown, int defaultCost) {
        this(defaultCooldown, DistancePolicy.IGNORED, CountPolicy.MULTIPLY, defaultCost, DistancePolicy.IGNORED, CountPolicy.MULTIPLY);
    }

    @Override
    public int getInitialCooldown() {
        return (Integer)this.cooldown.get() * this.countCooldownPolicy.getFactor(5) * this.distanceCooldownPolicy.getFactor(2);
    }

    @Override
    public int getCooldown(SingleOperationContext context) {
        return (Integer)this.cooldown.get() * this.countCooldownPolicy.getFactor(context.getCount()) * this.distanceCooldownPolicy.getFactor(context.getDistance());
    }

    @Override
    public int getCost(SingleOperationContext context) {
        return (Integer)this.cost.get() * this.countCostPolicy.getFactor(context.getCount()) * this.distanceCostPolicy.getFactor(context.getDistance());
    }

    @Override
    public Map<String, Object> computerDescription() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("name", this.settingsName());
        data.put("type", this.getClass().getName());
        data.put("baseCooldown", this.cooldown.get());
        data.put("baseCost", this.cost.get());
        data.put("distanceCooldownPolicy", this.distanceCooldownPolicy.name().toLowerCase());
        data.put("countCooldownPolicy", this.countCooldownPolicy.name().toLowerCase());
        data.put("distanceCostPolicy", this.distanceCostPolicy.name().toLowerCase());
        data.put("countCostPolicy", this.countCostPolicy.name().toLowerCase());
        return data;
    }

    @Override
    public void addToConfig(ModConfigSpec.Builder builder) {
        this.cooldown = builder.defineInRange(this.settingsName() + "Cooldown", this.defaultCooldown, 0, Integer.MAX_VALUE);
        this.cost = builder.defineInRange(this.settingsName() + "Cost", this.defaultCost, 0, Integer.MAX_VALUE);
    }

    @Override
    public DataComponentType<Long> dataComponentType() {
        return (DataComponentType)DataComponents.SINGLE_OPERATION.get();
    }

    public static enum DistancePolicy {
        IGNORED(d -> 1),
        LINEAR(d -> d),
        SQRT(d -> (int)Math.sqrt(d.intValue()));

        private final Function<Integer, Integer> factorFunction;

        private DistancePolicy(Function<Integer, Integer> factorFunction) {
            this.factorFunction = factorFunction;
        }

        public int getFactor(int distance) {
            return this.factorFunction.apply(distance);
        }
    }

    public static enum CountPolicy {
        MULTIPLY(c -> c);

        private final Function<Integer, Integer> factorFunction;

        private CountPolicy(Function<Integer, Integer> factorFunction) {
            this.factorFunction = factorFunction;
        }

        public int getFactor(int count) {
            return this.factorFunction.apply(count);
        }
    }
}

