/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import com.google.common.base.Stopwatch;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.misc.IProgressTracker;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.IDebugDumpable;
import net.mehvahdjukaar.moonlight.api.resources.pack.IEditablePackResources;
import net.mehvahdjukaar.moonlight.api.resources.pack.PackGenerationStrategy;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.pack.SimplePackProvider;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.ResourceManager;

public abstract class DynamicResourcesProvider
implements SimplePackProvider {
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool();
    private final ResourceLocation name;
    private final PackLocationInfo locationInfo;
    private final PackType packType;
    protected final IEditablePackResources packResources;
    protected final PackGenerationStrategy generationStrategy;
    private volatile boolean needsRegeneration = true;

    public DynamicResourcesProvider(ResourceLocation name, PackType packType, PackGenerationStrategy generationPolicy) {
        this.name = name;
        this.packType = packType;
        this.generationStrategy = generationPolicy;
        this.locationInfo = new PackLocationInfo(name.toString(), (Component)Component.translatable((String)LangBuilder.getReadableName(name.toString())), PackSource.BUILT_IN, Optional.empty());
        this.packResources = generationPolicy.createPackResources(this.locationInfo, packType);
        this.packResources.addNamespaces(this.gatherSupportedNamespaces().toArray(new String[0]));
        this.packResources.addNamespaces(name.getNamespace());
    }

    public IEditablePackResources getPackResources() {
        return this.packResources;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public PackLocationInfo getLocationInfo() {
        return this.locationInfo;
    }

    public PackType getPackType() {
        return this.packType;
    }

    public PackSelectionConfig createSelectionConfig() {
        return new PackSelectionConfig(true, Pack.Position.TOP, false);
    }

    public String toString() {
        return "Dynamic " + String.valueOf(this.getPackType()) + " Resources Provider [" + String.valueOf(this.name) + "]";
    }

    public final void prepare() {
        this.needsRegeneration = this.needsToRegenerate();
    }

    public boolean needsToRegenerate() {
        boolean shouldRegenDueToInvalid;
        if (this.generationStrategy.needsRegeneration(this.packType)) {
            return this.packResources.clearAllResources();
        }
        boolean bl = shouldRegenDueToInvalid = !this.packResources.initializeIfValid();
        if (shouldRegenDueToInvalid) {
            Moonlight.LOGGER.info("Cache for {} at {} is invalid, will regenerate", (Object)this, (Object)this.packResources);
        }
        return shouldRegenDueToInvalid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(ResourceManager manager, IProgressTracker reporter) {
        if (this.needsRegeneration) {
            this.needsRegeneration = false;
            try {
                Moonlight.LOGGER.info("Regenerating {}, requested by strategy {}", (Object)this, (Object)this.generationStrategy);
                Stopwatch watch = Stopwatch.createStarted();
                this.runGenerationPipeline(manager, reporter);
                Moonlight.LOGGER.info("Generated runtime {} for pack {} in {}", (Object)this.getPackType(), (Object)this.packResources.packId(), (Object)watch);
            }
            catch (Exception e) {
                Moonlight.LOGGER.error("An error occurred while trying to generate dynamic assets for {}", (Object)this, (Object)e);
            }
            finally {
                IEditablePackResources iEditablePackResources;
                this.packResources.commitChanges();
                if (this.generateDebugResources() && (iEditablePackResources = this.packResources) instanceof IDebugDumpable) {
                    IDebugDumpable d = (IDebugDumpable)((Object)iEditablePackResources);
                    this.getExecutorService().execute(() -> d.dumpToDisk(Paths.get("debug", "generated_resource_pack")));
                }
            }
        } else {
            Moonlight.LOGGER.info("Skipping regeneration for {} (cache up-to-date)", (Object)this);
        }
    }

    private void runGenerationPipeline(ResourceManager manager, IProgressTracker progressTracker) {
        ArrayList genTasks = new ArrayList();
        try {
            this.regenerateDynamicAssets(genTasks::add);
        }
        catch (Exception e) {
            Moonlight.LOGGER.error("Failed to add tasks to dynamic resource gen: ", (Throwable)e);
        }
        int totalTasks = genTasks.size();
        IProgressTracker.Task reporter = progressTracker.subtask(totalTasks);
        List<CompletableFuture> futures = genTasks.stream().map(task -> CompletableFuture.supplyAsync(() -> {
            ResourceSink sink = new ResourceSink(this.name.getNamespace(), this.packResources.packId());
            task.accept(manager, sink);
            return sink;
        }, this.getExecutorService()).handle((sink, ex) -> {
            reporter.step();
            if (ex != null) {
                Moonlight.LOGGER.error("Resource Gen Task failed", ex);
                return null;
            }
            return sink;
        })).toList();
        List<ResourceSink> successful = futures.stream().map(CompletableFuture::join).filter(Objects::nonNull).toList();
        if (successful.isEmpty()) {
            Moonlight.LOGGER.warn("No resource sinks produced; all tasks failed or none were scheduled.");
            return;
        }
        try {
            ResourceSink.acceptSinks(this.packResources, successful);
        }
        catch (Exception e) {
            Moonlight.LOGGER.error("Failed to accept generated resource sinks", (Throwable)e);
        }
    }

    protected Executor getExecutorService() {
        return EXECUTOR_SERVICE;
    }

    protected boolean generateDebugResources() {
        return PlatHelper.isDev();
    }

    protected abstract Collection<String> gatherSupportedNamespaces();

    public void addSupportedNamespaces(String ... namespace) {
        this.packResources.addNamespaces(namespace);
    }

    protected abstract void regenerateDynamicAssets(Consumer<ResourceGenTask> var1);

    @Override
    public Pack createPack() {
        final IEditablePackResources resources = this.packResources;
        return Pack.readMetaAndCreate((PackLocationInfo)this.getLocationInfo(), (Pack.ResourcesSupplier)new Pack.ResourcesSupplier(){

            public PackResources openPrimary(PackLocationInfo location) {
                return resources;
            }

            public PackResources openFull(PackLocationInfo location, Pack.Metadata metadata) {
                return resources;
            }
        }, (PackType)this.getPackType(), (PackSelectionConfig)this.createSelectionConfig());
    }
}

