/*
 * Decompiled with CFR 0.152.
 */
package mcjty.incontrol.rules;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import mcjty.incontrol.ErrorHandler;
import mcjty.incontrol.InControl;
import mcjty.incontrol.compat.ModRuleCompatibilityLayer;
import mcjty.incontrol.data.PhaseTools;
import mcjty.incontrol.rules.support.GenericRuleEvaluator;
import mcjty.incontrol.rules.support.RuleKeys;
import mcjty.incontrol.tools.rules.IEventQuery;
import mcjty.incontrol.tools.rules.IModRuleCompatibilityLayer;
import mcjty.incontrol.tools.rules.RuleBase;
import mcjty.incontrol.tools.typed.Attribute;
import mcjty.incontrol.tools.typed.AttributeMap;
import mcjty.incontrol.tools.typed.GenericAttributeMapFactory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class SummonAidRule
extends RuleBase<RuleBase.EventGetter> {
    public static final IEventQuery<FinalizeSpawnEvent> EVENT_QUERY = new IEventQuery<FinalizeSpawnEvent>(){

        public Level getWorld(FinalizeSpawnEvent o) {
            return o.getLevel().getLevel();
        }

        @Override
        public BlockPos getPos(FinalizeSpawnEvent o) {
            return new BlockPos((int)o.getX(), (int)o.getY(), (int)o.getZ());
        }

        @Override
        public BlockPos getValidBlockPos(FinalizeSpawnEvent o) {
            return new BlockPos((int)o.getX(), (int)(o.getY() - 1.0), (int)o.getZ());
        }

        @Override
        public int getY(FinalizeSpawnEvent o) {
            return (int)o.getY();
        }

        @Override
        public Entity getEntity(FinalizeSpawnEvent o) {
            return o.getEntity();
        }

        @Override
        public DamageSource getSource(FinalizeSpawnEvent o) {
            return null;
        }

        @Override
        public Entity getAttacker(FinalizeSpawnEvent o) {
            return null;
        }

        @Override
        public Player getPlayer(FinalizeSpawnEvent o) {
            return null;
        }

        @Override
        public ItemStack getItem(FinalizeSpawnEvent o) {
            return ItemStack.EMPTY;
        }
    };
    private static final GenericAttributeMapFactory FACTORY = new GenericAttributeMapFactory();
    private static final Random rnd = new Random();
    private final GenericRuleEvaluator ruleEvaluator;
    private MobSpawnEvent.SpawnPlacementCheck.Result result;

    private SummonAidRule(AttributeMap map, Set<String> phases, int index) {
        super(phases, index);
        this.ruleEvaluator = new GenericRuleEvaluator(map);
        this.addActions(map, new ModRuleCompatibilityLayer());
    }

    public static SummonAidRule parse(JsonElement element, int index) {
        if (element == null) {
            return null;
        }
        AttributeMap map = FACTORY.parse(element, "summonaid.json");
        return new SummonAidRule(map, PhaseTools.getPhases(element), index);
    }

    @Override
    protected void addActions(AttributeMap map, IModRuleCompatibilityLayer layer) {
        super.addActions(map, layer);
        map.consumeOrElse(RuleKeys.ACTION_RESULT, br -> {
            this.result = "default".equals(br) || br.startsWith("def") ? MobSpawnEvent.SpawnPlacementCheck.Result.DEFAULT : ("allow".equals(br) || "true".equals(br) ? MobSpawnEvent.SpawnPlacementCheck.Result.SUCCEED : MobSpawnEvent.SpawnPlacementCheck.Result.FAIL);
        }, () -> {
            this.result = null;
        });
        if (!map.isEmpty()) {
            StringBuffer buffer = new StringBuffer();
            map.getKeys().forEach(k -> buffer.append(k).append(' '));
            ErrorHandler.error("Invalid keywords in additional spawn rule: " + String.valueOf(buffer));
        }
    }

    @Override
    protected void addPotionsAction(List<String> potions, boolean particles) {
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        for (String p : potions) {
            String[] splitted = StringUtils.split((String)p, (char)',');
            if (splitted == null || splitted.length != 3) {
                InControl.setup.getLogger().log(org.apache.logging.log4j.Level.ERROR, "Bad potion specifier '" + p + "'! Use <potion>,<duration>,<amplifier>");
                continue;
            }
            Optional potion = BuiltInRegistries.MOB_EFFECT.getHolder(ResourceLocation.parse((String)splitted[0]));
            if (potion.isEmpty()) {
                InControl.setup.getLogger().log(org.apache.logging.log4j.Level.ERROR, "Can't find potion '" + p + "'!");
                continue;
            }
            int duration = 0;
            int amplifier = 0;
            try {
                duration = Integer.parseInt(splitted[1]);
                amplifier = Integer.parseInt(splitted[2]);
            }
            catch (NumberFormatException e) {
                InControl.setup.getLogger().log(org.apache.logging.log4j.Level.ERROR, "Bad duration or amplifier integer for '" + p + "'!");
                continue;
            }
            effects.add(new MobEffectInstance((Holder)potion.get(), duration, amplifier));
        }
        if (!effects.isEmpty()) {
            this.actions.add(event -> {
                LivingEntity living = event.getEntityLiving();
                for (MobEffectInstance effect : effects) {
                    MobEffectInstance neweffect = new MobEffectInstance(effect.getEffect(), effect.getDuration(), effect.getAmplifier(), false, particles);
                    living.addEffect(neweffect);
                }
            });
        }
    }

    @Override
    protected void addArmorItem(List<String> itemList, EquipmentSlot slot) {
        List<Pair<Float, ItemStack>> items = this.getItemsWeighted(itemList);
        if (items.isEmpty()) {
            return;
        }
        if (items.size() == 1) {
            Pair<Float, ItemStack> pair = items.get(0);
            this.actions.add(event -> {
                LivingEntity helper = event.getEntityLiving();
                helper.setItemSlot(slot, ((ItemStack)pair.getRight()).copy());
            });
        } else {
            float total = this.getTotal(items);
            this.actions.add(event -> {
                ItemStack item = this.getRandomItem(items, total);
                LivingEntity helper = event.getEntityLiving();
                helper.setItemSlot(slot, item.copy());
            });
        }
    }

    @Override
    protected void addHeldItem(List<String> heldItems) {
        List<Pair<Float, ItemStack>> items = this.getItemsWeighted(heldItems);
        if (items.isEmpty()) {
            return;
        }
        if (items.size() == 1) {
            Pair<Float, ItemStack> pair = items.get(0);
            this.actions.add(event -> {
                LivingEntity helper = event.getEntityLiving();
                helper.setItemInHand(InteractionHand.MAIN_HAND, ((ItemStack)pair.getRight()).copy());
            });
        } else {
            float total = this.getTotal(items);
            this.actions.add(event -> {
                ItemStack item = this.getRandomItem(items, total);
                LivingEntity helper = event.getEntityLiving();
                helper.setItemInHand(InteractionHand.MAIN_HAND, item.copy());
            });
        }
    }

    @Override
    protected void addAngryAction(boolean angry) {
        if (angry) {
            this.actions.add(event -> {
                LivingEntity helper = event.getEntityLiving();
                Player player = event.getWorld().getNearestPlayer((Entity)helper, 50.0);
                if (player != null && helper instanceof Zombie) {
                    Zombie zombie = (Zombie)helper;
                    zombie.setTarget((LivingEntity)player);
                }
            });
        }
    }

    public boolean match(FinalizeSpawnEvent event) {
        return this.ruleEvaluator.match(event, EVENT_QUERY);
    }

    public void action(final FinalizeSpawnEvent event) {
        RuleBase.EventGetter getter = new RuleBase.EventGetter(){

            @Override
            public LivingEntity getEntityLiving() {
                return event.getEntity();
            }

            @Override
            public Player getPlayer() {
                return null;
            }

            public Level getWorld() {
                return event.getLevel().getLevel();
            }

            @Override
            public BlockPos getPosition() {
                return new BlockPos((int)event.getX(), (int)event.getY(), (int)event.getZ());
            }
        };
        for (Consumer action : this.actions) {
            action.accept(getter);
        }
    }

    public MobSpawnEvent.SpawnPlacementCheck.Result getResult() {
        return this.result;
    }

    static {
        FACTORY.attribute(Attribute.createMulti(RuleKeys.PHASE)).attribute(Attribute.create(RuleKeys.NUMBER)).attribute(Attribute.create(RuleKeys.TIME)).attribute(Attribute.create(RuleKeys.MINTIME)).attribute(Attribute.create(RuleKeys.MAXTIME)).attribute(Attribute.create(RuleKeys.DAYCOUNT)).attribute(Attribute.create(RuleKeys.MINDAYCOUNT)).attribute(Attribute.create(RuleKeys.MAXDAYCOUNT)).attribute(Attribute.create(RuleKeys.MINCOUNT)).attribute(Attribute.create(RuleKeys.MAXCOUNT)).attribute(Attribute.create(RuleKeys.LIGHT)).attribute(Attribute.create(RuleKeys.MINLIGHT)).attribute(Attribute.create(RuleKeys.MAXLIGHT)).attribute(Attribute.create(RuleKeys.MINLIGHT_FULL)).attribute(Attribute.create(RuleKeys.MAXLIGHT_FULL)).attribute(Attribute.create(RuleKeys.HEIGHT)).attribute(Attribute.create(RuleKeys.MINHEIGHT)).attribute(Attribute.create(RuleKeys.MAXHEIGHT)).attribute(Attribute.create(RuleKeys.MINDIFFICULTY)).attribute(Attribute.create(RuleKeys.MAXDIFFICULTY)).attribute(Attribute.create(RuleKeys.MINSPAWNDIST)).attribute(Attribute.create(RuleKeys.MAXSPAWNDIST)).attribute(Attribute.create(RuleKeys.RANDOM)).attribute(Attribute.create(RuleKeys.CANSPAWNHERE)).attribute(Attribute.create(RuleKeys.NOTCOLLIDING)).attribute(Attribute.create(RuleKeys.INBUILDING)).attribute(Attribute.create(RuleKeys.INMULTIBUILDING)).attribute(Attribute.createMulti(RuleKeys.BUILDING)).attribute(Attribute.createMulti(RuleKeys.MULTIBUILDING)).attribute(Attribute.create(RuleKeys.INCITY)).attribute(Attribute.create(RuleKeys.INSTREET)).attribute(Attribute.create(RuleKeys.INSPHERE)).attribute(Attribute.create(RuleKeys.PASSIVE)).attribute(Attribute.create(RuleKeys.HOSTILE)).attribute(Attribute.create(RuleKeys.BABY)).attribute(Attribute.create(RuleKeys.CAVE)).attribute(Attribute.create(RuleKeys.SEESKY)).attribute(Attribute.create(RuleKeys.SLIME)).attribute(Attribute.create(RuleKeys.WEATHER)).attribute(Attribute.createMulti(RuleKeys.BIOMETAGS)).attribute(Attribute.create(RuleKeys.DIFFICULTY)).attribute(Attribute.create(RuleKeys.HASSTRUCTURE)).attribute(Attribute.createMulti(RuleKeys.STRUCTURE)).attribute(Attribute.createMulti(RuleKeys.STRUCTURETAGS)).attribute(Attribute.create(RuleKeys.WINTER)).attribute(Attribute.create(RuleKeys.SUMMER)).attribute(Attribute.create(RuleKeys.SPRING)).attribute(Attribute.create(RuleKeys.AUTUMN)).attribute(Attribute.createMulti(RuleKeys.MOB)).attribute(Attribute.createMulti(RuleKeys.MOD)).attribute(Attribute.create(RuleKeys.AREA)).attribute(Attribute.createMulti(RuleKeys.BLOCK)).attribute(Attribute.create(RuleKeys.BLOCKOFFSET)).attribute(Attribute.createMulti(RuleKeys.BIOME)).attribute(Attribute.createMulti(RuleKeys.DIMENSION)).attribute(Attribute.createMulti(RuleKeys.DIMENSION_MOD)).attribute(Attribute.create(RuleKeys.STATE)).attribute(Attribute.createMulti(RuleKeys.SCOREBOARDTAGS_ALL)).attribute(Attribute.createMulti(RuleKeys.SCOREBOARDTAGS_ANY)).attribute(Attribute.create(RuleKeys.ACTION_CUSTOMEVENT)).attribute(Attribute.create(RuleKeys.ACTION_RESULT)).attribute(Attribute.create(RuleKeys.ACTION_MESSAGE)).attribute(Attribute.create(RuleKeys.ACTION_HEALTHSET)).attribute(Attribute.create(RuleKeys.ACTION_HEALTHMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_HEALTHADD)).attribute(Attribute.create(RuleKeys.ACTION_SPEEDSET)).attribute(Attribute.create(RuleKeys.ACTION_SPEEDMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_SPEEDADD)).attribute(Attribute.create(RuleKeys.ACTION_DAMAGESET)).attribute(Attribute.create(RuleKeys.ACTION_DAMAGEMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_DAMAGEADD)).attribute(Attribute.create(RuleKeys.ACTION_ARMORSET)).attribute(Attribute.create(RuleKeys.ACTION_ARMORMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_ARMORADD)).attribute(Attribute.create(RuleKeys.ACTION_ARMORTOUGHNESSSET)).attribute(Attribute.create(RuleKeys.ACTION_ARMORTOUGHNESSMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_ARMORTOUGHNESSADD)).attribute(Attribute.create(RuleKeys.ACTION_ATTACKSPEEDSET)).attribute(Attribute.create(RuleKeys.ACTION_ATTACKSPEEDMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_ATTACKSPEEDADD)).attribute(Attribute.create(RuleKeys.ACTION_FOLLOWRANGESET)).attribute(Attribute.create(RuleKeys.ACTION_FOLLOWRANGEMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_FOLLOWRANGEADD)).attribute(Attribute.create(RuleKeys.ACTION_KNOCKBACKSET)).attribute(Attribute.create(RuleKeys.ACTION_KNOCKBACKMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_KNOCKBACKADD)).attribute(Attribute.create(RuleKeys.ACTION_KNOCKBACKRESISTANCESET)).attribute(Attribute.create(RuleKeys.ACTION_KNOCKBACKRESISTANCEMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_KNOCKBACKRESISTANCEADD)).attribute(Attribute.create(RuleKeys.ACTION_SIZEMULTIPLY)).attribute(Attribute.create(RuleKeys.ACTION_SIZEADD)).attribute(Attribute.create(RuleKeys.ACTION_ANGRY)).attribute(Attribute.createMulti(RuleKeys.ACTION_HELDITEM)).attribute(Attribute.createMulti(RuleKeys.ACTION_ARMORBOOTS)).attribute(Attribute.createMulti(RuleKeys.ACTION_ARMORLEGS)).attribute(Attribute.createMulti(RuleKeys.ACTION_ARMORCHEST)).attribute(Attribute.createMulti(RuleKeys.ACTION_ARMORHELMET)).attribute(Attribute.createMulti(RuleKeys.ACTION_POTION)).attribute(Attribute.createMulti(RuleKeys.ACTION_POTION_NOPARTICLES)).attribute(Attribute.create(RuleKeys.ACTION_NODESPAWN));
    }
}

