/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component.ability.retaliation;

import artifacts.component.ability.EquipmentAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.registry.ModDataComponents;
import artifacts.util.DamageSourceHelper;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public abstract class RetaliationEffect
implements EquipmentAbility {
    private final String name;
    private final Value<Double> strikeChance;
    private final Value<Integer> cooldown;

    protected static <T extends RetaliationEffect> Products.P2<RecordCodecBuilder.Mu<T>, Value<Double>, Value<Integer>> codecStart(RecordCodecBuilder.Instance<T> instance) {
        return instance.group((App)ValueTypes.FRACTION.codec().fieldOf("chance").forGetter(RetaliationEffect::strikeChance), (App)ValueTypes.cooldownField().forGetter(RetaliationEffect::cooldown));
    }

    public RetaliationEffect(String name, Value<Double> strikeChance, Value<Integer> cooldown) {
        this.name = name;
        this.strikeChance = strikeChance;
        this.cooldown = cooldown;
    }

    public Value<Double> strikeChance() {
        return this.strikeChance;
    }

    public Value<Integer> cooldown() {
        return this.cooldown;
    }

    public void onLivingHurt(LivingEntity entity, ItemStack stack, DamageSource damageSource) {
        LivingEntity attacker = DamageSourceHelper.getAttacker(damageSource);
        if (attacker != null && !stack.has(ModDataComponents.DISABLED_BY_TOGGLE.get()) && entity.getRandom().nextDouble() < (Double)this.strikeChance().get()) {
            this.applyEffect(entity, attacker);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if ((Integer)this.cooldown().get() > 0) {
                    player.getCooldowns().addCooldown(stack.getItem(), (Integer)this.cooldown().get() * 20);
                }
            }
        }
    }

    protected abstract void applyEffect(LivingEntity var1, LivingEntity var2);

    @Override
    public boolean isNonCosmetic() {
        return !Mth.equal((double)((Double)this.strikeChance().get()), (double)0.0);
    }

    @Override
    public void addToTooltip(EquipmentAbility.TooltipWriter writer) {
        if (Mth.equal((double)((Double)this.strikeChance().get()), (double)1.0)) {
            writer.add(this.name + ".constant", new Object[0]);
        } else {
            writer.add(this.name + ".chance", Math.round((Double)this.strikeChance().get() * 100.0));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RetaliationEffect)) {
            return false;
        }
        RetaliationEffect that = (RetaliationEffect)o;
        return this.strikeChance.equals(that.strikeChance) && this.cooldown.equals(that.cooldown);
    }

    public int hashCode() {
        int result = this.strikeChance.hashCode();
        result = 31 * result + this.cooldown.hashCode();
        return result;
    }
}

