/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component.ability;

import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface EquipmentAbility {
    public boolean isNonCosmetic();

    default public void addToTooltip(TooltipWriter writer) {
        writer.addDefaultTooltipKey(new Object[0]);
    }

    public static class TooltipWriter {
        private final Consumer<Component> tooltip;
        private final String namespace;
        private final String path;
        private final Item.TooltipContext context;
        private final ItemStack stack;

        public TooltipWriter(DataComponentType<? extends EquipmentAbility> type, Consumer<Component> tooltip, Item.TooltipContext context, ItemStack stack) {
            this.tooltip = tooltip;
            ResourceLocation id = Objects.requireNonNull(BuiltInRegistries.DATA_COMPONENT_TYPE.getKey(type));
            this.namespace = id.getNamespace();
            this.path = id.getPath();
            this.context = context;
            this.stack = stack;
        }

        public Item.TooltipContext context() {
            return this.context;
        }

        public ItemStack stack() {
            return this.stack;
        }

        public TooltipWriter add(String identifier, Object ... args) {
            return this.addRaw((Component)Component.translatable((String)"%s.tooltip.ability.%s.%s".formatted(this.namespace, this.path, identifier), (Object[])args).withStyle(ChatFormatting.GRAY));
        }

        public TooltipWriter addDefaultTooltipKey(Object ... args) {
            return this.addRaw((Component)Component.translatable((String)"%s.tooltip.ability.%s".formatted(this.namespace, this.path), (Object[])args).withStyle(ChatFormatting.GRAY));
        }

        public TooltipWriter addRaw(Component component) {
            this.tooltip.accept(component);
            return this;
        }
    }
}

