/*
 * Decompiled with CFR 0.152.
 */
package ironfurnaces.container;

import ironfurnaces.container.slots.SlotHeater;
import ironfurnaces.items.ItemHeater;
import ironfurnaces.tileentity.BlockWirelessEnergyHeaterTile;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class BlockWirelessEnergyHeaterContainerBase
extends AbstractContainerMenu {
    protected BlockWirelessEnergyHeaterTile te;
    protected Player playerEntity;
    protected IItemHandler playerInventory;
    protected final Level world;

    public BlockWirelessEnergyHeaterContainerBase(MenuType<?> menuType, int windowId, Level world, BlockPos pos, Inventory playerInventory, Player player) {
        super(menuType, windowId);
        this.te = (BlockWirelessEnergyHeaterTile)world.getBlockEntity(pos);
        this.playerEntity = player;
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.world = playerInventory.player.level();
        this.trackPower();
        this.addSlot(new SlotHeater(this.te, 0, 80, 37));
        this.layoutPlayerInventorySlots(8, 84);
    }

    public int getEnergy() {
        return this.te.getEnergy();
    }

    public int getMaxEnergy() {
        return this.te.getCapacity();
    }

    private void trackPower() {
        this.addDataSlot(new DataSlot(){

            public int get() {
                return BlockWirelessEnergyHeaterContainerBase.this.getMaxEnergy();
            }

            public void set(int value) {
                BlockWirelessEnergyHeaterContainerBase.this.te.setMaxEnergy(value);
            }
        });
        this.addDataSlot(new DataSlot(){

            public int get() {
                return BlockWirelessEnergyHeaterContainerBase.this.getEnergy();
            }

            public void set(int value) {
                BlockWirelessEnergyHeaterContainerBase.this.te.setEnergy(value);
            }
        });
    }

    public int getEnergyScaled(int pixels) {
        int i = this.getEnergy();
        int j = this.getMaxEnergy();
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.addSlot((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (!(itemstack.getItem() instanceof ItemHeater)) {
                return ItemStack.EMPTY;
            }
            if (index < 1 ? !this.moveItemStackTo(itemstack1, 1, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, 1, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public boolean stillValid(Player p_38874_) {
        return this.te.stillValid(p_38874_);
    }
}

