/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.jade;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockBE;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.FurnaceHandler;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.SiloLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ItemView;
import snownee.jade.api.view.ViewGroup;

public class MultiblockInventoryDataProvider<T extends IMultiblockState>
implements IServerExtensionProvider<ItemStack>,
IClientExtensionProvider<ItemStack, ItemView> {
    @Nullable
    public List<ViewGroup<ItemStack>> getGroups(Accessor<?> accessor) {
        Object object = accessor.getTarget();
        if (object instanceof IMultiblockBE) {
            IMultiblockBE multiblockBE = (IMultiblockBE)object;
            IMultiblockBEHelper helper = multiblockBE.getHelper();
            List<ItemStack> list = null;
            Object State2 = helper.getState();
            if (State2 instanceof ProcessContext) {
                ProcessContext state = (ProcessContext)State2;
                list = MultiblockInventoryDataProvider.getFromInventory(state.getInventory());
            } else {
                State2 = helper.getState();
                if (State2 instanceof FurnaceHandler.IFurnaceEnvironment) {
                    FurnaceHandler.IFurnaceEnvironment state = (FurnaceHandler.IFurnaceEnvironment)State2;
                    list = MultiblockInventoryDataProvider.getFromInventory(state.getInventory());
                } else {
                    State2 = helper.getState();
                    if (State2 instanceof SiloLogic.State) {
                        SiloLogic.State state = (SiloLogic.State)State2;
                        list = List.of(new ItemStack((ItemLike)state.identStack.getItem(), state.storageAmount));
                    }
                }
            }
            if (list != null) {
                return List.of(new ViewGroup(list));
            }
        }
        return null;
    }

    private static List<ItemStack> getFromInventory(IItemHandlerModifiable inventory) {
        ArrayList list = Lists.newArrayList();
        for (int iSlot = 0; iSlot < inventory.getSlots(); ++iSlot) {
            ItemStack stack = inventory.getStackInSlot(iSlot);
            if (stack.isEmpty()) continue;
            stack = stack.copy();
            list.add(stack);
        }
        return list;
    }

    public List<ClientViewGroup<ItemView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<ItemStack>> list) {
        return ClientViewGroup.map(list, ItemView::new, null);
    }

    public ResourceLocation getUid() {
        return ImmersiveEngineering.rl("multiblock_inventory");
    }
}

