/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic.mixer;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.ComparatorManager;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.tool.MachineInterfaceHandler;
import blusunrize.immersiveengineering.client.fx.FluidSplashOptions;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.mixer.MixingProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInMachine;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.MixerShapes;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import blusunrize.immersiveengineering.common.register.IEParticles;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.inventory.MultiFluidTank;
import blusunrize.immersiveengineering.common.util.inventory.SlotwiseItemHandler;
import blusunrize.immersiveengineering.common.util.sound.MultiblockSound;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class MixerLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    private static final MultiblockFace OUTPUT_POS = new MultiblockFace(1, 0, 3, RelativeBlockFace.FRONT);
    public static final BlockPos REDSTONE_POS = new BlockPos(2, 1, 2);
    private static final CapabilityPosition FLUID_OUTPUT = new CapabilityPosition(1, 0, 2, RelativeBlockFace.BACK);
    private static final CapabilityPosition FLUID_INPUT = new CapabilityPosition(0, 0, 1, RelativeBlockFace.RIGHT);
    private static final CapabilityPosition ENERGY_INPUT = new CapabilityPosition(0, 1, 2, RelativeBlockFace.UP);
    private static final BlockPos ITEM_INPUT = new BlockPos(1, 1, 0);
    public static final int NUM_SLOTS = 8;
    public static final int ENERGY_CAPACITY = 16000;
    public static final int TANK_VOLUME = 8000;
    public static ResourceLocation MIF_CONDITION_TANK = IEApi.ieLoc("mixer/tank");

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        State state = context.getState();
        IMultiblockLevel level = context.getLevel();
        boolean rsEnabled = state.rsState.isEnabled(context);
        boolean active = state.processor.tickServer(state, level, rsEnabled);
        RecipeEnqueueState enqueueState = this.enqueueNewRecipes(state, level.getRawLevel());
        boolean updateFromOutput = this.outputFluids(state, enqueueState.foundRecipe);
        if (updateFromOutput || enqueueState.update || active != state.isActive) {
            state.isActive = active;
            context.markMasterDirty();
            context.requestMasterBESync();
        }
    }

    private RecipeEnqueueState enqueueNewRecipes(State state, Level rawLevel) {
        List processQueue = state.processor.getQueue();
        if (state.energy.getEnergyStored() <= 0 || processQueue.size() >= state.processor.getMaxQueueSize()) {
            return RecipeEnqueueState.NOP;
        }
        if (state.tank.getFluidAmount() <= 0) {
            return RecipeEnqueueState.NOP;
        }
        IntOpenHashSet usedInvSlots = new IntOpenHashSet();
        for (MultiblockProcess process : processQueue) {
            if (!(process instanceof MixingProcess)) continue;
            MixingProcess mixingProcess = (MixingProcess)process;
            for (int i : mixingProcess.getInputSlots()) {
                usedInvSlots.add(i);
            }
        }
        NonNullList components = NonNullList.withSize((int)8, (Object)ItemStack.EMPTY);
        for (int i = 0; i < components.size(); ++i) {
            if (usedInvSlots.contains(i)) continue;
            components.set(i, (Object)state.inventory.getStackInSlot(i));
        }
        boolean foundRecipe = false;
        boolean update = false;
        Object object = state.tank.fluids.iterator();
        while (object.hasNext()) {
            FluidStack fs = (FluidStack)object.next();
            RecipeHolder<MixerRecipe> recipe = MixerRecipe.findRecipe(rawLevel, fs, (NonNullList<ItemStack>)components);
            if (recipe == null) continue;
            foundRecipe = true;
            MultiblockProcessInMachine process = new MixingProcess(recipe, state.tank, ((MixerRecipe)recipe.value()).getUsedSlots(fs, (NonNullList<ItemStack>)components)).setInputTanks(0);
            if (!state.processor.addProcessToQueue(process, rawLevel, false)) continue;
            update = true;
        }
        return new RecipeEnqueueState(update, foundRecipe);
    }

    private boolean outputFluids(State state, boolean foundRecipe) {
        int fluidTypes = state.tank.getFluidTypes();
        if (fluidTypes <= 0 || fluidTypes <= 1 && foundRecipe && !state.outputAll) {
            return false;
        }
        IFluidHandler output = state.outputRef.get();
        if (output == null) {
            return false;
        }
        if (!state.outputAll) {
            FluidStack inTank = state.tank.getFluid();
            int maxAmount = Math.min(inTank.getAmount(), 1000);
            FluidStack out = inTank.copyWithAmount(maxAmount);
            int drained = output.fill(out, IFluidHandler.FluidAction.EXECUTE);
            state.tank.drain(drained, IFluidHandler.FluidAction.EXECUTE);
            return drained > 0;
        }
        int totalOut = 0;
        Iterator<FluidStack> it = state.tank.fluids.iterator();
        while (it.hasNext()) {
            FluidStack fs = it.next();
            if (fs == null) continue;
            int maxAmount = Math.min(fs.getAmount(), 1000 - totalOut);
            FluidStack out = fs.copyWithAmount(maxAmount);
            int drained = output.fill(out, IFluidHandler.FluidAction.EXECUTE);
            MultiFluidTank.drain(drained, fs, it, IFluidHandler.FluidAction.EXECUTE);
            if ((totalOut += drained) < 1000) continue;
            break;
        }
        return totalOut > 0;
    }

    @Override
    public void tickClient(IMultiblockContext<State> context) {
        State state = context.getState();
        if (!state.isActive) {
            return;
        }
        state.animation_agitator = (state.animation_agitator + 9.0f) % 360.0f;
        IMultiblockLevel level = context.getLevel();
        if (!state.isSoundPlaying.getAsBoolean()) {
            Vec3 soundPos = level.toAbsolute(new Vec3(1.5, 1.5, 1.5));
            state.isSoundPlaying = MultiblockSound.startSound(() -> state.isActive, context.isValid(), soundPos, IESounds.mixer, 0.075f);
        }
        if (state.tank.fluids.isEmpty()) {
            return;
        }
        FluidStack fs = state.tank.fluids.get(0);
        float amount = (float)fs.getAmount() / (float)state.tank.getCapacity() * 1.125f;
        Vec3 relativePos = new Vec3(2.0, 0.9375 + (double)amount, 1.0);
        Vec3 partPos = level.toAbsolute(relativePos);
        float r = ApiUtils.RANDOM.nextFloat() * 0.8125f;
        float angleRad = (float)Math.toRadians(state.animation_agitator);
        partPos = partPos.add((double)r * Math.cos(angleRad), 0.0, (double)r * Math.sin(angleRad));
        Level rawLevel = level.getRawLevel();
        for (int i = 0; i < 2; ++i) {
            if (ApiUtils.RANDOM.nextBoolean()) {
                rawLevel.addParticle((ParticleOptions)IEParticles.IE_BUBBLE.get(), partPos.x, partPos.y, partPos.z, 0.0, 0.0, 0.0);
                continue;
            }
            rawLevel.addParticle((ParticleOptions)new FluidSplashOptions(fs.getFluid()), partPos.x, partPos.y, partPos.z, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public void registerCapabilities(IMultiblockComponent.CapabilityRegistrar<State> register) {
        register.registerAtOrNull(Capabilities.EnergyStorage.BLOCK, ENERGY_INPUT, state -> state.energy);
        register.register(Capabilities.FluidHandler.BLOCK, (state, position) -> {
            if (FLUID_INPUT.equalsOrNullFace(position)) {
                return state.fluidInput;
            }
            if (FLUID_OUTPUT.equals(position)) {
                return state.fluidOutput;
            }
            return null;
        });
        register.register(Capabilities.ItemHandler.BLOCK, (state, position) -> ITEM_INPUT.equals((Object)position.posInMultiblock()) ? state.inventory : null);
        register.registerAtBlockPos(MachineInterfaceHandler.IMachineInterfaceConnection.CAPABILITY, REDSTONE_POS, state -> state.mifHandler);
    }

    @Override
    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems(state.inventory, drop);
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return MixerShapes.SHAPE_GETTER;
    }

    public static ComparatorManager<State> makeComparator() {
        return ComparatorManager.makeSimple(ComparatorManager.SimpleComparatorValue.inventory(State::getInventory, 0, 8), REDSTONE_POS);
    }

    static {
        MachineInterfaceHandler.copyOptions(MIF_CONDITION_TANK, MachineInterfaceHandler.BASIC_FLUID_IN);
    }

    public static class State
    implements IMultiblockState,
    ProcessContext.ProcessContextInMachine<MixerRecipe> {
        public final AveragingEnergyStorage energy = new AveragingEnergyStorage(16000);
        public final MultiFluidTank tank = new MultiFluidTank(8000);
        public final SlotwiseItemHandler inventory;
        public boolean outputAll;
        public final MultiblockProcessor.InMachineProcessor<MixerRecipe> processor;
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        public boolean isActive;
        public float animation_agitator = 0.0f;
        private BooleanSupplier isSoundPlaying = () -> false;
        private final Supplier<@Nullable IFluidHandler> outputRef;
        private final IFluidHandler fluidInput;
        private final IFluidHandler fluidOutput;
        private final MachineInterfaceHandler.IMachineInterfaceConnection mifHandler;

        public State(IInitialMultiblockContext<State> ctx) {
            this.inventory = SlotwiseItemHandler.makeWithGroups(List.of(new SlotwiseItemHandler.IOConstraintGroup(SlotwiseItemHandler.IOConstraint.NO_CONSTRAINT, 8)), ctx.getMarkDirtyRunnable());
            this.processor = new MultiblockProcessor.InMachineProcessor<MixerRecipe>(8, 0.0f, 8, ctx.getMarkDirtyRunnable(), MixerRecipe.RECIPES::getById);
            this.outputRef = ctx.getCapabilityAt(Capabilities.FluidHandler.BLOCK, OUTPUT_POS);
            this.fluidInput = ArrayFluidHandler.fillOnly(this.tank, ctx.getMarkDirtyRunnable());
            this.fluidOutput = ArrayFluidHandler.drainOnly(this.tank, ctx.getMarkDirtyRunnable());
            this.mifHandler = () -> new MachineInterfaceHandler.MachineCheckImplementation[]{new MachineInterfaceHandler.MachineCheckImplementation<BooleanSupplier>(() -> this.isActive, MachineInterfaceHandler.BASIC_ACTIVE), new MachineInterfaceHandler.MachineCheckImplementation<SlotwiseItemHandler>(this.inventory, MachineInterfaceHandler.BASIC_ITEM_IN), new MachineInterfaceHandler.MachineCheckImplementation<MultiFluidTank>(this.tank, MIF_CONDITION_TANK), new MachineInterfaceHandler.MachineCheckImplementation<AveragingEnergyStorage>(this.energy, MachineInterfaceHandler.BASIC_ENERGY)};
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            nbt.put("tank", (Tag)this.tank.writeToNBT(new CompoundTag(), provider));
            nbt.put("inventory", this.inventory.serializeNBT(provider));
            nbt.putBoolean("outputAll", this.outputAll);
            nbt.put("processor", this.processor.toNBT(provider));
        }

        @Override
        public void readSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.tank.readFromNBT(nbt.getCompound("tank"), provider);
            this.inventory.deserializeNBT(provider, nbt.getCompound("inventory"));
            this.outputAll = nbt.getBoolean("outputAll");
            this.processor.fromNBT(nbt.get("processor"), (getRecipe, data, p) -> new MixingProcess(getRecipe, data, this.tank), provider);
        }

        @Override
        public void writeSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            nbt.put("tank", (Tag)this.tank.writeToNBT(new CompoundTag(), provider));
            nbt.putBoolean("isActive", this.isActive);
            nbt.putFloat("animation_agitator", this.animation_agitator);
        }

        @Override
        public void readSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.tank.readFromNBT(nbt.getCompound("tank"), provider);
            this.isActive = nbt.getBoolean("isActive");
            this.animation_agitator = nbt.getFloat("animation_agitator");
        }

        @Override
        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }

        @Override
        public IItemHandlerModifiable getInventory() {
            return this.inventory.getRawHandler();
        }
    }

    private record RecipeEnqueueState(boolean update, boolean foundRecipe) {
        private static final RecipeEnqueueState NOP = new RecipeEnqueueState(false, false);
    }
}

