/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CagelampBlock
extends IEBaseBlock
implements IEBlockInterfaces.IBlockOverlayText {
    public static final Supplier<BlockBehaviour.Properties> PROPERTIES = () -> BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.METAL).strength(3.0f, 15.0f).lightLevel(b -> (Boolean)b.getValue((Property)IEProperties.ACTIVE) != false ? (Integer)b.getValue((Property)IEProperties.INT_16) : 0).noOcclusion();
    private static final Map<Direction, VoxelShape> SHAPES = ImmutableMap.builder().put((Object)Direction.DOWN, (Object)Shapes.box((double)0.1875, (double)0.3125, (double)0.1875, (double)0.8125, (double)1.0, (double)0.8125)).put((Object)Direction.UP, (Object)Shapes.box((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.6875, (double)0.8125)).put((Object)Direction.NORTH, (Object)Shapes.box((double)0.1875, (double)0.1875, (double)0.3125, (double)0.8125, (double)0.8125, (double)1.0)).put((Object)Direction.SOUTH, (Object)Shapes.box((double)0.1875, (double)0.1875, (double)0.0, (double)0.8125, (double)0.8125, (double)0.6875)).put((Object)Direction.WEST, (Object)Shapes.box((double)0.3125, (double)0.1875, (double)0.1875, (double)1.0, (double)0.8125, (double)0.8125)).put((Object)Direction.EAST, (Object)Shapes.box((double)0.0, (double)0.1875, (double)0.1875, (double)0.6875, (double)0.8125, (double)0.8125)).build();

    public CagelampBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    @Override
    protected BlockState getInitDefaultState() {
        return (BlockState)super.getInitDefaultState().setValue((Property)IEProperties.INT_16, (Comparable)Integer.valueOf(14));
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        state = (BlockState)((BlockState)((BlockState)state.setValue((Property)IEProperties.FACING_ALL, (Comparable)context.getClickedFace())).setValue((Property)IEProperties.INVERTED, (Comparable)Boolean.valueOf(false))).setValue((Property)IEProperties.ACTIVE, (Comparable)Boolean.valueOf(false));
        return state;
    }

    public void neighborChanged(BlockState blockState, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            this.updateActiveState(blockState, serverlevel, pos);
        }
    }

    @Override
    public void onIEBlockPlacedBy(BlockPlaceContext context, BlockState state) {
        Level level = context.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            this.updateActiveState(state, serverlevel, context.getClickedPos());
        }
    }

    @Override
    public ItemInteractionResult screwdriverUseSide(Direction side, Player player, InteractionHand hand, Level level, BlockPos pos, BlockHitResult hit) {
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            BlockState state = level.getBlockState(pos);
            if (player.isCrouching()) {
                this.updateActiveState((BlockState)state.cycle((Property)IEProperties.INVERTED), serverlevel, pos);
            } else {
                level.setBlock(pos, (BlockState)state.cycle((Property)IEProperties.INT_16), 3);
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    @Override
    public Component[] getOverlayText(@Nullable BlockState blockState, Player player, HitResult mop, boolean hammer) {
        if (blockState != null && Utils.isScrewdriver(player.getMainHandItem())) {
            return new Component[]{Component.translatable((String)"chat.immersiveengineering.info.light_level", (Object[])new Object[]{blockState.getValue((Property)IEProperties.INT_16)})};
        }
        return null;
    }

    public void updateActiveState(BlockState state, ServerLevel level, BlockPos pos) {
        boolean rsSignal = level.hasNeighborSignal(pos);
        boolean active = rsSignal ^ (Boolean)state.getValue((Property)IEProperties.INVERTED);
        if (active != (Boolean)state.getValue((Property)IEProperties.ACTIVE)) {
            state = (BlockState)state.cycle((Property)IEProperties.ACTIVE);
            level.playSound(null, pos, active ? SoundEvents.COPPER_BULB_TURN_ON : SoundEvents.COPPER_BULB_TURN_OFF, SoundSource.BLOCKS);
            level.setBlock(pos, state, 3);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{IEProperties.FACING_ALL, BlockStateProperties.WATERLOGGED, IEProperties.ACTIVE, IEProperties.INVERTED, IEProperties.INT_16});
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue((Property)IEProperties.FACING_ALL));
    }
}

