/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.level;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.hurts.sskirillss.relics.init.ConfigRegistry;
import it.hurts.sskirillss.relics.init.LootCodecRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class RelicLootModifier
extends LootModifier {
    public static final Supplier<MapCodec<RelicLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> RelicLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, RelicLootModifier::new)));
    public static final List<LootEntryCache> LOOT_ENTRIES = new ArrayList<LootEntryCache>();

    public RelicLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Entity entity = (Entity)context.getParamOrNull(LootContextParams.THIS_ENTITY);
        Vec3 vec = (Vec3)context.getParamOrNull(LootContextParams.ORIGIN);
        String table = context.getQueriedLootTableId().toString();
        if (vec == null || entity == null) {
            return generatedLoot;
        }
        RandomSource random = context.getRandom();
        if (random.nextDouble() > ConfigRegistry.LOOT_CONFIG.getRelicGenChance()) {
            return generatedLoot;
        }
        BlockPos pos = new BlockPos((int)vec.x(), (int)vec.y(), (int)vec.z());
        Level level = entity.level();
        ArrayList<LootEntryCache> entries = new ArrayList<LootEntryCache>();
        for (LootEntryCache entry : LOOT_ENTRIES) {
            if (!entry.getTables().stream().anyMatch(matcher -> matcher.matches(table)) || !entry.getDimensions().stream().anyMatch(matcher -> matcher.matches(level.dimension().location().toString())) || !entry.getBiomes().stream().anyMatch(matcher -> matcher.matches(level.getBiome(pos).getRegisteredName()))) continue;
            entries.add(entry);
        }
        if (entries.isEmpty()) {
            return generatedLoot;
        }
        double weight = entries.stream().mapToDouble(LootEntryCache::getWeight).sum();
        if (weight <= 0.0) {
            return generatedLoot;
        }
        double range = random.nextDouble() * weight;
        for (LootEntryCache entry : entries) {
            if (!((range -= (double)entry.getWeight()) <= 0.0)) continue;
            generatedLoot.add((Object)entry.getItem().getDefaultInstance());
            break;
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return (MapCodec)LootCodecRegistry.RELIC_LOOT.get();
    }

    public static void processRelicCache(IRelicItem relic) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        LOOT_ENTRIES.removeIf(entry -> entry.getItem() == relic);
        for (LootEntry entry2 : relic.getLootData().getEntries()) {
            Item item = relic.getItem();
            if (item == null) continue;
            LOOT_ENTRIES.add(new LootEntryCache(RelicLootModifier.compileRegex(entry2.getDimensions()), RelicLootModifier.compileRegex(entry2.getBiomes()), RelicLootModifier.compileRegex(entry2.getTables()), entry2.getWeight(), item));
        }
    }

    private static List<MatcherEntry> compileRegex(List<String> patterns) {
        ArrayList<MatcherEntry> entries = new ArrayList<MatcherEntry>();
        for (String pattern : patterns) {
            try {
                entries.add(new RegexEntry(Pattern.compile(pattern)));
            }
            catch (PatternSyntaxException e) {
                entries.add(new StringEntry(pattern));
            }
        }
        return entries;
    }

    public static class LootEntryCache {
        private List<MatcherEntry> dimensions;
        private List<MatcherEntry> biomes;
        private List<MatcherEntry> tables;
        private int weight;
        private Item item;

        public List<MatcherEntry> getDimensions() {
            return this.dimensions;
        }

        public List<MatcherEntry> getBiomes() {
            return this.biomes;
        }

        public List<MatcherEntry> getTables() {
            return this.tables;
        }

        public int getWeight() {
            return this.weight;
        }

        public Item getItem() {
            return this.item;
        }

        public void setDimensions(List<MatcherEntry> dimensions) {
            this.dimensions = dimensions;
        }

        public void setBiomes(List<MatcherEntry> biomes) {
            this.biomes = biomes;
        }

        public void setTables(List<MatcherEntry> tables) {
            this.tables = tables;
        }

        public void setWeight(int weight) {
            this.weight = weight;
        }

        public void setItem(Item item) {
            this.item = item;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LootEntryCache)) {
                return false;
            }
            LootEntryCache other = (LootEntryCache)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getWeight() != other.getWeight()) {
                return false;
            }
            List<MatcherEntry> this$dimensions = this.getDimensions();
            List<MatcherEntry> other$dimensions = other.getDimensions();
            if (this$dimensions == null ? other$dimensions != null : !((Object)this$dimensions).equals(other$dimensions)) {
                return false;
            }
            List<MatcherEntry> this$biomes = this.getBiomes();
            List<MatcherEntry> other$biomes = other.getBiomes();
            if (this$biomes == null ? other$biomes != null : !((Object)this$biomes).equals(other$biomes)) {
                return false;
            }
            List<MatcherEntry> this$tables = this.getTables();
            List<MatcherEntry> other$tables = other.getTables();
            if (this$tables == null ? other$tables != null : !((Object)this$tables).equals(other$tables)) {
                return false;
            }
            Item this$item = this.getItem();
            Item other$item = other.getItem();
            return !(this$item == null ? other$item != null : !this$item.equals(other$item));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LootEntryCache;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getWeight();
            List<MatcherEntry> $dimensions = this.getDimensions();
            result = result * 59 + ($dimensions == null ? 43 : ((Object)$dimensions).hashCode());
            List<MatcherEntry> $biomes = this.getBiomes();
            result = result * 59 + ($biomes == null ? 43 : ((Object)$biomes).hashCode());
            List<MatcherEntry> $tables = this.getTables();
            result = result * 59 + ($tables == null ? 43 : ((Object)$tables).hashCode());
            Item $item = this.getItem();
            result = result * 59 + ($item == null ? 43 : $item.hashCode());
            return result;
        }

        public String toString() {
            return "RelicLootModifier.LootEntryCache(dimensions=" + String.valueOf(this.getDimensions()) + ", biomes=" + String.valueOf(this.getBiomes()) + ", tables=" + String.valueOf(this.getTables()) + ", weight=" + this.getWeight() + ", item=" + String.valueOf(this.getItem()) + ")";
        }

        public LootEntryCache(List<MatcherEntry> dimensions, List<MatcherEntry> biomes, List<MatcherEntry> tables, int weight, Item item) {
            this.dimensions = dimensions;
            this.biomes = biomes;
            this.tables = tables;
            this.weight = weight;
            this.item = item;
        }
    }

    private static non-sealed class RegexEntry
    extends MatcherEntry {
        private Pattern entry;

        @Override
        public boolean matches(String input) {
            return this.entry.matcher(input).matches();
        }

        public Pattern getEntry() {
            return this.entry;
        }

        public void setEntry(Pattern entry) {
            this.entry = entry;
        }

        public String toString() {
            return "RelicLootModifier.RegexEntry(entry=" + String.valueOf(this.getEntry()) + ")";
        }

        public RegexEntry(Pattern entry) {
            this.entry = entry;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RegexEntry)) {
                return false;
            }
            RegexEntry other = (RegexEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Pattern this$entry = this.getEntry();
            Pattern other$entry = other.getEntry();
            return !(this$entry == null ? other$entry != null : !this$entry.equals(other$entry));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RegexEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Pattern $entry = this.getEntry();
            result = result * 59 + ($entry == null ? 43 : $entry.hashCode());
            return result;
        }
    }

    private static non-sealed class StringEntry
    extends MatcherEntry {
        private String entry;

        @Override
        public boolean matches(String input) {
            return this.entry.equals(input);
        }

        public String getEntry() {
            return this.entry;
        }

        public void setEntry(String entry) {
            this.entry = entry;
        }

        public String toString() {
            return "RelicLootModifier.StringEntry(entry=" + this.getEntry() + ")";
        }

        public StringEntry(String entry) {
            this.entry = entry;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StringEntry)) {
                return false;
            }
            StringEntry other = (StringEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$entry = this.getEntry();
            String other$entry = other.getEntry();
            return !(this$entry == null ? other$entry != null : !this$entry.equals(other$entry));
        }

        protected boolean canEqual(Object other) {
            return other instanceof StringEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $entry = this.getEntry();
            result = result * 59 + ($entry == null ? 43 : $entry.hashCode());
            return result;
        }
    }

    private static abstract sealed class MatcherEntry
    permits RegexEntry, StringEntry {
        private MatcherEntry() {
        }

        public abstract boolean matches(String var1);
    }

    @EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void onServerStarted(ServerStartedEvent event) {
            if (!LOOT_ENTRIES.isEmpty()) {
                return;
            }
            for (Map.Entry entry : BuiltInRegistries.ITEM.entrySet()) {
                Object v = entry.getValue();
                if (!(v instanceof IRelicItem)) continue;
                IRelicItem relic = (IRelicItem)v;
                RelicLootModifier.processRelicCache(relic);
            }
        }
    }
}

