/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.entities;

import it.hurts.octostudios.octolib.modules.particles.OctoRenderManager;
import it.hurts.octostudios.octolib.modules.particles.RenderProvider;
import it.hurts.octostudios.octolib.modules.particles.trail.TrailProvider;
import it.hurts.sskirillss.relics.entities.misc.ITargetableEntity;
import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.sync.S2CEntityTargetPacket;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ShadowGlaiveEntity
extends ThrowableProjectile
implements ITargetableEntity,
TrailProvider {
    private static final EntityDataAccessor<Integer> MAX_BOUNCES = SynchedEntityData.defineId(ShadowGlaiveEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> BOUNCES = SynchedEntityData.defineId(ShadowGlaiveEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.defineId(ShadowGlaiveEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> CHANCE = SynchedEntityData.defineId(ShadowGlaiveEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private Set<String> bouncedTargets = new HashSet<String>();
    private List<String> blacklistedTargets = new ArrayList<String>();
    @Nullable
    private LivingEntity currentTarget = null;
    @Nullable
    private LivingEntity lastTarget = null;

    public ShadowGlaiveEntity(EntityType<? extends ShadowGlaiveEntity> type, Level level) {
        super(type, level);
    }

    public void setMaxBounces(int maxBounces) {
        this.getEntityData().set(MAX_BOUNCES, (Object)maxBounces);
    }

    public int getMaxBounces() {
        return (Integer)this.getEntityData().get(MAX_BOUNCES);
    }

    public void setBounces(int bounces) {
        this.getEntityData().set(BOUNCES, (Object)bounces);
    }

    public int getBounces() {
        return (Integer)this.getEntityData().get(BOUNCES);
    }

    public void addBounces(int bounces) {
        this.setBounces(Math.clamp((long)(this.getBounces() + bounces), 0, this.getMaxBounces()));
    }

    public void setDamage(float damage) {
        this.getEntityData().set(DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getDamage() {
        return ((Float)this.getEntityData().get(DAMAGE)).floatValue();
    }

    public void setChance(float chance) {
        this.getEntityData().set(CHANCE, (Object)Float.valueOf(chance));
    }

    public float getChance() {
        return ((Float)this.getEntityData().get(CHANCE)).floatValue();
    }

    public List<LivingEntity> locateNearestTargets() {
        return EntityUtils.gatherPotentialTargets((Entity)this, LivingEntity.class, 16.0).filter(entity -> {
            Player player;
            Entity patt0$temp;
            return !(this.lastTarget != null && this.lastTarget.getStringUUID().equals(entity.getStringUUID()) || (patt0$temp = this.getOwner()) instanceof Player && EntityUtils.isAlliedTo((Entity)(player = (Player)patt0$temp), (Entity)entity));
        }).collect(Collectors.toList());
    }

    public void tick() {
        super.tick();
        Level level = this.getCommandSenderWorld();
        Vec3 particleCenter = this.position().add(this.getDeltaMovement().scale(-1.0));
        for (int i = 0; i < 5; ++i) {
            level.addParticle(ParticleUtils.constructSimpleSpark(new Color(50 + this.random.nextInt(100), 0, 150 + this.random.nextInt(100)), 0.1f + this.random.nextFloat() * 0.15f, 5 + this.random.nextInt(10), 0.85f), particleCenter.x() + (double)(MathUtils.randomFloat(this.random) * 0.25f), particleCenter.y(), particleCenter.z() + (double)(MathUtils.randomFloat(this.random) * 0.25f), 0.0, 0.0, 0.0);
        }
        LivingEntity currentTarget = this.getTarget();
        if (currentTarget != null && (this.position().distanceTo(currentTarget.position()) >= 16.0 || currentTarget.isDeadOrDying())) {
            currentTarget = null;
        }
        if (!level.isClientSide()) {
            LivingEntity potentialTarget = null;
            List<LivingEntity> candidateEntities = this.locateNearestTargets();
            candidateEntities.removeIf(entity -> this.blacklistedTargets.contains(entity.getStringUUID()));
            List<LivingEntity> targetEntities = candidateEntities.stream().filter(entity -> {
                String uuid = entity.getStringUUID();
                return !this.bouncedTargets.contains(uuid) && !this.blacklistedTargets.contains(uuid);
            }).toList();
            if (!targetEntities.isEmpty()) {
                potentialTarget = targetEntities.getFirst();
            } else if (!candidateEntities.isEmpty()) {
                this.bouncedTargets.clear();
                potentialTarget = candidateEntities.getFirst();
            }
            if (!(potentialTarget == null || currentTarget != null && currentTarget.getStringUUID().equals(potentialTarget.getStringUUID()))) {
                NetworkHandler.sendToClientsTrackingEntity(new S2CEntityTargetPacket(this.getId(), potentialTarget.getId()), (Entity)this);
                this.setTarget(potentialTarget);
                currentTarget = potentialTarget;
            }
        }
        if (currentTarget == null || currentTarget.isDeadOrDying() || this.tickCount >= 250 || this.getBounces() >= this.getMaxBounces()) {
            if (!level.isClientSide()) {
                this.discard();
            }
            return;
        }
        if (this.getEyePosition().distanceTo(currentTarget.getEyePosition()) <= 1.5) {
            currentTarget.invulnerableTime = 0;
            if (currentTarget.hurt(level.damageSources().thrown((Entity)this, this.getOwner()), this.getDamage())) {
                this.bouncedTargets.add(currentTarget.getStringUUID());
                this.lastTarget = currentTarget;
                this.setTarget(null);
                this.addBounces(1);
                if (this.random.nextDouble() <= (double)this.getChance()) {
                    ShadowGlaiveEntity entity2 = new ShadowGlaiveEntity((EntityType<? extends ShadowGlaiveEntity>)((EntityType)EntityRegistry.SHADOW_GLAIVE.get()), level);
                    entity2.setMaxBounces(this.getMaxBounces());
                    entity2.setBounces(this.getBounces());
                    entity2.setPos(this.getEyePosition());
                    entity2.setDamage(this.getDamage());
                    entity2.setOwner(this.getOwner());
                    level.addFreshEntity((Entity)entity2);
                }
            } else {
                this.blacklistedTargets.add(currentTarget.getStringUUID());
                this.setTarget(null);
            }
        } else {
            this.setDeltaMovement(currentTarget.getEyePosition().subtract(this.getEyePosition()).normalize());
        }
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        OctoRenderManager.registerProvider((RenderProvider)this);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(MAX_BOUNCES, (Object)10);
        builder.define(BOUNCES, (Object)0);
        builder.define(DAMAGE, (Object)Float.valueOf(1.0f));
        builder.define(CHANCE, (Object)Float.valueOf(-1.0f));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("max_bounces", this.getMaxBounces());
        tag.putInt("bounces", this.getBounces());
        tag.putFloat("damage", this.getDamage());
        tag.putFloat("chance", this.getChance());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setMaxBounces(tag.getInt("max_bounces"));
        this.setBounces(tag.getInt("bounces"));
        this.setDamage(tag.getFloat("damage"));
        this.setChance(tag.getFloat("chance"));
    }

    public boolean isPushedByFluid() {
        return false;
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    @Override
    @Nullable
    public LivingEntity getTarget() {
        return this.currentTarget;
    }

    @Override
    public void setTarget(LivingEntity target) {
        this.currentTarget = target;
    }

    public Vec3 getTrailPosition(float partialTicks) {
        return this.getPosition(partialTicks).add(this.getDeltaMovement().scale(-1.0));
    }

    public int getTrailUpdateFrequency() {
        return 1;
    }

    public boolean isTrailAlive() {
        return this.isAlive();
    }

    public boolean isTrailGrowing() {
        return this.getKnownMovement().length() >= (double)0.1f;
    }

    public int getTrailMaxLength() {
        return 5;
    }

    public int getTrailFadeInColor() {
        return -65281;
    }

    public int getTrailFadeOutColor() {
        return -2147483393;
    }

    public double getTrailScale() {
        return 0.15f;
    }

    public Set<String> getBouncedTargets() {
        return this.bouncedTargets;
    }
}

