/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.registry;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.brewing.IBrewingRecipe;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;

@EventBusSubscriber(modid="tombstone", bus=EventBusSubscriber.Bus.GAME)
public final class ModPotions {
    public static Holder<Potion> spectral = (Holder)Helper.unsafeNullCast();
    public static Holder<Potion> earthly_garden = (Holder)Helper.unsafeNullCast();
    public static Holder<Potion> bait = (Holder)Helper.unsafeNullCast();
    public static Holder<Potion> frostbite = (Holder)Helper.unsafeNullCast();
    public static Holder<Potion> darkness = (Holder)Helper.unsafeNullCast();
    public static Holder<Potion> discretion = (Holder)Helper.unsafeNullCast();
    public static Holder<Potion> restoration = (Holder)Helper.unsafeNullCast();
    public static Holder<Potion> weaver_walk = (Holder)Helper.unsafeNullCast();
    public static Holder<Potion> giant_strength = (Holder)Helper.unsafeNullCast();
    public static Holder<Potion> little_world = (Holder)Helper.unsafeNullCast();

    static void onRegister() {
        spectral = ModPotions.registerPotion(new Potion(new MobEffectInstance[0]), "spectral");
        earthly_garden = ModPotions.registerPotion(ModEffects.earthly_garden, "earthly_garden");
        bait = ModPotions.registerPotion(ModEffects.bait, "bait");
        frostbite = ModPotions.registerPotion(ModEffects.frostbite, "frostbite");
        darkness = ModPotions.registerPotion((Holder<MobEffect>)MobEffects.DARKNESS, "darkness");
        discretion = ModPotions.registerPotion(ModEffects.discretion, "discretion");
        restoration = ModPotions.registerPotion(ModEffects.restoration, "restoration");
        weaver_walk = ModPotions.registerPotion(ModEffects.weaver_walk, "weaver_walk");
        giant_strength = ModPotions.registerPotion(ModEffects.giant_strength, "giant_strength");
        little_world = ModPotions.registerPotion(ModEffects.little_world, "little_world");
    }

    private static Holder<Potion> registerPotion(Holder<MobEffect> effect, String name) {
        return ModPotions.registerPotion(new Potion(new MobEffectInstance[]{new MobEffectInstance(effect, ((MobEffect)effect.value()).isInstantenous() ? 1 : 9600, 4)}), name);
    }

    private static Holder<Potion> registerPotion(Potion potion, String name) {
        return Registry.registerForHolder((Registry)BuiltInRegistries.POTION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)name), (Object)potion);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBrewingRecipeRegister(RegisterBrewingRecipesEvent event) {
        PotionBrewing.Builder builder = event.getBuilder();
        builder.addMix(Potions.WATER, (Item)ModItems.grave_dust, spectral);
        builder.addRecipe((IBrewingRecipe)new ConfigurableBrewingRecipe(spectral, ModBlocks.thornveil.asItem(), earthly_garden, () -> SharedConfigTombstone.potions.allowEarthlyGarden.get()));
        builder.addRecipe((IBrewingRecipe)new ConfigurableBrewingRecipe(spectral, Items.OCHRE_FROGLIGHT, bait, () -> SharedConfigTombstone.potions.allowBait.get()));
        builder.addRecipe((IBrewingRecipe)new ConfigurableBrewingRecipe(spectral, Items.BLUE_ICE, frostbite, () -> SharedConfigTombstone.potions.allowFrostbite.get()));
        builder.addRecipe((IBrewingRecipe)new ConfigurableBrewingRecipe(spectral, Items.ECHO_SHARD, darkness, () -> SharedConfigTombstone.potions.allowDarkness.get()));
        builder.addRecipe((IBrewingRecipe)new ConfigurableBrewingRecipe(spectral, Items.PHANTOM_MEMBRANE, discretion, () -> SharedConfigTombstone.potions.allowDiscretion.get()));
        builder.addRecipe((IBrewingRecipe)new ConfigurableBrewingRecipe((Holder<Potion>)Potions.STRONG_HEALING, ModItems.grave_dust, restoration, () -> SharedConfigTombstone.potions.allowRestoration.get()));
        builder.addRecipe((IBrewingRecipe)new ConfigurableBrewingRecipe(spectral, Items.COBWEB, weaver_walk, () -> SharedConfigTombstone.potions.allowWeaverWalk.get()));
        builder.addRecipe((IBrewingRecipe)new ConfigurableBrewingRecipe(spectral, Items.RED_MUSHROOM, giant_strength, () -> SharedConfigTombstone.potions.allowGiantStrength.get()));
        builder.addRecipe((IBrewingRecipe)new ConfigurableBrewingRecipe(spectral, Items.BROWN_MUSHROOM, little_world, () -> SharedConfigTombstone.potions.allowLittleWorld.get()));
    }

    public static class ConfigurableBrewingRecipe
    implements IBrewingRecipe {
        private final ItemStack input;
        private final Item ingredient;
        private final ItemStack output;
        private final BooleanSupplier supplierEnabled;

        public ConfigurableBrewingRecipe(Holder<Potion> input, Item ingredient, Holder<Potion> output, BooleanSupplier supplierEnabled) {
            this.input = PotionContents.createItemStack((Item)Items.POTION, input);
            this.ingredient = ingredient;
            this.output = PotionContents.createItemStack((Item)Items.POTION, output);
            this.supplierEnabled = supplierEnabled;
        }

        public boolean isInput(ItemStack input) {
            return this.supplierEnabled.getAsBoolean() && this.input.is(input.getItem()) && Objects.equals(this.input.get(DataComponents.POTION_CONTENTS), input.get(DataComponents.POTION_CONTENTS));
        }

        public boolean isIngredient(ItemStack stack) {
            return this.supplierEnabled.getAsBoolean() && stack.is(this.ingredient);
        }

        public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
            return this.supplierEnabled.getAsBoolean() && this.isInput(input) && this.isIngredient(ingredient) ? this.getOutput().copy() : ItemStack.EMPTY;
        }

        private ItemStack getOutput() {
            return this.output;
        }
    }
}

