/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.registry;

import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.RegisterEvent;
import ovh.corail.tombstone.enchantment.ApplyBoneShieldEffect;
import ovh.corail.tombstone.enchantment.ApplyRandomBadEffect;
import ovh.corail.tombstone.enchantment.ApplyRandomBeneficialEffect;
import ovh.corail.tombstone.enchantment.ApplyStackableEffect;
import ovh.corail.tombstone.enchantment.CastSpectralBite;
import ovh.corail.tombstone.enchantment.StealRandomEffect;
import ovh.corail.tombstone.enchantment.SummonSpectralWolf;

public final class ModEnchantments {
    public static final ResourceKey<Enchantment> soulbound = ModEnchantments.key("soulbound");
    public static final ResourceKey<Enchantment> magic_siphon = ModEnchantments.key("magic_siphon");
    public static final ResourceKey<Enchantment> plague_bringer = ModEnchantments.key("plague_bringer");
    public static final ResourceKey<Enchantment> curse_of_bones = ModEnchantments.key("curse_of_bones");
    public static final ResourceKey<Enchantment> blessing = ModEnchantments.key("blessing");
    public static final ResourceKey<Enchantment> frostbite = ModEnchantments.key("frostbite");
    public static final ResourceKey<Enchantment> spectral_bite = ModEnchantments.key("spectral_bite");
    public static final ResourceKey<Enchantment> spectral_conjurer = ModEnchantments.key("spectral_conjurer");
    public static final ResourceKey<Enchantment> incurable_wounds = ModEnchantments.key("incurable_wounds");
    public static final ResourceKey<Enchantment> decrepitude = ModEnchantments.key("decrepitude");
    public static final ResourceKey<Enchantment> sanctified = ModEnchantments.key("sanctified");
    public static final ResourceKey<Enchantment> ruthless_strike = ModEnchantments.key("ruthless_strike");

    private static ResourceKey<Enchantment> key(String name) {
        return ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)name));
    }

    public static void onRegisterEnchantmentEntityEffect(RegisterEvent event) {
        event.register(Registries.ENCHANTMENT_ENTITY_EFFECT_TYPE, ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"apply_stackable_effect"), () -> ApplyStackableEffect.CODEC);
        event.register(Registries.ENCHANTMENT_ENTITY_EFFECT_TYPE, ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"apply_random_bad_effect"), () -> ApplyRandomBadEffect.CODEC);
        event.register(Registries.ENCHANTMENT_ENTITY_EFFECT_TYPE, ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"steal_random_effect"), () -> StealRandomEffect.CODEC);
        event.register(Registries.ENCHANTMENT_ENTITY_EFFECT_TYPE, ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"cast_spectral_bite"), () -> CastSpectralBite.CODEC);
        event.register(Registries.ENCHANTMENT_ENTITY_EFFECT_TYPE, ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"summon_spectral_wolf"), () -> SummonSpectralWolf.CODEC);
        event.register(Registries.ENCHANTMENT_ENTITY_EFFECT_TYPE, ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"apply_bone_shield_effect"), () -> ApplyBoneShieldEffect.CODEC);
        event.register(Registries.ENCHANTMENT_ENTITY_EFFECT_TYPE, ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"apply_random_beneficial_effect"), () -> ApplyRandomBeneficialEffect.CODEC);
    }

    public static Optional<Holder<Enchantment>> getEnchantmentHolder(ResourceKey<Enchantment> enchantmentRK, Level level) {
        return ModEnchantments.getEnchantmentHolder(enchantmentRK.location(), level);
    }

    public static Optional<Holder<Enchantment>> getEnchantmentHolder(ResourceLocation enchantmentRL, Level level) {
        return level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(enchantmentRL).map(Function.identity());
    }
}

