/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.recipe;

import java.util.stream.IntStream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.recipe.DisableableShapelessRecipe;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModSerializers;

public final class RecipeEnchantedGraveKey
extends DisableableShapelessRecipe {
    public RecipeEnchantedGraveKey(String group, CraftingBookCategory category, ItemStack result, NonNullList<Ingredient> ingredients) {
        super(group, category, result, ingredients);
    }

    @Override
    public boolean matches(CraftingInput inv, Level level) {
        return (Boolean)SharedConfigTombstone.magic_item.disableEnchantedGraveKeyRecipe.get() == false && super.matches(inv, level);
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registryAccess) {
        return IntStream.range(0, inv.size()).mapToObj(arg_0 -> ((CraftingInput)inv).getItem(arg_0)).filter(stack -> stack.is((Item)ModItems.grave_key)).findFirst().filter(stack -> !ModItems.grave_key.isEnchanted((ItemStack)stack)).map(key -> {
            ItemStack result = key.copy();
            result.set(ModDataComponents.ENCHANTED, (Object)true);
            return result;
        }).orElse(ItemStack.EMPTY);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height > 1;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return ModSerializers.ENCHANTED_GRAVE_KEY;
    }
}

