/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import ovh.corail.tombstone.helper.RitualFluteHandler;
import ovh.corail.tombstone.network.CMessageRitualFluteValidationResult;
import ovh.corail.tombstone.network.PacketHandler;

public record SMessageRitualFluteValidation(int[] notes) implements CustomPacketPayload
{
    static final StreamCodec<RegistryFriendlyByteBuf, SMessageRitualFluteValidation> STREAM_CODEC = StreamCodec.ofMember(SMessageRitualFluteValidation::encode, SMessageRitualFluteValidation::decode);
    static final CustomPacketPayload.Type<SMessageRitualFluteValidation> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"ritual_flute_validation"));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static SMessageRitualFluteValidation decode(RegistryFriendlyByteBuf buf) {
        return new SMessageRitualFluteValidation(buf.readVarIntArray());
    }

    static void encode(SMessageRitualFluteValidation msg, RegistryFriendlyByteBuf buf) {
        buf.writeVarIntArray(msg.notes);
    }

    static void handle(SMessageRitualFluteValidation msg, IPayloadContext ctx) {
        ServerPlayer serverPlayer = (ServerPlayer)ctx.player();
        PacketHandler.sendToPlayer(new CMessageRitualFluteValidationResult(RitualFluteHandler.validateSequence(serverPlayer, msg.notes)), serverPlayer);
    }
}

