/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.api.item.ISoulConsumer;
import ovh.corail.tombstone.capability.ServantUndeadHandler;
import ovh.corail.tombstone.combine.CombineUpgrade;
import ovh.corail.tombstone.combine.TooltipCombineUpgrade;
import ovh.corail.tombstone.command.CommandTBReviveFamiliar;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.event.EventFactory;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.helper.RegistryHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TamableType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.loot.IDelayedNBTLoot;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SMessageCombination;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemReceptacleOfFamiliar
extends ItemGeneric
implements ISoulConsumer,
IDelayedNBTLoot {
    private static final String DEAD_PET_NBT_COMPOUND = "dead_pet";

    public ItemReceptacleOfFamiliar() {
        super("receptacle_of_familiar", ItemReceptacleOfFamiliar.getBuilder().stacksTo(1).fireResistant(), () -> SharedConfigTombstone.allowed_magic_items.allowReceptacleOfFamiliar.get());
        this.withCombineInfo();
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Item.TooltipContext context, List<Component> tooltip) {
        String entityId = (String)stack.getOrDefault(ModDataComponents.ENTITY_TYPE, (Object)"");
        if (entityId.isEmpty()) {
            this.addItemDesc(tooltip, "1", new Object[0]);
            String id = this.getCapturableType(stack);
            if (!id.isEmpty()) {
                tooltip.add((Component)LangKey.MESSAGE_CAPTURABLE.getText(StyleType.MESSAGE_SPECIAL, new Object[]{LangKey.getEntityName(id)}));
            }
        } else {
            this.addItemDesc(tooltip, "2", LangKey.getEntityName(entityId));
            ResourceLocation rl = ResourceLocation.parse((String)entityId);
            Optional<LangKey> typeName = TamableType.getTypeLangKey(rl);
            tooltip.add((Component)LangKey.MESSAGE_TYPE.getText(typeName.isEmpty() ? StyleType.COLOR_RED : StyleType.COLOR_GREEN, new Object[]{typeName.orElse(LangKey.MESSAGE_UNKNOWN).getText(new Object[0]), Helper.capitalizeWord(rl.getNamespace())}));
            this.addItemUse(tooltip, this.getDurability(stack) == 0.0 ? "2" : "1", new Object[0]);
        }
        super.addTooltipInfo(stack, context, tooltip);
    }

    public boolean overrideOtherStackedOnMe(ItemStack receptacleOfFamiliar, ItemStack added, Slot slot, ClickAction action, Player player, SlotAccess slotAccess) {
        if (action == ClickAction.SECONDARY && EntityHelper.isValidPlayer(player) && slot.allowModification(player) && receptacleOfFamiliar.is((Item)this) && added.is((Item)ModItems.bone_needle)) {
            MutableComponent errorMessage;
            String entityType = ModItems.bone_needle.getEntityType(added);
            MutableComponent mutableComponent = entityType.isEmpty() ? LangKey.MESSAGE_NOT_IMPREGNATED.getText(added.getDisplayName()) : (errorMessage = !TamableType.isTamable(ResourceLocation.parse((String)entityType)) ? LangKey.NO_FAMILIAR_TO_REVIVE.getText(LangKey.getEntityName(entityType)) : null);
            if (errorMessage != null) {
                if (player.level().isClientSide) {
                    ProxyHelper.addToast(ModItems.bone_needle.impregnate(new ItemStack((ItemLike)ModItems.bone_needle), "minecraft:cat"), new ItemStack((ItemLike)this), (Component)errorMessage);
                }
            } else {
                boolean isServerSide;
                boolean bl = isServerSide = !player.level().isClientSide();
                if (isServerSide || player.isCreative()) {
                    this.setCapturableType(receptacleOfFamiliar, ModItems.bone_needle.getEntityType(added));
                    added.shrink(1);
                    if (isServerSide) {
                        ModTriggers.combine_in_inventory.trigger((ServerPlayer)player);
                        ModTriggers.impregnated_receptacle.trigger((ServerPlayer)player);
                    } else {
                        PacketHandler.sendToServer(new SMessageCombination(SMessageCombination.CombineType.RECEPTACLE_OF_FAMILIAR));
                    }
                }
            }
            return true;
        }
        return false;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(new TooltipCombineUpgrade(new CombineUpgrade(ModItems.bone_needle.impregnate(new ItemStack((ItemLike)ModItems.bone_needle), "minecraft:cat"), !this.hasCapturableType(stack))));
    }

    public Component getName(ItemStack stack) {
        return super.getName(stack).plainCopy().setStyle(StyleType.MESSAGE_SPECIAL);
    }

    @Override
    public boolean isFoil(ItemStack stack) {
        return this.containSoul(stack) || super.isFoil(stack);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        float healthMax;
        float health;
        if (!level.isClientSide() && stack.is((Item)this) && EntityHelper.isValidPlayer(entity) && TimeHelper.atInterval(entity, TimeHelper.tickFromSecond(30)) && this.containSoul(stack) && (health = this.getFamiliarHealth(stack)) < (healthMax = this.getFamiliarMaxHealth(stack))) {
            float gain = healthMax * 0.1f;
            stack.set(ModDataComponents.HEALTH, (Object)Float.valueOf(Math.min(health + gain, healthMax)));
        }
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged ? super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) : oldStack.getItem() != newStack.getItem();
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.containSoul(stack) && this.getDurability(stack) > 0.0;
    }

    public int getBarColor(ItemStack stack) {
        return Mth.hsvToRgb((float)(Math.max(0.0f, (float)(1.0 - this.getDurability(stack))) / 1.5f), (float)1.0f, (float)1.0f);
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f - (float)this.getDurability(stack) * 13.0f);
    }

    @Override
    public boolean canEnchant(Level level, BlockPos gravePos, Player player, ItemStack stack) {
        return this.isEnabled();
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return false;
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        if (!this.containSoul(stack)) {
            EntityHelper.setGlobalItemCooldown((Player)player, this, 10);
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_EMPTY_RECEPTACLE.getText(new Object[0]));
        }
        if (this.getDurability(stack) > 0.0) {
            EntityHelper.setGlobalItemCooldown((Player)player, this, 10);
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_RECOVERING_RECEPTACLE.getText(new Object[0]));
        }
        if (!this.revive((Player)player, gravePos, stack, false)) {
            stack.remove(ModDataComponents.ENTITY_TYPE);
            stack.remove(ModDataComponents.HEALTH);
            stack.remove(ModDataComponents.HEALTH_MAX);
            stack.remove(ModDataComponents.IS_LOOT_NO_SYNC);
            ModDataComponents.getCompoundTag(stack).remove(DEAD_PET_NBT_COMPOUND);
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_CANT_REVIVE_FAMILIAR.getText(LangKey.MESSAGE_YOUR_FAMILIAR.getText(new Object[0])));
        }
        ModTriggers.revive_familiar.trigger(player);
        stack.shrink(1);
        return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_REVIVE_FAMILIAR.getText(LangKey.MESSAGE_YOUR_FAMILIAR.getText(new Object[0])), 1);
    }

    @Override
    public int getKnowledge() {
        return 5;
    }

    @Override
    public int getCorruptionLevel(ItemStack stack) {
        return this.containSoul(stack) ? 10 : 0;
    }

    private double getDurability(ItemStack stack) {
        if (this.containSoul(stack)) {
            double health = this.getFamiliarHealth(stack);
            double healthMax = this.getFamiliarMaxHealth(stack);
            return 1.0 - health / healthMax;
        }
        return 1.0;
    }

    private float getFamiliarHealth(ItemStack stack) {
        return Math.max(0.0f, ((Float)stack.getOrDefault(ModDataComponents.HEALTH, (Object)Float.valueOf(1.0f))).floatValue());
    }

    private float getFamiliarMaxHealth(ItemStack stack) {
        return Math.max(1.0f, ((Float)stack.getOrDefault(ModDataComponents.HEALTH_MAX, (Object)Float.valueOf(1.0f))).floatValue());
    }

    public boolean containSoul(ItemStack stack) {
        return !((String)stack.getOrDefault(ModDataComponents.ENTITY_TYPE, (Object)"")).isEmpty();
    }

    private Optional<CompoundTag> getDeadPetTag(ItemStack stack) {
        CompoundTag compoundTag = ModDataComponents.getCompoundTag(stack);
        return Optional.of(compoundTag).filter(tag -> tag.contains(DEAD_PET_NBT_COMPOUND, 10)).map(tag -> tag.getCompound(DEAD_PET_NBT_COMPOUND));
    }

    public boolean revive(Player player, BlockPos gravePos, ItemStack stack, boolean unequip) {
        String entityId = (String)stack.getOrDefault(ModDataComponents.ENTITY_TYPE, (Object)"");
        if (entityId.isEmpty()) {
            return false;
        }
        EntityType entityType = EntityType.byString((String)entityId).orElse(null);
        if (entityType == null) {
            return false;
        }
        LivingEntity entity = (LivingEntity)entityType.create(player.level());
        if (entity == null) {
            return false;
        }
        @Nullable TamableType tamableType = TamableType.getType(ResourceLocation.parse((String)entityId));
        if (tamableType == null) {
            return false;
        }
        if (((Boolean)stack.getOrDefault(ModDataComponents.IS_LOOT_NO_SYNC, (Object)false)).booleanValue() && tamableType == TamableType.UNDEAD && Helper.RANDOM.nextInt(10) == 0) {
            ServantUndeadHandler.setSpellCaster((Entity)entity, ServantUndeadHandler.CasterType.getRandomId());
        }
        Optional<CompoundTag> deadPetTag = this.getDeadPetTag(stack);
        boolean hasData = false;
        if (deadPetTag.isPresent()) {
            try {
                entity.load(deadPetTag.get());
                hasData = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        entity.setPos((double)gravePos.getX() + 0.5, (double)gravePos.getY() + 0.5, (double)gravePos.getZ() + 0.5);
        if (!hasData && entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.finalizeSpawn((ServerLevelAccessor)((ServerLevel)player.level()), player.level().getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.TRIGGERED, null);
        }
        entity.setHealth(entity.getMaxHealth());
        if (unequip) {
            IItemHandler itemHandler = InventoryHelper.getItemHandler((Entity)entity);
            IntStream.range(0, itemHandler.getSlots()).forEach(slot -> {
                ItemStack currentStack = itemHandler.getStackInSlot(slot);
                if (!currentStack.isEmpty()) {
                    itemHandler.extractItem(slot, currentStack.getCount(), false);
                }
            });
            if (entity instanceof AbstractChestedHorse) {
                ((AbstractChestedHorse)entity).setChest(false);
            }
        }
        tamableType.setTamedBy(player, entity);
        EffectHelper.clearBadEffects(entity);
        entity.unRide();
        player.level().addFreshEntity((Entity)entity);
        return true;
    }

    public boolean hasCapturableType(ItemStack stack) {
        return !this.getCapturableType(stack).isEmpty();
    }

    public String getCapturableType(ItemStack stack) {
        return (String)stack.getOrDefault(ModDataComponents.CAPTURABLE_ENTITY_TYPE, (Object)"");
    }

    public ItemStack setCapturableType(ItemStack stack, String type) {
        if (stack.is((Item)this)) {
            stack.set(ModDataComponents.CAPTURABLE_ENTITY_TYPE, (Object)type);
        }
        return stack;
    }

    private boolean canCaptureSoul(ItemStack stack, LivingEntity entity) {
        String type = this.getCapturableType(stack);
        return type.isEmpty() || type.equals(RegistryHelper.getRegistryString((Entity)entity));
    }

    public boolean captureSoul(LivingEntity entity) {
        Mob mob;
        boolean hasReceptacle;
        boolean wasOffline;
        if (entity.level().isClientSide()) {
            return false;
        }
        ResourceLocation entityId = RegistryHelper.getRegistryName(entity.getType());
        if (entityId == null) {
            return false;
        }
        TamableType tamableType = TamableType.getType(entityId);
        if (tamableType == null) {
            return false;
        }
        UUID ownerId = tamableType.getOwnerId(entity);
        MinecraftServer server = entity.getServer();
        if (ownerId == null || server == null) {
            return false;
        }
        @Nullable ServerPlayer owner = server.getPlayerList().getPlayer(ownerId);
        boolean bl = wasOffline = owner == null;
        if (wasOffline && (owner = EntityHelper.getOfflinePlayer(server, ownerId)) == null) {
            return false;
        }
        ItemStack receptacle = owner.isAlive() ? InventoryHelper.findFirstInInventory((Player)owner, stack -> stack.is((Item)this) && this.canCaptureSoul((ItemStack)stack, entity) && !this.containSoul((ItemStack)stack)) : ItemStack.EMPTY;
        boolean bl2 = hasReceptacle = !receptacle.isEmpty();
        if (hasReceptacle && EventFactory.onCaptureSoul((Player)owner, entity)) {
            hasReceptacle = false;
        }
        if (entity.isSleeping()) {
            entity.stopSleeping();
        }
        if (entity.isPassenger()) {
            entity.stopRiding();
        }
        if (entity.isVehicle()) {
            entity.ejectPassengers();
        }
        if (entity instanceof Mob && (mob = (Mob)entity).isLeashed()) {
            mob.dropLeash(true, false);
        }
        CompoundTag pet_tag = entity.serializeNBT((HolderLookup.Provider)entity.level().registryAccess());
        pet_tag.remove("Dimension");
        pet_tag.remove("Motion");
        pet_tag.remove("UUID");
        pet_tag.remove("UpdateBlocked");
        if (!hasReceptacle) {
            CommandTBReviveFamiliar.saveFamiliar(server, ownerId, pet_tag, entity.getUUID().toString());
            return false;
        }
        IItemHandler itemHandler = InventoryHelper.getItemHandler((Entity)entity);
        IntStream.range(0, itemHandler.getSlots()).forEach(slot -> {
            ItemStack currentStack = itemHandler.getStackInSlot(slot);
            if (!currentStack.isEmpty()) {
                itemHandler.extractItem(slot, currentStack.getCount(), false);
            }
        });
        tamableType.onCapture(entity, pet_tag);
        receptacle.set(ModDataComponents.ENTITY_TYPE, (Object)entityId.toString());
        receptacle.set(ModDataComponents.HEALTH, (Object)Float.valueOf(0.0f));
        receptacle.set(ModDataComponents.HEALTH_MAX, (Object)Float.valueOf(entity.getMaxHealth()));
        ModDataComponents.getCompoundTag(receptacle).put(DEAD_PET_NBT_COMPOUND, (Tag)pet_tag);
        if (wasOffline) {
            EntityHelper.writePlayerData(server, (Player)owner);
        } else {
            LangKey.MESSAGE_CAPTURE_FAMILIAR.sendSpecialMessage((Player)owner, entity.getName());
            ModTriggers.capture_soul.trigger(owner);
        }
        return true;
    }

    public ItemStack setRandomFamiliar(ItemStack stack) {
        if (stack.is((Item)this)) {
            stack.set(ModDataComponents.ENTITY_TYPE, (Object)BuiltInRegistries.ENTITY_TYPE.getKey(TamableType.getRandomTamableEntityType()).toString());
            stack.set(ModDataComponents.IS_LOOT_NO_SYNC, (Object)true);
        }
        return stack;
    }

    public ItemStack createReceptacleWithFamiliar(ResourceLocation id) {
        ItemStack receptacle = new ItemStack((ItemLike)this);
        receptacle.set(ModDataComponents.ENTITY_TYPE, (Object)id.toString());
        receptacle.set(ModDataComponents.IS_LOOT_NO_SYNC, (Object)true);
        return receptacle;
    }

    @Override
    public ItemStack onDelayedLoot(ItemStack stack, LootContext context) {
        return this.setRandomFamiliar(stack);
    }
}

