/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.api.item.ISoulConsumer;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.RegistryHelper;
import ovh.corail.tombstone.item.ItemBook;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemBookOfRecycling
extends ItemBook {
    public ItemBookOfRecycling() {
        super("book_of_recycling", () -> SharedConfigTombstone.allowed_magic_items.allowBookOfRecycling.get());
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        ItemStack mainhand;
        if (stack.getItem() != this || (mainhand = player.getMainHandItem()).isEmpty()) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_RECYCLING_FAILED.getText(new Object[0]));
        }
        if (Helper.containRL((List)ConfigTombstone.magic_item.deniedItemToRecycle.get(), RegistryHelper.getRegistryName(mainhand.getItem()))) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_RECYCLING_DENIED.getText(new Object[0]));
        }
        if (mainhand.isDamaged() && !((Boolean)ConfigTombstone.magic_item.canRecycleDamagedItem.get()).booleanValue()) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_CANT_RECYCLE_DAMAGED.getText(new Object[0]));
        }
        if (mainhand.has(DataComponents.CONTAINER) || mainhand.has(DataComponents.BUNDLE_CONTENTS)) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_CANT_RECYCLE_CONTAINER.getText(new Object[0]));
        }
        NonNullList ingredients = NonNullList.create();
        ItemStack recipeResult = this.checkAdditionalRecipes(mainhand.getItem(), (List<ItemStack>)ingredients);
        if (recipeResult.isEmpty()) {
            DataComponentPatch mainhandComponentsPatch = mainhand.getComponentsPatch();
            CraftingRecipe recipe = Objects.requireNonNull(player.getServer()).getRecipeManager().getAllRecipesFor(RecipeType.CRAFTING).stream().map(RecipeHolder::value).filter(r -> {
                ItemStack result = r.getResultItem((HolderLookup.Provider)level.registryAccess());
                return result.is(mainhand.getItem()) && Helper.hasDataComponentPatch(mainhandComponentsPatch, result.getComponentsPatch());
            }).max(Comparator.comparingLong(r -> r.getIngredients().stream().filter(i -> !i.isEmpty()).count())).orElse(null);
            if (recipe == null) {
                return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_NO_RECIPE_TO_RECYCLE.getText(new Object[0]));
            }
            if (recipe.getResultItem((HolderLookup.Provider)level.registryAccess()).getCount() > mainhand.getCount()) {
                return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_RECYCLING_NOT_ENOUGH.getText(new Object[0]));
            }
            int count = recipe.getIngredients().size();
            NonNullList grid = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
            for (int slotId2 = 0; slotId2 < count; ++slotId2) {
                ItemStack[] items;
                ItemStack result;
                Ingredient ing = (Ingredient)recipe.getIngredients().get(slotId2);
                if (ing.isEmpty() || (result = (items = ing.getItems())[Helper.RANDOM.nextInt(items.length)]).isEmpty()) continue;
                grid.set(slotId2, (Object)result.copy());
            }
            NonNullList remains = recipe.getRemainingItems((RecipeInput)CraftingInput.of((int)3, (int)3, (List)grid));
            IntStream.range(0, count).filter(slotId -> ((ItemStack)remains.get(slotId)).isEmpty()).mapToObj(arg_0 -> ((NonNullList)grid).get(arg_0)).filter(i -> !i.isEmpty()).forEach(((List)ingredients)::add);
            recipeResult = recipe.getResultItem((HolderLookup.Provider)level.registryAccess());
        }
        if (ingredients.isEmpty()) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_NO_RECIPE_TO_RECYCLE.getText(new Object[0]));
        }
        int maxRecycle = mainhand.getCount() / recipeResult.getCount();
        stack.shrink(1);
        mainhand.shrink(recipeResult.getCount() * maxRecycle);
        for (ItemStack ingredient : ingredients) {
            int count = ingredient.getCount() * maxRecycle;
            int maxSize = ingredient.getMaxStackSize();
            int fullStacks = count / maxSize;
            for (int i2 = 0; i2 < fullStacks; ++i2) {
                ItemStack newStack = ingredient.copy();
                newStack.setCount(maxSize);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)newStack);
            }
            int left = count - fullStacks * maxSize;
            if (left <= 0) continue;
            ItemStack leftStack = ingredient.copy();
            leftStack.setCount(left);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)leftStack);
        }
        ModTriggers.use_recycling.trigger(player);
        return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_RECYCLING_SUCCESS.getText(new Object[0]), 1);
    }

    private ItemStack checkAdditionalRecipes(Item searchItem, List<ItemStack> ingredients) {
        if (searchItem == Items.LEATHER_HORSE_ARMOR) {
            ingredients.add(new ItemStack((ItemLike)Items.LEATHER, 7));
            return new ItemStack((ItemLike)Items.LEATHER_HORSE_ARMOR);
        }
        if (searchItem == Items.IRON_HORSE_ARMOR) {
            ingredients.add(new ItemStack((ItemLike)Items.IRON_INGOT, 7));
            return new ItemStack((ItemLike)Items.IRON_HORSE_ARMOR);
        }
        if (searchItem == Items.GOLDEN_HORSE_ARMOR) {
            ingredients.add(new ItemStack((ItemLike)Items.GOLD_INGOT, 7));
            return new ItemStack((ItemLike)Items.GOLDEN_HORSE_ARMOR);
        }
        if (searchItem == Items.DIAMOND_HORSE_ARMOR) {
            ingredients.add(new ItemStack((ItemLike)Items.DIAMOND, 7));
            return new ItemStack((ItemLike)Items.DIAMOND_HORSE_ARMOR);
        }
        if (searchItem == Items.NETHERITE_AXE || searchItem == Items.NETHERITE_PICKAXE) {
            ingredients.add(new ItemStack((ItemLike)Items.DIAMOND, 3));
            ingredients.add(new ItemStack((ItemLike)Items.STICK, 2));
            ingredients.add(new ItemStack((ItemLike)Items.NETHERITE_INGOT));
            return new ItemStack((ItemLike)searchItem);
        }
        if (searchItem == Items.NETHERITE_SWORD) {
            ingredients.add(new ItemStack((ItemLike)Items.DIAMOND, 2));
            ingredients.add(new ItemStack((ItemLike)Items.STICK));
            ingredients.add(new ItemStack((ItemLike)Items.NETHERITE_INGOT));
            return new ItemStack((ItemLike)Items.NETHERITE_SWORD);
        }
        if (searchItem == Items.NETHERITE_HOE) {
            ingredients.add(new ItemStack((ItemLike)Items.DIAMOND, 2));
            ingredients.add(new ItemStack((ItemLike)Items.STICK, 2));
            ingredients.add(new ItemStack((ItemLike)Items.NETHERITE_INGOT));
            return new ItemStack((ItemLike)Items.NETHERITE_HOE);
        }
        if (searchItem == Items.NETHERITE_SHOVEL) {
            ingredients.add(new ItemStack((ItemLike)Items.DIAMOND));
            ingredients.add(new ItemStack((ItemLike)Items.STICK, 2));
            ingredients.add(new ItemStack((ItemLike)Items.NETHERITE_INGOT));
            return new ItemStack((ItemLike)Items.NETHERITE_SHOVEL);
        }
        if (searchItem == Items.NETHERITE_BOOTS) {
            ingredients.add(new ItemStack((ItemLike)Items.DIAMOND, 4));
            ingredients.add(new ItemStack((ItemLike)Items.NETHERITE_INGOT));
            return new ItemStack((ItemLike)Items.NETHERITE_BOOTS);
        }
        if (searchItem == Items.NETHERITE_HELMET) {
            ingredients.add(new ItemStack((ItemLike)Items.DIAMOND, 5));
            ingredients.add(new ItemStack((ItemLike)Items.NETHERITE_INGOT));
            return new ItemStack((ItemLike)Items.NETHERITE_HELMET);
        }
        if (searchItem == Items.NETHERITE_CHESTPLATE) {
            ingredients.add(new ItemStack((ItemLike)Items.DIAMOND, 8));
            ingredients.add(new ItemStack((ItemLike)Items.NETHERITE_INGOT));
            return new ItemStack((ItemLike)Items.NETHERITE_CHESTPLATE);
        }
        if (searchItem == Items.NETHERITE_LEGGINGS) {
            ingredients.add(new ItemStack((ItemLike)Items.DIAMOND, 7));
            ingredients.add(new ItemStack((ItemLike)Items.NETHERITE_INGOT));
            return new ItemStack((ItemLike)Items.NETHERITE_LEGGINGS);
        }
        return ItemStack.EMPTY;
    }
}

