/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.io.Files;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.helper.StorageHelper;

public final class UpdaterHandler {
    public static final UpdaterHandler instance = new UpdaterHandler();
    private boolean hasVersionChanged = false;

    private UpdaterHandler() {
    }

    private boolean hasVersionChanged() {
        return this.hasVersionChanged;
    }

    private boolean requireUpdate(PoolType poolType) {
        return false;
    }

    public void checkVersion() {
        File tombstoneFolder = StorageHelper.getTombstoneConfigFolder();
        tombstoneFolder.mkdirs();
        File file = new File(tombstoneFolder, "version.info");
        if (file.exists()) {
            try {
                if ("9.4.8".equals(StorageHelper.load(file))) {
                    this.hasVersionChanged = false;
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        StorageHelper.save(file, "9.4.8");
        this.hasVersionChanged = true;
    }

    private File getFile(PoolType poolType, boolean isBakFile) {
        File folder = new File(StorageHelper.getTombstoneConfigFolder(), "loottables");
        folder.mkdirs();
        return new File(folder, String.format("%s-pool-%s.%s", "tombstone", poolType.filename, isBakFile ? "bak" : "json"));
    }

    @Nullable
    public LootPool loadLootPool(PoolType poolType) {
        if (!this.requireUpdate(poolType) || !this.hasVersionChanged()) {
            return (LootPool)StorageHelper.load(LootPool.CODEC, this.getFile(poolType, false));
        }
        return null;
    }

    public void saveLootPool(PoolType poolType, LootPool lootPool) {
        File file = this.getFile(poolType, false);
        if (file.exists() && this.requireUpdate(poolType) && this.hasVersionChanged()) {
            File bakFile = this.getFile(poolType, true);
            try {
                Files.copy((File)file, (File)bakFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        StorageHelper.save(LootPool.CODEC, file, lootPool, true);
    }

    public LoottableList loadChestLootTables() {
        File file = this.getChestLootTableFile(false);
        @Nullable LoottableList result = StorageHelper.load(LoottableList.CODEC, file);
        if (result != null) {
            return result;
        }
        LoottableList list = new LoottableList(BuiltInLootTables.all().stream().filter(rk -> rk != BuiltInLootTables.SPAWN_BONUS_CHEST).map(ResourceKey::location).filter(rl -> rl.getNamespace().equals("minecraft")).filter(rl -> rl.getPath().startsWith("chests") && !rl.getPath().startsWith("chests/village/")).collect(Collectors.toList()));
        this.saveChestLootTables(list);
        return list;
    }

    private void saveChestLootTables(LoottableList lootTables) {
        File file = this.getChestLootTableFile(false);
        if (file.exists()) {
            File bakFile = this.getChestLootTableFile(true);
            try {
                Files.copy((File)file, (File)bakFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        StorageHelper.save(LoottableList.CODEC, file, lootTables, true);
    }

    private File getChestLootTableFile(boolean isBakFile) {
        File folder = new File(StorageHelper.getTombstoneConfigFolder(), "loottables");
        folder.mkdirs();
        return new File(folder, String.format("%s-table-%s.%s", "tombstone", PoolType.CHEST_TREASURE.filename, isBakFile ? "bak" : "json"));
    }

    public static enum PoolType {
        ARCHAEOLOGY("archaeology"),
        LOST_TREASURE("lost_treasure"),
        CAT_MORNING("cat_morning"),
        CHEST_TREASURE("chest_treasure"),
        UNDEAD_MOB("undead_mob"),
        UNDEAD_BOSS("undead_boss"),
        SEEKER_ROD("seeker_rod"),
        SNIFFER_DIGGING("sniffer_digging"),
        ABANDONED_GRAVE("abandoned_grave");

        private final String filename;

        private PoolType(String filename) {
            this.filename = filename.toLowerCase(Locale.ROOT);
        }

        public String getFilename() {
            return this.filename;
        }
    }

    public record LoottableList(List<ResourceLocation> loottables) {
        public static final Codec<LoottableList> CODEC = RecordCodecBuilder.create(c -> c.group((App)ResourceLocation.CODEC.listOf().fieldOf("loottables").forGetter(LoottableList::loottables)).apply((Applicative)c, LoottableList::new));

        public boolean contains(ResourceLocation rl) {
            if (rl == null) {
                return false;
            }
            return this.loottables().contains(rl);
        }

        public void clear() {
            this.loottables().clear();
        }
    }
}

