/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity.ai.spell;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import ovh.corail.tombstone.capability.SpellCasterHandler;

public class SpellCastingGoal
extends Goal {
    protected final PathfinderMob caster;

    public SpellCastingGoal(PathfinderMob caster) {
        this.caster = caster;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return SpellCasterHandler.isCasting((LivingEntity)this.caster);
    }

    public void start() {
        this.caster.getNavigation().stop();
    }

    public void tick() {
        this.caster.getNavigation().stop();
        this.caster.setDeltaMovement(this.caster.getDeltaMovement().multiply(0.0, 1.0, 0.0));
        LivingEntity target = SpellCasterHandler.getSpecialTarget((LivingEntity)this.caster).orElse(this.caster.getTarget());
        if (target != null) {
            this.caster.getLookControl().setLookAt((Entity)target, (float)this.caster.getMaxHeadYRot(), (float)this.caster.getMaxHeadXRot());
        }
    }
}

